PAGE	84,132
TITLE	DateStr - write date string to stdout
SUBTTL	PL Glatz        version 1.00  6/29/86

COMMENT *

	This utility will write as ascii string of the system date
	to stdout, in the form YYMMDD.

*


DosInt		EQU	21H		;DOS function call entry
StackDepth 	EQU	256		;depth of stack, in words
StdOUt		EQU	1		;stdout stream
DateStringLength EQU	6		;length of date string

; DOS function calls:
SysDate		EQU	2AH		;get system date
WriteStr	EQU	40H		;write string to device
Terminate	EQU	4CH		;terminate program


; macro to perform function call
DosCall	MACRO	service
	MOV	AH,service
	INT	DosInt
	ENDM

; macro to switch ES:DI with DS:SI
SwitchPtrs MACRO
	PUSH	DS
	PUSH	ES
	POP	DS
	POP	ES
	XCHG	SI,DI
	ENDM


;	============ Code segment ==============

code	SEGMENT PARA PUBLIC
	ASSUME  CS:code, DS:data, ES:data


DateStr	PROC    FAR          		;start of main procedure block
	MOV     AX,data
	MOV     ES,AX        		;set up ES & DS to data segment
	MOV	DS,AX
	CLD				;reset direction

	CALL	GetDate			;return current date in CX
	MOV	DI,OFFSET data:DateField	;ES:DI -> date conversion buffer
	CALL	DateToStr		;convert to string

	MOV	BX,StdOut
	MOV	CX,DateStringLength
	MOV	DX,OFFSET data:DateField	;ES:DI -> date conversion buffer
	DosCall	WriteStr		;write string to std out
	XOR	AL,AL			;errorlevel=0
	DosCall	Terminate		;exit back to DOS
DateStr ENDP

;	================ System utilities ==============

; Return system date
;	ENTRY:
;		none
;	EXIT:
;		CX = year  (1980-2099)
;		DH = month (1-12)
;		DL = day   (1-31)
;		AL = day of week (0-6 = sun-sat)


GetDate	PROC	NEAR
	DosCall SysDate
	RET
GetDate	ENDP




; Convert date to string
;	ENTRY:
;		CX = year  (1980-2099)
;		DH = month (1-12)
;		DL = day   (1-31)
;		ES:DI -> where to build string
;	EXIT:
;		ES:DI -> string, format = YYMMDD


DateToStr	PROC	NEAR
	PUSH	DI			;save string ptr
	SUB	CX,1900			;make date within century
	MOV	AL,CL			;get year
	CALL	Convert2Dec		;make into 2-digit ASCII string
	MOV	AL,DH			;get month
	CALL	Convert2Dec		;make into 2-digit ASCII string
	MOV	AL,DL			;get day
	CALL	Convert2Dec		;make into 2-digit ASCII string
	MOV	BYTE PTR ES:[DI],0	;terminate
	POP	DI
	RET
DateToStr	ENDP


; Convert cardinal (0..99) to 2 digit string, with leading zero.
;	ENTRY:
;		AL = number
;		DS:EI -> start of string (2 digits, term char)
;	EXIT:
;		DS:EI -> end  of string (term char)


Convert2Dec	PROC	NEAR
	PUSH	CX			;save reg
	PUSH	DX
	CMP	AL,9			;if  number is > 9, we must
	JA	NeedToConvert		;convert it to ten's value,
	MOV	AH,AL			;else, save & use a leading zero
	MOV	AL,'0'			;for the ten's digit
	STOSB				;store the ten's digit
	MOV	AL,AH
	JMP	SHORT StuffUnits	;go do the units
NeedToConvert:
	XOR	AH,AH			;AH := 0
	MOV	DH,AL			;save number
	MOV	CL,10
	DIV	CL			;divide by ten to get
	MOV	DL,AL			;the ten's digit
	ADD	AL,'0'			;convert to ascii
	STOSB				;store the ten's digit
	MOV	AL,10
	MOV	CL,DL
	MUL	CL			;multiply by ten
	SUB	DH,AL			;subtract ten's to get units
	MOV	AL,DH
StuffUnits:
	ADD	AL,'0'			;convert to ascii
	STOSB				;store units
	POP	DX
	POP	CX
	RET
Convert2Dec	ENDP



code     ENDS

PAGE

; 	========== Stack segment ================

stack   SEGMENT PARA stack

	DW      StackDepth DUP('Ss')	;stack area

stkptr	LABEL	BYTE			;where to set SP

stack   ENDS



; 	========== Data segment =================

data    SEGMENT PARA public

DateField	DB 	DateStringLength DUP('d'),0	;buffer for ascii date

data     ENDS


         END   DateStr        ;specify starting address in END statement
