;validate
;
;this routine will check for valid filenames and is call from BASIC
;
;written by howard glosser
;
;return codes set as follows...
;
; 0 - no special occurrences
; 1 - global name
; 2 - invalid drive
; 3 - invalid filename
; 4 - no extension on filename
;
cseg		segment
		assume cs:cseg
		jmp begin
;
retcd		dw 0
;
validate	proc far
;
begin:		push bp 		;save bp for far return
		mov bp,sp		;move stack pointer to bp
		mov bx,[bp]+10		;point bx at parm 1
		mov si,1[bx]		;get filename to validate
		mov bx,[bp]+8		;point bx at parm 2
		mov di,1[bx]		;get work area
		mov cs:retcd,0		;move 0 to return code
		push si 		;save si register
		mov al,0fh		;bits on in low al reg for parse
		mov ah,29h		;set up for parsing filename
		int 21h 		;dos interrupt
		pop si			;restore si register
		cmp al,01h		;do we have a global name?
		jne ckdrv		;no - check drive
		or cs:retcd,01h 	;yes - indicate global name
;
ckdrv:		cmp byte ptr[si]+1,':'  ;is there a drive letter?
		jne ckname		;no - check the name
		add si,2		;yes - set si past letter/colon
		cmp al,0ffh		;is it valid?
		jne ckname		;yes - go check name
		or cs:retcd,02h 	;no - indicate invalid drive
;
ckname: 	cmp byte ptr[di]+1,' '  ;invalid characters in name
		jne scaname		;no - scan for name
		or cs:retcd,04h 	;yes - indicate invalid name
		jmp namedone		;done - go leave subroutine
;
scaname:	mov al,'.'              ;set al for end of name scan
		mov cx,9		;scan nine characters
;
nameloop:	cmp byte ptr[si],al	;get a hit on '.'
		je ckext		;yes - check extension
		cmp byte ptr[si],' '    ;hit a blank
		je noext		;yes - no extension on name
		inc si			;bump name one character
		loop nameloop		;do again
		or cs:retcd,04h 	;get here - name's invalid
		jmp namedone		;done - go leave subroutine
;
ckext:		inc si			;bump si past '.'
		mov al,' '              ;set al for extension scan
		mov cx,4		;scan four characters
		cmp byte ptr[si],al	;get a hit on ' ' at start
		je namedone		;yes - there's no actual extension
;
extloop:	cmp byte ptr[si],al	;get a hit on ' '
		je namedone		;yes - filename is okay
		inc si			;bump to next character in ext
		loop extloop		;do again
		or cs:retcd,04h 	;get here - name's invalid
		jmp namedone		;done - go leave subroutine
;
noext:		or cs:retcd,08h 	;no extension - indicate this
;
namedone:	mov di,[bp]+6		;point di at parm 3
		mov ax,cs:retcd 	;put return code in ax
		mov [di],ax		;move return code for basic
		pop bp			;restore bp
		ret 6			;return with three parms on stack
;
validate	endp
;
cseg		ends
;
		end
