; In Memory (as_is) -> 192,960 bytes (192k) --> 3 full segments + code seg.
; TSR4.asm
; Interrupt handler tsr. Assemble and link as .exe.  
; The easiest way to do it....... In my opinion
; Running TES2.exe will  make  a  call to int-60  which will invoke this TSR.
;  after running it's course, control will be  returned to TES2.exe. The pro-
;  gram is composed of nothing more than a little  text-writing to the screen
;  followed by dumping the contents of one segment (filled with "A"), a pause
;  to ask if  you  want  to  continue,  and  then dumping of a second segment 
;  filled  with  "B".  Their are a couple of calls to BIOS int 16h which gets
;  keyboard input,  to  show  that  outside  interrupts (keyboard int-09) are 
;  functioning correctly. The  segement  dumps, take about a minute each on a 
;  386dx 25 mghz machine,  so be patient - don't concider it to be a computer 
;  mal-function.
; ________________________________________________________________________
; ------------------------------------------------------------------------
; NOTE!! No error  checking  is  done in this  program as_it_is. Doing a com-
;  plete error checking routine would make  this source code more than just a 
;  little  " H U G E ". For simple programs  I find all the fuss a little un-
;  worthy. Their  are  circumstances  however  when  you  ABSOLUTELY  M U S T 
;  "play by the rules",  and  take a lot of care  how, when, and where you go
;  loading a multi-segmented TSR into memory.
; Note also that this  TSR  assumes  that it is  the one and only handler for
;  interrupt 60h. Interrupt  is a DOS  stamped "user interrupt" so is usually
;  free for_the_using. However, if another TSR makes a call to this interrupt
;  while this  TSR  is running, it will become re-entant, and crash. To avoid 
;  that, you can add a few more lines of code to check for re-entry.
;---------------------------------------------------------------------------
; Let me know if you have any questions....... Tim Van Dusen CIS #73171,261
;---------------------------------------------------------------------------

; PROGRAM CODE SEGMENT  

code segment
assume cs:code, ds:code, ss:tsrstack

;****************************************************************************
; P U T    Y O U R    C O D E    B E L O W
;****************************************************************************


old_int         dd      0       ; old pointer saved here (not required here)
open    db      10 dup (10,13)
        db      "Currently in new int-60 handler"
        db      10,13,10,13
        db      "The following will dump the contents of first the first",10,13
        db      "segment (letter 'A'), pause, and then dump the contents",10,13
        db      "of the second segment (letter 'B'). It will then return",10,13
        db      "control to the calling program",10,13,10,13
        db      "Pressing 'Q' after any screen-write will terminate TSR."
        db      10 dup (10,13),"$"

flag    db      0

handler proc near                        
        cli                     ; disable interrupts
        push    ax              
        mov     al, 20h         ; end-of-interrupt command
        out     20h, al         ; issue command to controller
        pop     ax
        sti

; Save all flags and register changed in routine
; Push flags       
        pushf

; Push registers         
        push    ax
        push    dx
        push    di
        push    es
        push    ds

; Check stack segment by filling it, then dumping it.

mov cx,05000h            ; Leave some room for running program
fill_er_up:
push ax
dec cx
cmp cx,0
jne fill_er_up

mov cx,05000h
dump_it:
pop ax
dec cx
cmp cx,0
jne dump_it

; Stack works................. :)

; Below are several groups of DOS screen-writes which show that each of the
;  loaded segments can be accessed and read from.
; Following each screen-write is a simple BIOS get_key routine.
mov ax,cs
mov ds,ax
mov es,ax
mov ah, 09h
mov dx, offset cs:open          ; Be sure to specify in which segment
                                ;  the data lies.
int 21h

call cs:get_key
cmp cs:[flag], 0
je cs:carry_on
jmp cs:exit
carry_on:

assume ds:data
mov ax,data
mov ds,ax
mov es,ax
mov ah, 09h
mov dx, offset open2
int 21h

call cs:get_key
cmp cs:[flag], 0
je cs:carry_on2
jmp cs:exit
carry_on2:

assume ds:data
mov ax,data
mov ds,ax
mov es,ax
mov ah, 09h
mov dx, offset letter_A
int 21h

assume ds:data2
mov ax,data2
mov ds,ax
mov es,ax
mov ah, 09h
mov dx, offset open3
int 21h

call cs:get_key
cmp cs:[flag], 0
je  cs:carry_on3
jmp cs:exit
carry_on3:


assume ds:data2
mov ax,data2
mov ds,ax
mov es,ax
mov ah, 09h
mov dx, offset letter_B
int 21h

mov ah,00
int 16h


exit:

; Return all  registers changed in routine       
        pop ds
        pop es
        pop di
        pop dx
        pop ax

;        jmp     cs:[old_int_?]     ;   process old interrupt if neccessary


; Return flags        
        popf
        iret
endp handler    

get_key proc near
push    ax
mov     cs:[flag],0
mov     ah, 00h
int     16h
cmp     ah, 10h
jne     cs:done
mov     cs:[flag],1
done:
pop     ax

ret

endp get_key

;***************************************************************************
;  F I N I S H    Y O U R    C O D E    H E R E
;***************************************************************************

zstuff  db      0

;************************************************************************
; Start of non-resident installation portion this portion must always be 
;  last to keep it out of resident memory. And begin with the "start:"
;  variable

install proc far

start:
        push    cs
        pop     ds

; get current interrupt vector and save in variable
        
        mov     al, 60h         
        mov     ah, 35h
        int     21h                ; get pointer to current int. handler
        mov     word ptr old_int, bx
        mov     word ptr old_int+2, es

; install new interrupt routine

        mov     dx, offset handler
        mov     al, 60h                                                         
        mov     ah, 25h
        int     21h                ; install our interrupt 


; now determine the size to remain resident (paragraphs) 
;   and become a TSR

        mov     dx, offset zstuff  ; end of resident code
        add     dx, 11h            ; add PSP size + 1 paragraph
        mov     cl, 4              ; get number of "paragraphs"
        shr     dx, cl             ;  by right shifting
        add     dx, 1              ; VERY IMPORTANT!! after shr, dx
                                   ;  may equal 0, so always add one
        mov     bx, offset stacstart
        mov     ax, offset stacend     ; get size of stack
        sub     ax, bx
        shr     ax, cl
        add     ax, 1
        add     dx, ax
        
        mov     bx, offset datstart    ; get size of data segment
        mov     ax, offset datend
        sub     ax, bx
        shr     ax, cl
        add     ax, 1
        add     dx, ax
        
        mov     bx, offset datstart2    ; get size of second data segment
        mov     ax, offset datend2
        sub     ax, bx
        shr     ax, cl
        add     ax, 1
        add     dx, ax                  ; DX now contains value of total
                                        ;  segments.
        add     dx, 1eh                 ; Add two more paragraphs for safety
        mov     ax, 3100h               ; exit to DOS as tsr 
        int     21h
endp install 

code    ends

; EXTRA SEGMENTS   * M U S T   G O   L A S T  ! ! ! *
tsrstack        segment stack   'stack'
stacstart       db      0
                db      0fff0h dup (0)
stacend         db      0
tsrstack ends



data  segment   'data'
datstart        db      0       
open2           db      10,13,"Ready to print contents of first segment?"
                db      10,13,"$"
letter_A        db      0ff00h dup ("A"),10,13,"$"
datend          db      0
data ends

data2  segment   'data2'
datstart2       db      0       
open3           db      10,13,"Ready to print contents of second segment?"
                db      10,13,"$"
letter_B        db      0fe00h dup("B"),10,13
                db      "Next keystroke will return you from interrupt","$"
datend2         db      0
data2 ends

end     start
end



