Title   UnMark.ASM -- Replaces TurboPower RELEASE Version 2.6
Cseg    Segment Public Para   ;Version 3.0 30-Mar-1989 - 03:00
        Assume  cs:Cseg,ds:Cseg
        Org 0100h
Main    Proc    Far
        Jmp Start
UsageMsg    DB  13,'   ',9,10
DB 'UnMark replaces RELEASE ver 2.6 by TurboPower Software',13,10,9
DB '======================================================',13,10,9
DB 'UnMark, like RELEASE, removes memory-resident programs',13,10,9
DB 'and restores interrupt vectors to pre[F]Mark addresses.',13,10,10,9
DB 'UnMark will UpDate the WATCH data area when WATCH has',13,10,9
DB 'been installed ahead of the [F]Mark that is removed.',13,10,10,9
DB 'UnMark also releases any Lotus/Intel expanded memory',13,10,9
DB 'used by TSR programs which it releases.',13,10,10,9
DB '/Keep [F]Mark and /NO EMS RELEASE options are NOT',13,10,9
DB 'implemented in UnMark.  The UnMark syntax is:',13,10,10,9
DB 'UNMARK [[File]MarkName] [Options]',13,10,10,9
DB 'Options are EACH preceded with a "/" character:',13,10,10
DB 9,9,'/D',9,"Don't Display MCBs",13,10
DB 9,9,'/R',9,'Leave 8259 interrupt controller as is',13,10,9
DB 9,'[/]?',9,'Write this Help screen'
CRLF        DB  13,10,"$",8,32,26       ; You can >TYPE UnMark.COM
EMSid       DB  'EMMXXXX0'
MarkID      DB  '3.0 TSR '              ; ID of [F]Marks 7 bytes
WatchM      DB  'WATCHER$'              ; or Watch ID = 12 bytes
Header      DB  ' MCB Block Len User  Release? $'
TruMsg      DB  '  True  $'
FalMsg      DB  ' False  $'
MrkMsg      DB  '[F]Mark$'
PgmMsg      DB  'Program$'
EnvMsg      DB  'Environ$'
TrapMsg     DB  'Trapped$'
NotFound    DB  13,10,'NO '
WasFound    DB  '[F]Mark found',13,10
            DB  'UnMark Requires Version 3.0 '
            DB  '[F]Mark and Watch programs!',13,10,"$"
Protected   DB  13,10,'Protected Mark Encountered!',13,10,"$"
FileError   DB  13,10,'Error Reading FMark File!',13,10,"$"
ReleasErr   DB  13,10,'Release Failed!',13,10,'$'
RamMsg      DB  'RAM bytes available: '
Free        DB  6 DUP(' '),13,10,"$"
FlagD       DB  0                       ; Show MCBs Unless Set
FlagR       DB  0                       ; Reset 8259 Unless Set
ErrLvl      DB  0                       ; Set AL on Program Exit
PflagA      DW  0                       ; Set if Protected Mark
MflagA      DW  0                       ; [F]Mark PSP When Found
WatchF      DW  0                       ; PSP of Watch When Found
FMarkF      DW  0                       ; Set if FMark File Found
MkParm      equ offset buffer           ; Command [F]Mark Name
MrkLen      DW  ?                       ; Length of Name
MCBbuf      equ MkParm  +  40h          ; MCB Table and [F]Mark
MCBend      DW  ?                       ; End of MCB area
vector      equ MCBbuf  + 400h          ; Interrupt Vectors, EGA and
parent      equ vector  + 418h          ; ICA areas plus Parent Word
emscnt      equ parent  +   2h          ; EMS Handle Count and MAP
emsmap      equ emscnt  +   2h          ; from [F]Mark Storage
                                        ; <= 100h bytes for MAP
Start:  xor     ax,ax                   ; Zero
        mov     cx,2048                 ; data
        mov     di,MkParm               ; buffer
        rep     stosw                   ; words
        mov     di,MkParm               ; Set for [F]Mark ID
        mov     si,81h                  ; Get Command
        call    Ploop                   ; Parameter(s)
        mov     ah,9                    ; If NO ?
        jnc     DoNew                   ; Then New Line
        mov     dx,offset UsageMsg      ; Else Display
        int     21h                     ; Syntax Message
        jmp     Exit                    ; and Exit

DoNew:  mov     dx,offset CRLF          ; Display
        int     21h                     ; New Line
        mov     dx,MkParm               ; Calculate and
        sub     di,dx                   ; Store [F]Mark
        mov     MrkLen,di               ; Name Length
        mov     ax,4300h                ; If Attributes
        int     21h                     ; NOT Returned
        jc      DoBuf                   ; Then NOT FMark
        mov     FMarkF,CX               ; Else Flag as FMark

DoBuf:  mov     ah,52h                  ; Undocumented
        int     21h                     ; Function
        mov     di,es:[bx-2]            ; obtains
        mov     es,di                   ; MCB of DOS
        inc     di                      ; Config.Sys
        mov     si,MCBbuf               ; Initialize Source and
        xor     bx,bx                   ; Basic Index Pointers

MCBlp:  add     di,es:[3]               ; Advance so as to
        mov     es,di                   ; Point to MCB and
        inc     di                      ; Next Paragraph
        mov     [si+bx+0],es            ; Store MCB
        mov     dx,es:[1]               ; Get and Store
        mov     [si+bx+2],dx            ; Block Address
        mov     ax,es:[3]               ; and Block
        mov     [si+bx+4],ax            ; Length
        call    DoFlags                 ; Set Appropriate Flags
        add     bx,8                    ; Advance to Next and
        cmp     byte ptr es:[0],"Z"     ; Loop Until Last MCB
        jne     MCBlp
        push    ds                      ; Restore Extra Segment
        pop     es                      ; Register to DATA
        mov     MCBend,si               ; Initialize MCB buffer end
        add     MCBend,bx               ; Adjust buffer end for length
        mov     ax,MflagA               ; If NO [F]Mark Marked
        cmp     ax,PflagA               ; Or If Below Protected
        jc      IsPME                   ; Then Protected Error Exit
        mov     di,si                   ; Else Point to Buffer
        mov     ax,-1                   ; Find [F]Mark
        mov     cx,bx                   ; for Release
        shr     cx,1                    ; In MCB Words
        repne   scasw                   ; If None Found Yet
        jne     DoLast                  ; Then Assume Last Mark
        jmp     DoMark                  ; Else Get [F]Mark Data

DoLast: cmp     word ptr MrkLen,0       ; If [F]Mark
        jnz     NoMark                  ; Command Name
        mov     di,MCBend               ; Or If Scan MCBs
        std                             ; backwards finds
        mov     cx,bx                   ; NO [F]Mark
        repne   scasb                   ; Marked
        cld                             ; Then NO [F]Mark
        jne     NoMark                  ; Found Error Exit
        sub     di,5                    ; Else Point to
        mov     bx,di                   ; [F]Mark Record
        sub     bx,si                   ; With Basic Index
        mov     di,MkParm               ; Set Destination
        push    si                      ; Preserve
        push    ds                      ; Source
        mov     ds,[si+bx+2]            ; Point to and
        mov     si,81h                  ; Get Command
        call    Ploop                   ; [F]Mark Name
        pop     ds                      ; Restore
        pop     si                      ; Source
        mov     cx,di                   ; If NO [F]Mark
        sub     cx,MkParm               ; Name Length
        jz      ReLast                  ; Then NO "!"
        mov     di,MkParm               ; Else Scan
        mov     al,"!"                  ;  for "!"
        repne   scasb                   ; If Found
        je      IsPME                   ; Then Protected Error Exit
        mov     dx,MkParm               ; Else If NO File
        mov     ax,4300h                ; Attributes
        int     21h                     ; Returned
        jc      ReLast                  ; Then was Mark
        mov     FMarkF,cx               ; Else is FMark
ReLast: mov     ax,[si+bx+2]            ; Set the [F]Mark
        mov     MflagA,ax               ; PSP Address and
        mov     MrkLen,ax               ; use as Length
        mov     word ptr [si+bx+6],-1   ; Flag for Release
        mov     es,[si+bx+0]            ; Re-Set Registers
        mov     di,[si+bx+2]            ; and Re-Enter MCBs
        add     bx,8                    ; Loop after [F]Mark to
        jmp     MCBlp                   ; Release subsequent MCBs

IsPME:  cmp     byte ptr FlagD,0        ; If have DBug Flag
        jne     DoPME                   ; Then Skip to Message
        call    DoDeBug                 ; Else Show MCBs
DoPME:  mov     dx,offset Protected     ; Error Exit with
        mov     byte ptr ErrLvl,1       ; Error Level 1 and
        jmp     short Show              ; Protected [F]Mark Message
NoMark: cmp     byte ptr FlagD,0        ; If have DBug Flag
        jne     DoNFM                   ; Then Skip to Message
        call    DoDeBug                 ; Else Show MCBs
DoNFM:  mov     dx,offset NotFound      ; Error Exit with
        mov     byte ptr ErrLvl,2       ; Error Level 2 and
        jmp     short Show              ; Not Found Message
DoFErr: mov     ah,3Eh                  ; Close the File
        int     21h                     ; Handle If Possible
        mov     dx,offset FileError     ; Reading [F]Mark File
        mov     byte ptr ErrLvl,3       ; Error Level 3 and
        jmp     short Show              ; Exit without Release

DoMark: push    di                      ; Preserve Pointer
        sub     di,16                   ; If Block
        mov     ax,es:[di+2]            ; below [F]Mark
        add     cx,8                    ; does NOT belong
        repne   scasw                   ; to a Released PSP
        jne     IfMark                  ; Then Do File or Mark
        mov     byte ptr es:[di+3],0FFh ; Else Mark Environment
IfMark: pop     di                      ; Restore Pointer
        cmp     word ptr FMarkF,0       ; If NOT File Mark
        jz      IsMark                  ; Then is Memory
        mov     dx,MkParm               ; Else Open File
        mov     ax,3D00h                ;  for Read Only
        int     21h                     ; If Open Fails
        jc      DoFErr                  ; Then File Error Exit
        mov     dx,vector               ; Else Copy Interrupt
        mov     cx,051Ch                ; EGA, ICA, Parent and
        mov     bx,ax                   ; EM Handle Count from
        mov     ah,3Fh                  ; File Mark file
        int     21h                     ; If file Read Fails
        jc      DoFErr                  ; Then File Error Exit
        mov     ah,3Eh                  ; Else Close the
        int     21h                     ; File Handle and
        jmp     short MkExit            ; Check DeBug Flag

IsMark: mov     ds,[di-6]               ; Get Memory data
        mov     si,0120h                ; Copy Mark Interrupts
        mov     cx,051Ch                ; EGA,ICA, Parent and
        mov     di,vector               ; EMS Information
        rep     movsb                   ; Into data buffer
        push    cs                      ; Restore
        pop     ds                      ; Segment
MkExit: cmp     byte ptr FlagD,0        ; If DBug Flag
        mov     dx,offset WasFound      ; Then Show
        jne     Show                    ; only Result
        call    DoDeBug                 ; Else MCBs also
Show:   mov     ah,9                    ; Display
        int     21h                     ; Message
        mov     si,MCBend               ; Look Into
        mov     di,MCBbuf               ; MCB Buffer
        sub     si,8                    ; Calculate
        mov     cx,si                   ; Number of
        sub     cx,di                   ; Record
        shr     cx,1                    ; Words
        mov     ax,-1                   ; If NO [F]Mark
        repne   scasw                   ; or If an Error
        mov     ax,[si+4]               ; Then UnMark's
        jne     FreeOk                  ; Length is Free
        cmp     byte ptr ErrLvl,0
        jne     FreeOk
        add     ax,[si+2]               ; Else Free RAM =
        sub     di,8                    ; Total - [F]Mark
        sub     ax,es:[di]              ; MCB - any Trapped
        sub     di,16                   ;  that are freed
        cmp     word ptr es:[di+2],0    ; If Trapped NOT Freed
        jne     FreeOk                  ; Then AX has Free RAM
        add     ax,es:[di+4]            ; Else Adjust for
        inc     ax                      ; Trapped Block

FreeOk: xor     dx,dx
        mov     dl,ah                   ; Free RAM Equals
        mov     cl,4                    ; Free Paragraphs
        shr     dx,cl                   ; Converted to
        shl     ax,cl                   ; DD bytes in DX:AX
        mov     bx,offset Free+6        ; Store Free as
        mov     cx,10                   ; Decimal Digits
NexDig: div     cx                      ; Store each
        or      dx,30h                  ; ASCII digit
        dec     bx                      ; Right to Left
        mov     [bx],dl                 ; Until
        xor     dx,dx                   ; both DX
        or      ax,ax                   ; and AX
        jnz     NexDig                  ; are 0
        mov     ah,9                    ; Display
        mov     dx,offset RamMsg        ; RAM Bytes Free
        int     21h
        cmp     byte ptr ErrLvl,0       ; If NO [F]Mark Error
        jz      ChkEMS                  ; Then Continue
        jmp     Exit                    ; Else Error Exit

ChkEMS: mov     ax,3567h                ; Locate Driver
        int     21h                     ; Interrupt
        mov     di,0Ah                  ; Address
        lea     si,EMSid                ; If Name
        mov     cx,8                    ; 'EMMXXXX0'
        rep     cmpsb                   ; Is NOT Found
        push    cs                      ; After Extra Segment
        pop     es                      ; Register is Restored
        jne     EndEMS                  ; Then NO EMS
        mov     di,emsmap               ; Else Point to
        add     di,100h                 ; Next Map Area
        mov     ah,4Dh                  ; Get Current
        int     67h                     ; Handle Map
        or      ah,ah                   ; If Function Fails
        jnz     EndEMS                  ; Then EMS Broken
        mov     si,emscnt               ; Else If [F]Mark
        lodsw                           ; Handle Count Is
        mov     cx,bx                   ; Not Less Than
        cmp     ax,bx                   ; Current Count
        jnc     EndEMS                  ; Then EMS NOT Used
EMSHlp: mov     dx,es:[di]              ; Else Compare
        cmpsw                           ; Maps and Release
        cmpsw                           ; Handle(s) NOT in
        je      lpEMSH                  ; [F]Mark Map Using
        mov     ah,45h                  ; Deallocate Handle
        int     67h                     ; EMS Function
        or      ah,ah                   ; If Ok AND More
lpEMSH: loopz   EMSHlp                  ; Then Continue
        mov     ErrLvl,ah               ; Else EMS Done
EndEMS: mov     ax,WatchF               ; If WATCH
        or      ax,ax                   ; NOT Found
        jz      WatchX                  ; Then Skip
        mov     es,ax                   ; Else Point
        mov     di,218h                 ; short of WATCH
        mov     dx,-1                   ; Vector Change Area
        mov     ax,MflagA               ; Looking for [F]Mark
        mov     cx,620h
UCloop: add     di,8                    ; If Reach End of
        cmp     di,cx                   ; Vector Change Area
        jnc     WatchX                  ; Then NO Changes
        cmp     es:[di],dx              ; Else If NOT PSPid
        jnz     UCloop                  ; Or If PSP is NOT
        cmp     es:[di+2],ax            ; PSP of [F]Mark
        jnz     UCloop                  ; Then Keep Looking
        mov     dx,di                   ; Else Calculate
        sub     dx,220h                 ;  and store new
        mov     es:[104h],dx            ; vpos offset and
        xor     al,al                   ; Null-out
        sub     cx,di                   ; remaining
        rep     stosb                   ; Vector Change Area
        mov     si,vector               ; Copy Interrupt
        mov     cx,200h                 ; Vector words
        mov     di,0A20h                ; Into WATCH prevv
        rep     movsw                   ; Current Vector Table
WatchX: push    cs                      ; Restore Extra
        pop     es                      ; Segment Register
        mov     di,MCBbuf               ; Prepare to Kill File(s)
FileLp: push    cs                      ; Insure Data Segment
        pop     ds                      ; Register in Program
        mov     cx,MCBend               ; Calculate
        sub     cx,di                   ; Number of
        shr     cx,1                    ; Words to
        mov     ax,-1                   ; Scan for Marked
        repne   scasw                   ; [F]Mark Blocks
        jne     CheckR                  ; Until all Done
        mov     ds,es:[di-6]            ; Point to Mark
        mov     si,81h                  ; Command Name
        xor     bx,bx                   ; Set Pointer to
        mov     bl,ds:[si-1]            ; Length of Name
        xor     ch,ch                   ; Make ASCIIZ and
        mov     cl,ds:[si+bx]           ; Save Previous
        mov     ds:[si+bx],ch           ; Name Command End
        mov     ah,41h                  ; Delete
        mov     dx,82h                  ; File(s)
        int     21h                     ; Restore
        mov     ds:[si+bx],cl           ; Ending
        jmp     short FileLp            ; Loop Until Done
CheckR: cmp     byte ptr FlagR,0        ; If Leave 8259 as is
        jnz     UnMark                  ; Then Skip Procedure
        call    Rst8259                 ; Else Reset 8259
UnMark: mov     si,MCBend               ; Work between
        sub     si,8                    ; UnMark Program
        mov     bp,MCBbuf               ; and Master
        add     bp,8                    ; Environment
Loop49: sub     si,8                    ; If Down to Master
        cmp     si,bp                   ; Environment
        je      Result                  ; Or If Block
        mov     ax,[si]                 ; has NOT been
        inc     ax                      ; Marked for
        cmp     byte ptr [si+7],0FFh    ; Release
        jne     Result                  ; Then Done
        mov     es,ax                   ; Else If
        mov     ah,49h                  ; Released
        int     21h                     ; w/o error
        jnc     Loop49                  ; Then Continue
        mov     ErrLvl,al               ; Else Set Error
        mov     ah,9                    ;  and Display
        mov     dx,offset ReleasErr     ; Error Message
        int     21h
Result: cmp     byte ptr ErrLvl,0       ; If NO Error
        jz      SetPSP                  ; Then Continue
        int     19h                     ; Else ReBoot

SetPSP: push    cs                      ; Restore Extra
        pop     es                      ; Segment Register
        mov     di,0Ah                  ; Set PSP from
        mov     si,vector               ; Vectors for
        add     si,88h                  ; Interrupts
        mov     cx,6                    ; 22h, 23h,
        rep     movsw                   ; and 24h
        mov     si,parent               ; Get Parent Word
        movsw                           ; and Take Command
        xor     di,di
        mov     es,di                   ; Restore
        mov     si,vector               ; Interrupt
        mov     cx,1024                 ; Vectors
        cli
        rep     movsb
        sti
        add     di,0A8h                 ; Restore EGA
        mov     cx,8                    ; Information
        rep     movsb
        add     di,40h                  ; Restore Inter-
        mov     cx,8                    ; Communications
        rep     movsw                   ; Area Information

Exit:   mov     al,ErrLvl               ; Set Error Level
        mov     ah,4Ch                  ; Error Level
        int     21h                     ; Exit to DOS
Main    EndP

Ploop   Proc
        lodsb                           ; If the Next Byte
        cmp     al,13                   ; is End of Command
        je      Pexit                   ; Then Exit Parsing
        cmp     al," "                  ; Else If Space
        je      Ploop                   ; Then Skip It
        cmp     al,"/"                  ; Else If Switch
        je      ParaQ                   ; Then Check Which
        cmp     al,"?"                  ; Else If Question Mark
        je      DoHelp                  ; Then Help Message Exit
        stosb                           ; Else Store ID name
        jmp     short Ploop             ; Until [F]Mark ID ends

ParaQ:  lodsb                           ; If Byte After Switch
        cmp     al,13                   ; is End of Command
        je      Pexit                   ; Then Exit Parameters
        cmp     al,"?"                  ; Else If Question Mark
        je      DoHelp                  ; Then Help Message Exit
        and     al,5Fh                  ; Else UPPER CASE
ParaD:  cmp     al,"D"                  ; If NOT "D"Bug
        jne     ParaR                   ; Then Check "R"eset
        mov     byte ptr FlagD,0FFh     ; Else Set D Flag
ParaR:  cmp     al,"R"                  ; If NOT "R"eset 8259
        jne     Ploop                   ; Then Loop Until End
        mov     byte ptr FlagR,0FFh     ; Else Set R Flag
        jmp     short Ploop             ;  and Loop Until End

DoHelp: stc                             ; Carry Flag for Help

Pexit:  ret

Ploop   EndP

DoFlags Proc
        push    si                      ; Preserve
        push    di                      ; Pointers and
        push    es                      ; Segment Register
        mov     bp,di                   ; Copy for Comparisons

        sub     dx,di                   ; If a Program
        jz      ChkPgm                  ; Then Check It
        xor     dx,dx                   ; Else Zero Flags

ChkRel: cmp     word ptr MflagA,0       ; If NO [F]Mark Yet
        jz      ExitDF                  ; Then NO Release Flag
        mov     dh,0FFh                 ; Else Mark for Release

ExitDF: jmp     short DFexit

ChkPgm: mov     es,di                   ; Look in
        mov     di,62h                  ; Program
        mov     cx,7                    ; for ID of
        mov     si,offset MarkID        ; an [F]Mark
        rep     cmpsb
        mov     di,81h                  ; If an [F]Mark
        je      ChkMrk                  ; Then Check Name
        mov     cx,12                   ; Else If NOT TSR
        rep     cmpsb                   ; WATCHER Version
        mov     si,offset MarkID+3      ; 3.0 " TSR WATCHER"
        jne     ChkRel                  ; Then Check Release
        mov     WatchF,bp               ; Else Store Address
        jmp     short ChkRel

ChkMrk: mov     dl,0FFh                 ; Flag as [F]Mark
        mov     cl,es:[di-1]            ; If NO Length
        jcxz    Chk4MF                  ; Then NO Protect
        push    di                      ; Else Save Name
        push    cx                      ;  and Length
        mov     al,"!"                  ; Scan for
        repne   scasb                   ; Protected
        pop     cx                      ; If NOT
        pop     di                      ; Protected
        jne     Chk4MF                  ; Then Check Mark Flag
        mov     PflagA,bp               ; Else Set Protected Flag

Chk4MF: cmp     word ptr MflagA,0       ; If NO Release [F]Mark
        jz      DoName                  ; Then Check This One
        mov     dh,0FFh                 ; Else Mark for Release
        jmp     short DFexit

DoName: dec     cx                      ; Assume space
        cmp     MrkLen,cx               ; If NOT length of
        mov     si,MkParm               ; Parameter Name
        jne     DFexit                  ; Then Check Release
FNloop: inc     di                      ; Else Get
        lodsb                           ; Next Byte
        cmp     PflagA,bp               ; If Protected [F]Mark
        jz      FNBcmp                  ; Then Compare Exact
        or      al,20h                  ; Else Insure lower
FNBcmp: sub     al,es:[di]              ; If Name Bytes Match
        je      loopFN                  ; Then Compare Until
        cmp     PflagA,bp               ; Else If Protected
        jz      DFexit                  ; Then MCB Flag Exit
        cmp     al,20h                  ; Else If Only Case
loopFN: loope   FNloop                  ; Then Compare Until
        jne     DFexit                  ; Fail or Match
Match:  mov     dh,0FFh                 ; Mark [F]Mark and
        mov     MflagA,bp               ; Subsequent MCBs
                                        ; for Release
DFexit: pop     es                      ; Restore Segment
        pop     di                      ; Destination and
        pop     si                      ; Source Pointers
        mov     [si+bx+6],dx            ; Set MCB Flags
        ret
DoFlags EndP

DoDeBug Proc
        push    dx                      ; Preserve Message
        mov     ah,9                    ; Display
        mov     cx,2                    ; two sets of
        mov     dx,offset Header        ; DeBug Headers
ShoHdr: int     21h
        loop    ShoHdr

        mov     si,MCBbuf               ; Point to Array
DoMCBs: mov     cx,2                    ; Two Members
        mov     dx,offset CRLF          ; per each
        int     21h                     ; New Line

ShoMCB: push    cx                      ; Preserve Set Count
        mov     bl,[si+1]               ; Get MCB High Byte
        call    ShowVal                 ; and Display ASCII
        mov     bl,[si+0]               ; Get MCB Low Byte
        call    ShowVal                 ; and Display ASCII
        mov     dl," "                  ; Add a Space
        int     21h
        mov     bl,[si+3]               ; Get Block High Byte
        call    ShowVal                 ; and Display ASCII
        mov     bl,[si+2]               ; Get Block Low Byte
        call    ShowVal                 ; and Display ASCII
        mov     dl," "                  ; Add a Space
        int     21h
        mov     bl,[si+5]               ; Get Length High Byte
        call    ShowVal                 ; and Display ASCII
        mov     bl,[si+4]               ; Get Block Low Byte
        call    ShowVal                 ; and Display ASCII
        mov     dl," "                  ; Add a Space
        int     21h
        mov     dx,offset WatchM        ; If Watch
        mov     ax,WatchF               ; PSP Block
        dec     ax                      ; minus one
        cmp     ax,[si]                 ; Matches MCB
        je      ShoUsr                  ; Then is Watch
        mov     dx,offset MrkMsg        ; Else If [F]Mark
        cmp     byte ptr [si+6],0FFh    ; flag is set
        je      ShoUsr                  ; Then [F]Mark
        mov     dx,offset PgmMsg        ; Else If Block
        mov     bx,[si+2]               ; is the next
        dec     bx                      ; paragraph
        cmp     bx,[si+0]               ; after MCB
        je      ShoUsr                  ; Then Program
        mov     dx,offset EnvMsg        ; Else Environ
        cmp     bx,-1                   ; Unless
        jne     ShoUsr                  ; Block is
        mov     dx,offset TrapMsg       ; Trapped
ShoUsr: mov     ah,9                    ; Display
        int     21h                     ; User
        mov     dx,offset TruMsg        ; If Marked
        cmp     byte ptr [si+7],0FFh    ; for Release
        je      ShoRel                  ; Then True
        mov     dx,offset FalMsg        ; Else False
ShoRel: int     21h                     ; Message
        pop     cx                      ; Restore Counter
        add     si,8                    ; If NOT at
        cmp     si,MCBend               ; End of MCBs
        loopne  ShoMCB                  ; Then Continue
        jne     DoMCBs                  ; Until All Done
        pop     DX                      ; Restore Message
        ret
DoDeBug EndP

ShowVal Proc
        mov     cl,4                    ; Set Divisor 16
        mov     ah,2                    ; for Show Byte
        mov     dl,bl                   ; Copy the Byte
        and     dl,0F0h                 ; Isolate High
        shr     dl,cl                   ; Nibble as
        add     dl,30h                  ; ASCII
        cmp     dl,3Ah                  ; If Decimal
        jc      SV1                     ; Then Show Dec
        add     dl,7                    ; Else Show Hex
SV1:    int     21h
        mov     dl,bl                   ; Copy the Byte
        and     dl,0Fh                  ; Isolate Low
        add     dl,30h                  ; ASCII Nibble
        cmp     dl,3Ah                  ; If Decimal
        jc      SV2                     ; Then Show Dec
        add     dl,7                    ; Else Show Hex
SV2:    int     21h
        ret
ShowVal EndP

Rst8259 Proc  ; RESET THE 8259 INTERRUPT CONTROLLER CHIP - Rick Housh
        push    es                      ; Point Extra Segment to
        mov     ax,-1                   ; Machine ID byte at
        mov     es,ax                   ; Offset 14, in ROM BIOS
        mov     al,Byte Ptr es:[0Eh]    ; Store machine ID byte
        pop     es                      ; PC=0FFh, XT=0FEh, AT=0FCh
        cli                             ; Interrupts off
        cmp     al,0FCh                 ; If ID Byte = 0FCh
        jz      RstAT                   ; Then Reset AT
        cmp     al,0FEh                 ; Else If NOT PC/XT
        jc      RstX                    ; Then phooey on PC Jr
                                        ;  and NON-Compatibles
RstPC:  in      al,21h                  ; Else Get and Save
        mov     ah,al                   ; Current Interrupt
        mov     al,13h                  ; Mask for PC or XT
        out     20h,al
        jmp     short $+2               ; Delay
        mov     al,8                    ; Set up main vector number
        out     21h,al
        jmp     short $+2
        mov     al,9
        out     21h,al
        jmp     short $+2
        mov     al,ah                   ; Restore mask and reset
        out     21h,al                  ; previous interrupt state
        jmp     Short RstX              ; Interrupts back on and exit

RstAT:  xor     al,al                   ; For AT, turn off any
        out     0F1h,al                 ; 80287 math coprocessor
        jmp     short $+2               ; Delay
        in      al,21h                  ; Get current interrupt mask
        mov     ah,al                   ; and save it
        mov     al,11h
        out     20h,al
        jmp     short $+2
        mov     al,8                    ; Set up main vector number
        out     21h,al
        jmp     short $+2
        mov     al,4
        out     21h,al
        jmp     short $+2
        mov     al,1
        out     21h,al
        jmp     short $+2
        mov     al,ah                   ; Restore mask, reset
        out     21h,al                  ; previous interrupt state
        jmp     short $+2

RstSlv: in      al,0A1h                 ; For slave 8259,
        mov     ah,al                   ; Get and save current Mask
        mov     al,11h
        out     0A0h,al
        jmp     short $+2               ; Delay
        mov     al,70h
        out     0A1h,al
        jmp     short $+2
        mov     al,2
        out     0A1h,al
        jmp     short $+2
        mov     al,1
        out     0A1h,al
        jmp     short $+2
        mov     al,ah                   ; Restore mask, reset
        out     0A1h,al                 ; previous interrupt state
RstX:   sti                             ; Interrupts back on
        Ret                             ; Exit
Rst8259 EndP
align   16
buffer  equ     $
Cseg    EndS
        End     Main

        Full credit should remain with Kim Kokkonen and
        TurboPower Software for developing this TSR
        management system.  The UnMark program with its
        Version 3.0 changes to Mark, Watch and FMark has
        been written as an exercise in assembly language
        programming.

        The UnMark size advantage may not be important to
        you and you may disagree with our elimination of
        the /K and /N options.  DoubleDOS users who are
        comfortable NOT using the /R option to avoid a
        ReSet of the 8259 may be annoyed at having to
        use /R to NOT ReSet; however, other AT users
        may be happy that they don't have to use /R.
        Likewise, you may prevent a display of MCBs
        by selecting the /D option to PREVENT it.

        These programs are made available for your use and
        education in the same way that the ShowTSRs program
        that replaced MAPMEM entered into the public domain.

        Any ideas, techniques, algorithms or coding that does
        not already belong to TurboPower Software is released
        for use in the public domain.

        With the ReMark replacement for the TurboPower DISABLE
        program completed, all former Pascal programs have now
        been converted to assembly language.

        You are welcome to the code and TurboPower Software to
        the glory.
                            from
                                    Tom Gilbert's Heart & Mind
