;   _______________________________________________________________
;  |                                                               |
;  |            Copyright (C) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  Program Title : FastScr.Asm                                  |    | ___
;  |  Author        : Steven Lutrov                                |    |    |
;  |  Revision      : 2.01                                         |    |    |
;  |  Date          : 1990-03-16                                   |    |    |
;  |  Language      : Turbo Assembler                              |    |    |
;  |                                                               |    |    |
;  |  Description   : Assembly Functions For Primitive Screen      |    |    |
;  |                : manipulation .                               |    |    |
;  |                : Tested with Turbo Pascal 5.0 & 5.5           |    |    |
;  |                                                               |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;


Code    Segment Word  Public

Assume  Cs:Code,Ds:Data


Public Background,Blinkoff,Blinkon,Screencolour,Colourx
Public Cursordown,Cursorleft,Cursorright,Cursoroff,Cursoron,Cursorup
Public Dspat,Foreground,Formatleft,Formatright,Getcolour,Getpage
Public Intenseoff,Intenseon,Normal,Reverse,Rowcolour,Setcolour,Setpage
Public Dspcolour,Dsplncolour,Dsp,Dspln,Dspend,Dsppart
Public Dspjust,Dspvert


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;                       Local Subroutine Called By Dspend
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Writeit Proc
                Push Dx                 ;Save Dx
                Mov  Dx,Es              ;Get Video Buffer Address
                Cmp  Byte Ptr[Bp+10],0  ;Protect Against Snow?
                Je   Writeitc9          ;Jump Ahead If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Char-Attri In Bx
Writeitc8:      In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Writeitc8          ;Loop Untill 0
                Cli                     ;Disable Interrupts
Writeitc9:      In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Writeitc9          ;Loop Untill 1
                Mov  Ax,Bx              ;Return Char-Attri To Ax
Writeitc0:      Stosw                   ;Write The Char And Attri
                Pop  Dx                 ;Restore Dx And Return
                Ret
Writeit Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;      Main Procedures And Functions Commence Here All Using Far Calls
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Background(Code: Char);
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Background Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Al,Textattr        ;Get Textattr
                And  Al,1111B           ;Turn Off Four High Bits
                Mov  Bl,[Bp+6]          ;Get The Code
                Cmp  Bl,97              ;Lower Case?
                Jae  Background1        ;Jump Ahead If So
                Or   Al,10000000B       ;Set Intensity Bit
                Add  Bl,32              ;Make It Lower Case
Background1:    Sub  Bh,Bh              ;Use Bh As Mask
                Cmp  Bl,107             ;Black?
                Je   Background2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,98              ;Blue?
                Je   Background2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,103             ;Green?
                Je   Background2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,99              ;Cyan?
                Je   Background2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,114             ;Red?
                Je   Background2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,109             ;Magenta?
                Je   Background2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,121             ;Yellow?
                Je   Background2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,119             ;White?
                Je   Background2        ;Jump If So
                Jmp  Short Background3  ;Else Don'T Change Colour
Background2:    Mov  Cl,4               ;Shift Left By Four Bits
                Shl  Bh,Cl              ;Make The Shift
                Or   Al,Bh              ;Set The Bits
                Mov  Textattr,Al        ;Change Textattr
                Pop  Bp                 ;Restore Bp
Background3:    Ret  2
Background Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Blinkoff;
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Blinkoff Proc Far
                Mov  Al,Textattr        ;Get The Current Colour
                And  Al,01111111B       ;Clear The Relevant Bit
                Mov  Textattr,Al        ;Set The Value
                Ret
Blinkoff Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Blinkon;
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Blinkon Proc Far
                Mov  Al,Textattr        ;Get The Current Colour
                Or   Al,10000000B       ;Set The Relevant Bit
                Mov  Textattr,Al        ;Set The Value
                Ret
Blinkon Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Screencolour(X_Pos,Y_Pos,X_Num,Y_Num,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Screencolour Proc Far
                Cld                     ;Direction Flag Forward
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Place In Es
                Sub  Ax,Ax              ;
                Mov  Al,[Bp+12]         ;Get Y_Pos
                Dec  Ax                 ;Count From 0
                Mov  Dl,160             ;Bytes Per Y_Pos
                Mul  Dl                 ;Times Y_Pos
                Sub  Dx,Dx              ;
                Mov  Dl,[Bp+14]         ;Get Column
                Dec  Dx                 ;Count From 0
                Shl  Dx,1               ;Double For Attributes
                Add  Ax,Dx              ;Add To Y_Pos Offset
                Mov  Si,Ax              ;Es:Di Pts To First Char
                Inc  Si                 ;Shift To First Attribute
                Sub  Bx,Bx              ;
                Mov  Bl,[Bp+10]         ;X_Num In Bx
                Or   Bx,Bx              ;Test For Zero
                Jz   Screencol6         ;Quit If Zero
                Sub  Dx,Dx              ;
                Mov  Dl,[Bp+8]          ;Y_Pos In Dx
                Or   Dx,Dx              ;Test For Zero
                Jz   Screencol6         ;Quit If Zero
                Mov  Al,[Bp+6]          ;Attribute In Al
Screencol1:     Mov  Cx,Bx              ;X_Num To Cx As Counter
                Mov  Di,Si              ;Move Ptr To Di
                Push Dx                 ;Save Y_Pos Counter
Screencol2:     Mov  Dx,Es              ;Get Video Buffer Address
                Cmp  Snow_Check,0       ;Protect Against Snow?
                Je   Screencol5         ;Jump If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bp,Ax              ;Save Ax Contents
Screencol3:     In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Screencol3         ;Loop Untill 0
                Cli                     ;Disable Interrupts
Screencol4:     In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Screencol4         ;Loop Untill 1
                Mov  Ax,Bp              ;Restore Ax Contents
Screencol5:     Stosb                   ;Write An Attribute Byte
                Inc  Di                 ;Pt To Next Attri Byte
                Loop Screencol2         ;Go Do Next Attri In Line
                Pop  Dx                 ;Restore Dx
                Dec  Dx                 ;Dec Y_Pos Counter
                Jz   Screencol6         ;Quit If Finished
                Add  Si,160             ;Move Ptr Forward 1 Y_Pos
                Jmp  Short Screencol1   ;Go Do Next Y_Pos
Screencol6:     Pop  Bp                 ;Restore Bp And Quit
                Sti                     ;Reenable Interrupts
                Ret  10
Screencolour Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Colourx(X_Pos,Y_Pos,Y_Num,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Colourx Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Ax,Video_Buff      ;Fetch Video_Buff Segment
                Mov  Es,Ax              ;Es Pts To Buffer
                Sub  Ax,Ax              ;
                Mov  Al,[Bp+12]         ;Get X_Pos Value
                Mov  Di,Ax              ;
                Dec  Di                 ;Count From 0
                Shl  Di,1               ;Double For Attri Bytes
                Mov  Al,[Bp+10]         ;Get Y_Pos Value
                Dec  Ax                 ;Count From 0
                Mov  Dl,160             ;Bytes Per Y_Pos
                Mul  Dl                 ;Times Columns
                Add  Di,Ax              ;Add Y_Pos Offset
                Inc  Di                 ;Es:Di Pts To 1St Attri
                Sub  Cx,Cx              ;
                Mov  Cl,[Bp+8]          ;Line Length In Cx
                Jcxz Colourx5           ;Quit If Null
                Mov  Al,[Bp+6]          ;Attribute In Al
                Cld                     ;Direction Flag Forward
Colourx1:       Mov  Dx,Es              ;Get Video Buffer Address
                Cmp  Snow_Check,0       ;Protect Against Snow?
                Je   Colourx4           ;Jump If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Ax Contents
Colourx2:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Colourx2           ;Loop Untill 0
                Cli                     ;Disable Interrupts
Colourx3:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Colourx3           ;Loop Untill 1
                Mov  Ax,Bx              ;Restore Ax Contents
Colourx4:       Stosb                   ;Change Attri Of 1 Char
                Add  Di,159             ;Move Pointer To Next Y_Pos
                Loop Colourx1           ;Go Change Next Attribute
Colourx5:       Sti                     ;Enable Interrupts
                Pop  Bp                 ;Restore Bp
                Ret  8
Colourx Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Cursordown(Y_Pos: Integer);
;
;
Data    Segment
        Extrn  Video_Page:Byte
Data    Ends
;
;
Cursordown Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page       ;Get Page Number
                Mov  Ah,3               ;Func To Get Cursor Pos
                Int  10H                ;Y_Pos In Dh, X_Pos In Dl
                Mov  Ah,2               ;Func To Set Cursor
                Add  Dh,[Bp+6]          ;Add Offset
                Cmp  Dh,24              ;In Range?
                Jna  Cursordown1        ;Jump Ahead If So
                Mov  Dh,24              ;Else Bottom Y_Pos
Cursordown1:    Int  10H                ;Reset Cursor
                Pop  Bp                 ;Restore Bp
                Ret  2
Cursordown Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Cursorleft(Columns: Integer);
;
;
Data    Segment
        Extrn  Video_Page:Byte
Data    Ends
;
;
Cursorleft Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page      ;Get Page Number
                Mov  Ah,3               ;Func To Get Cursor Pos
                Int  10H                ;Y_Pos In Dh, X_Pos In Dl
                Mov  Ah,2               ;Func To Set Cursor
                Sub  Dl,[Bp+6]          ;Subtract Offset
                Cmp  Dl,79              ;In Range?
                Jna  Cursorleft1        ;Jump Ahead If So
                Mov  Dl,0               ;Else Left Column
Cursorleft1:    Int  10H                ;Reset Cursor
                Pop  Bp                 ;Restore Bp
                Ret  2
Cursorleft Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Cursoroff;
;
Data    Segment
        Extrn  Startline:Byte
        Extrn  Stopline:Byte
Data    Ends
;
;
Cursoroff Proc Far
                Mov  Ah,3               ;Func To Get Cursor Lines
                Mov  Bh,0               ;Page 0
                Int  10H                ;Ch=Start, Cl=Stop
                Mov  Startline,Ch       ;Save Startline
                Mov  Stopline,Cl        ;Save Stopline
                Mov  Cl,0               ;Make Stopline 0
                Mov  Ch,20              ;Use Too-High Number For Startline
                Mov  Ah,1               ;Func To Set Cursor Lines
                Int  10H                ;Make Cursor Invisible
                Ret
Cursoroff Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Cursoron;
;
Data    Segment
        Extrn  Startline:Byte
        Extrn  Stopline:Byte
Data    Ends
;
;
Cursoron Proc Far
                Mov  Ch,Startline       ;Fetch Former Startline
                Mov  Cl,Stopline        ;...And Stopline
                Mov  Ah,1               ;Func To Set Cursor Lines
                Int  10H                ;Make Cursor Invisible
                Ret
Cursoron Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Cursorright(Columns: Integer);
;
;
Data    Segment
        Extrn  Video_Page:Byte
Data    Ends
;
;
Cursorright Proc  Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page      ;Get Page Number
                Mov  Ah,3               ;Func To Get Cursor Pos
                Int  10H                ;Y_Pos In Dh, X_Pos In Dl
                Mov  Ah,2               ;Func To Set Cursor
                Add  Dl,[Bp+6]          ;Add Offset
                Cmp  Dl,79              ;In Range?
                Jna  Cursoron1          ;Jump Ahead If So
                Mov  Dl,79              ;Else Right Column
Cursoron1:      Int  10H                ;Reset Cursor
                Pop  Bp                 ;Restore Bp
                Ret  2
Cursorright Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Cursorup(Y_Pos: Integer);
;
;
Data    Segment
        Extrn  Video_Page:Byte
Data    Ends
;
;
Cursorup Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page      ;Get Page Number
                Mov  Ah,3               ;Func To Get Cursor Pos
                Int  10H                ;Y_Pos In Dh, X_Pos In Dl
                Mov  Ah,2               ;Func To Set Cursor
                Sub  Dh,[Bp+6]          ;Subtract Offset
                Cmp  Dh,24              ;In Range?
                Jna  Cursorup1          ;Jump Ahead If So
                Mov  Dh,0               ;Else Top Y_Pos
Cursorup1:      Int  10H                ;Reset Cursor
                Pop  Bp                 ;Restore Bp
                Ret  2
Cursorup Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dspat(Strx: Stype; X_Pos,Y_Pos,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Video_Page:Byte
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Dspat Proc Far
                Cld                     ;Direction Flag Forward
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Push Ds                 ;Save Turbo'S Ds
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Place In Es
                Mov  Bl,Snow_Check      ;Fetch Snow_Check
                Mov  Bh,Video_Page      ;Fetch Video_Page
                Lds  Si,Dword Ptr[Bp+12] ;Ds:Si Pts To Strx
                Mov  [Bp+14],Bx         ;Save Video_Page And Snow_Check
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;String Len Counted In Cx
                Inc  Si                 ;Pt Ds:Si To First Char
                Sub  Ax,Ax              ;
                Mov  Al,[Bp+10]         ;Get X_Pos Value
                Mov  Di,Ax              ;
                Mov  Al,[Bp+8]          ;Get Y_Pos Value
                Dec  Ax                 ;Count From 0
                Mov  Dl,160             ;Bytes Per Y_Pos
                Mul  Dl                 ;Times Y_Pos
                Dec  Di                 ;Count Cols From 0
                Shl  Di,1               ;Double For Attributes
                Add  Di,Ax              ;Es:Di Pts To Lst Pos
                Jcxz Display5           ;If Null, Set Cursor,Quit
                Mov  Ah,[Bp+6]          ;Get Attribute
Display1:       Lodsb                   ;Get A Character
                Cmp  Byte Ptr[Bp+14],0  ;Protect Against Snow?
                Je   Display4           ;Jump Ahead If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Ah Contents
Display2:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Display2           ;Loop Untill 0
                Cli                     ;Disable Interrupts
Display3:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Display3           ;Loop Untill 1
                Mov  Ax,Bx              ;Restore Ah Contents
Display4:       Stosw                   ;Write It With Attribute
                Loop Display1           ;Go Do Next
                Sti                     ;Reenable Interrupts
Display5:       Mov  Bh,[Bp+15]         ;Video Page To Bh
                Mov  Ax,Di              ;Screen Pointer
                Shr  Ax,1               ;Div By 2 For Attributes
                Mov  Cl,80              ;Div By Number Cols
                Div  Cl                 ;Make The Division
                Mov  Dh,Al              ;Y_Pos Number
                Mov  Dl,Ah              ;X_Pos Number
                Mov  Ah,2               ;Function To Set Cursor
                Int  10H                ;Set Curs To Final Pos
Display6:       Pop  Ds                 ;Restore Ds And Quit                    
                Pop  Bp                 ;Restore Bp
                Ret  10
Dspat Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Foreground(Code: Char);
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Foreground Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Al,Textattr        ;Get Textattr
                And  Al,11110000B       ;Turn Off Four Low Bits
                Mov  Bl,[Bp+6]          ;Get The Code
                Cmp  Bl,97              ;Lower Case?
                Jae  Foreground1        ;Jump Ahead If So
                Or   Al,1000B           ;Set Intensity Bit
                Add  Bl,32              ;Make It Lower Case
Foreground1:    Sub  Bh,Bh              ;Use Bh As Mask
                Cmp  Bl,107             ;Black?
                Je   Foreground2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,98              ;Blue?
                Je   Foreground2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,103             ;Green?
                Je   Foreground2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,99              ;Cyan?
                Je   Foreground2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,114             ;Red?
                Je   Foreground2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,109             ;Magenta?
                Je   Foreground2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,121             ;Yellow?
                Je   Foreground2        ;Jump If So
                Inc  Bh                 ;Increase Mask Value
                Cmp  Bl,119             ;White?
                Je   Foreground2        ;Jump If So
                Jmp  Short Foreground3  ;Else Don'T Change Colour
Foreground2:    Or   Al,Bh              ;Set The Bits
                Mov  Textattr,Al        ;Change Textattr
                Pop  Bp                 ;Restore Bp
Foreground3:    Ret  2
Foreground Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Formatleft(Strx: Stype; How_Many: Integer; Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Video_Page:Byte
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Formatleft Proc Far
                Cld                     ;Set Direction Flag
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page      ;Get Bios Page
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Move To Es
                Push Ds                 ;Save Ds
                Mov  Ah,3               ;Bios Call For Curs Pos
                Int  10H                ;Dh-Dl Cursor Y_Pos-X_Pos
                Mov  Ax,160             ;Bytes Per Y_Pos
                Mul  Dh                 ;Times Y_Pos
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,Dl              ;Cols To Cx
                Shl  Cl,1               ;Double For Attributes
                Add  Ax,Cx              ;Add To Y_Pos Offset
                Mov  Di,Ax              ;Place Offset In Di
                Mov  Bl,Snow_Check     ;Fetch Snow_Check
                Lds  Si,Dword Ptr[Bp+10] ;Ds:Si Pts To Strx
                Mov  Byte Ptr[Bp+10],Bl ;Keep Snow_Check
                Mov  Cl,[Si]            ;Get Strx Length
                Jcxz Formatleft5        ;Jump If Null
                Push Dx                 ;Save Cursor Values
                Push Bx                 ;Save Video Page
                Mov  Bh,[Bp+6]          ;Attribute To Bh
                Inc  Si                 ;Forword Ptr To First Byte
Formatleft1:    Mov  Bl,[Si]            ;Get A Char
                Cmp  Byte Ptr[Bp+10],0  ;Protect Against Snow?
                Je   Formatleft4        ;Jump If Not
                Mov  Dx,3Dah            ;Status Byte Address
Formatleft2:    In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Formatleft2        ;Loop Untill 0
                Cli                     ;Disable Interrupts
Formatleft3:    In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Formatleft3        ;Loop Untill 1
Formatleft4:    Mov  Ax,Bx              ;Get Char-Attribute
                Stosw                   ;Write It
                Inc  Si                 ;Inc Strx Ptr
                Loop Formatleft1        ;Go Do Next Char
                Sti                     ;Reenable Interrupts
                Pop  Bx                 ;Video Page Back To Bh
                Pop  Dx                 ;Restore Cursor Values
Formatleft5:    Mov  Cx,[Bp+8]          ;Get New Cursor Offset
                Test Cx,8000H           ;Negative?
                Jz   Formatleft6        ;Jump If Not
                Neg  Cx                 ;Make Positive
                Add  Dh,Cl              ;Add To Y_Pos Offset
                Cmp  Dh,24              ;Bottom Of Screen?
                Jb   Formatleft7        ;Jump If Not
                Mov  Dh,24              ;Else Edge Of Screen
                Jmp  Short Formatleft7  ;To Set Cursor
Formatleft6:    Add  Dl,Cl              ;Add To X_Pos Offset
                Cmp  Dl,79              ;Off Screen?
                Jb   Formatleft7        ;Jump If Not
                Mov  Dl,79              ;Else Edge Of Screen
Formatleft7:    Mov  Ah,2               ;Bios Func To Set Curs
                Int  10H                ;Set New Cursor Pos
                Pop  Ds                 ;Restore Ds
                Pop  Bp                 ;Restore Bp And Quit
                Ret  8
Formatleft Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Formatright(Strx: Stype; How_Many: Integer; Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Video_Page:Byte
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Formatright Proc Far
                Cld                     ;Set Direction Flag
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page      ;Get Bios Page
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Move To Es
                Push Ds                 ;Save Ds
                Mov  Ah,3               ;Bios Call For Curs Pos
                Int  10H                ;Dh-Dl Cursor Y_Pos-X_Pos
                Mov  Ax,160             ;Bytes Per Y_Pos
                Mul  Dh                 ;Times Y_Pos
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,Dl              ;Cols To Cx
                Shl  Cl,1               ;Double For Attributes
                Add  Ax,Cx              ;Add To Y_Pos Offset
                Mov  Di,Ax              ;Place Offset In Di
                Mov  Bl,Snow_Check      ;Fetch Snow_Check
                Lds  Si,Dword Ptr[Bp+10] ;Ds:Si Pts To Strx
                Mov  Byte Ptr[Bp+10],Bl ;Keep Snow_Check
                Mov  Cl,[Si]            ;Get Strx Length
                Jcxz Formatright5       ;Jump If Null
                Push Dx                 ;Save Cursor Values
                Push Bx                 ;Save Video Page
                Mov  Bh,[Bp+6]          ;Attribute To Bh
                Add  Si,Cx              ;Pt To End Of Strx
Formatright1:   Mov  Bl,[Si]            ;Get A Char
                Cmp  Byte Ptr[Bp+10],0  ;Protect Against Snow?
                Je   Formatright4       ;Jump If Not
                Mov  Dx,3Dah            ;Status Byte Address
Formatright2:   In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Formatright2       ;Loop Untill 0
                Cli                     ;Disable Interrupts
Formatright3:   In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Formatright3       ;Loop Untill 1
Formatright4:   Mov  Ax,Bx              ;Get Char-Attribute
                Stosw                   ;Write It
                Sub  Di,4               ;Pull Back Scrn Ptr
                Dec  Si                 ;Dec Strx Ptr
                Loop Formatright1       ;Go Do Next Char
                Sti                     ;Reenable Interrupts
                Pop  Bx                 ;Video Page Back To Bh
                Pop  Dx                 ;Restore Cursor Values
Formatright5:   Mov  Cx,[Bp+8]          ;Get New Cursor Offset
                Test Cx,8000H           ;Negative?
                Jz   Formatright6       ;Jump If Not
                Neg  Cx                 ;Make Positive
                Add  Dh,Cl              ;Add To Y_Pos Offset
                Cmp  Dh,24              ;Bottom Of Screen?
                Jb   Formatright7       ;Jump If Not
                Mov  Dh,24              ;Else Edge Of Screen
                Jmp  Short Formatright7 ;To Set Cursor
Formatright6:   Add  Dl,Cl              ;Add To X_Pos Offset
                Cmp  Dl,79              ;Off Screen?
                Jb   Formatright7       ;Jump If Not
                Mov  Dl,79              ;Else Edge Of Screen
Formatright7:   Mov  Ah,2               ;Bios Func To Set Curs
                Int  10H                ;Set New Cursor Pos
                Pop  Ds                 ;Restore Ds
                Pop  Bp                 ;Restore Bp And Quit
                Ret  8
Formatright Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Function Getcolour(X_Pos,Y_Pos: Byte): Byte;
;
;
Data    Segment
        Extrn  Video_Page:Byte
Data    Ends
;
Getcolour Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page      ;Set The Page
                Mov  Dh,[Bp+6]          ;Y_Pos To Dh
                Dec  Dh                 ;Count From 0
                Mov  Dl,[Bp+8]          ;X_Pos To Dl
                Dec  Dl                 ;Count From 0
                Mov  Ah,2               ;Function To Set Cursor
                Int  10H                ;Set The Cursor
                Mov  Ah,8               ;Func To Read Attribute
                Int  10H                ;Colour Now In Ah
                Mov  Al,Ah              ;Colour To Al
                Sub  Ah,Ah              ;Clear High Byte
                Pop  Bp                 ;Restore Bp And Quit
                Ret  4
Getcolour Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Intenseoff;
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Intenseoff Proc Far
                Mov  Al,Textattr        ;Get The Current Colour
                And  Al,11110111B       ;Clear The Relevant Bit
                Mov  Textattr,Al        ;Set The Value
                Ret
Intenseoff Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Intenseon;
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Intenseon Proc Far
                Mov  Al,Textattr        ;Get The Current Colour
                Or   Al,1000B           ;Set The Relevant Bit
                Mov  Textattr,Al        ;Set The Value
                Ret
Intenseon Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Normal;
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Normal Proc Far
                Mov  Al,Textattr        ;Get Current Setting
                And  Al,10001000B       ;Relevant Bits Off
                Or   Al,111B            ;Relevant Bits On
                Mov  Textattr,Al        ;Set New Value
                Ret
Normal Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Reverse;
;
;
Data    Segment
        Extrn  Textattr:Byte
Data    Ends
;
;
Reverse Proc Far
                Mov  Al,Textattr        ;Get The Current Colour
                And  Al,10001000B       ;Relevant Bits Off
                Or   Al,1110000B        ;Relevant Bits On
                Mov  Textattr,Al        ;Set New Value
                Ret
Reverse Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Rowcolour(X_Pos,Y_Pos,X_Num,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Rowcolour Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Ax,Video_Buff      ;Segment Of Video_Buff
                Mov  Es,Ax              ;Move To Es
                Sub  Ax,Ax              ;
                Mov  Al,[Bp+12]         ;Get X_Pos Value
                Mov  Di,Ax              ;
                Dec  Di                 ;Count From 0
                Mov  Al,[Bp+10]         ;Get Y_Pos Value
                Dec  Ax                 ;Count From 0
                Mov  Dl,160             ;Bytes Per Y_Pos
                Mul  Dl                 ;Times Number Y_Pos
                Shl  Di,1               ;Double For Attri Bytes
                Add  Di,Ax              ;Add Y_Pos Offset
                Inc  Di                 ;Es:Di Pts To 1St Attri
                Sub  Cx,Cx              ;
                Mov  Cl,[Bp+8]          ;Line Length In Cx
                Jcxz Rowcolour5         ;Quit If Null
                Mov  Al,[Bp+6]          ;Attribute In Al
                Cld                     ;Direction Flag Forward
Rowcolour1:     Cmp  Snow_Check,0       ;Protect Against Snow?
                Je   Rowcolour4         ;Jump If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Ax Contents
Rowcolour2:     In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Rowcolour2         ;Loop Untill 0
                Cli                     ;Disable Interrupts
Rowcolour3:     In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Rowcolour3         ;Loop Untill 1
                Mov  Ax,Bx              ;Restore Ax Contents
Rowcolour4:     Stosb                   ;Change Attri Of 1 Char
                Inc  Di                 ;Skip Pointer Over Next
                Loop Rowcolour1         ;Go Change Next Attribute
Rowcolour5:     Sti                     ;Reenable Interrupts
                Pop  Bp                 ;Restore Bp
                Ret  8
Rowcolour Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Setcolour(X_Pos,Y_Pos,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Page:Byte
Data    Ends
;
;
Setcolour Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Bh,Video_Page      ;Set The Page
                Mov  Dh,[Bp+8]          ;Y_Pos To Dh
                Dec  Dh                 ;Count From 0
                Mov  Dl,[Bp+10]         ;X_Pos To Dl
                Dec  Dl                 ;Count From 0
                Mov  Ah,2               ;Function To Set Cursor
                Int  10H                ;Set The Cursor
                Mov  Ah,8               ;Func To Read Attribute
                Int  10H                ;Char Now In Al
                Mov  Ah,9               ;Function To Write Char
                Mov  Cx,1               ;Write At 1 Pos Only
                Mov  Bl,[Bp+6]          ;New Attribute
                Int  10H                ;Set The New Attribute
                Pop  Bp                 ;Restore Bp
                Ret  6
Setcolour Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Setpage(Pagenumber: Integer);
;
Setpage Proc Far
                Mov  Bx,Sp              ;Bx Pts To Stack
                Mov  Ah,5               ;Function Number
                Mov  Al,Ss:[Bx+4]       ;Page Number
                Int  10H                ;Set The Current Page
                Ret  2
Setpage Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dspcolour(Strx: Stype; Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Video_Page:Byte
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Dspcolour Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Push Ds                 ;Ds Changed
                Cld                     ;Direction Flag Forward
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Place In Es
                Mov  Bh,Video_Page      ;Set The Cursor Page
                Mov  Bl,Snow_Check      ;Get Snow_Check
                Mov  Ah,3               ;Bios Func For Cursor Pos
                Int  10H                ;Now Dh-Dl Holds Y_Pos-X_Pos
                Lds  Si,Dword Ptr[Bp+8] ;Ds:Si Pts To Strx
                Mov  [Bp+8],Bx          ;Save Page Number And Snow_Check
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;String Len Counted In Cx
                Jcxz Dspc8              ;Quit If Null
                Inc  Si                 ;Pt Ds:Si To First Char
                Mov  Ax,160             ;Byte Per Row
                Mul  Dh                 ;Multiply By Num Rows
                Sub  Dh,Dh              ;Now Dx Holds Num Cols
                Shl  Dx,1               ;Double For Attri Bytes
                Add  Ax,Dx              ;Cursor Offset In Buffer
                Mov  Di,Ax              ;Now Es:Di Pts To Pos
                Mov  Bx,3998            ;Scroll If Won'T Fit...
                Sub  Bx,Di              ;Space Left
                Mov  Ax,Cx              ;Chars To Be Printed
                Shl  Ax,1               ;Double For Attributes
                Cmp  Bx,Ax              ;Enough Room?
                Jge  Dspc3              ;Jump Ahead If So
                Sub  Ax,Bx              ;Amount Space Required
                Mov  Bl,160             ;Byte Per Y_Pos
                Div  Bl                 ;Divide
                Cmp  Ah,0               ;Any Remainder?
                Je   Dspc1              ;If Not, Jump Ahead
                Inc  Al                 ;Else, Scroll 1 More Line
Dspc1:          Push Cx                 ;Save String Length
                Push Bp                 ;Scrolling Changes Bp
                Push Ax                 ;Save Num Lines Scrolled
                Mov  Bh,[Bp+6]          ;Attribute Of New Lines
                Mov  Cx,0000H           ;Top Left Y_Pos-X_Pos
                Mov  Dx,184Fh           ;Bottom Right Y_Pos-X_Pos
                Mov  Ah,6               ;Upwards Scroll Function
                Int  10H                ;Make The Scroll
                Pop  Cx                 ;Num Lines Scrolled In Cl
                Sub  Ch,Ch              ;Clear Ch, Use Cx Counter
Dspc2:          Sub  Di,160             ;Screen Ptr Back 1 Line
                Loop Dspc2              ;Repeat For Ea Ln Of Scrl
                Pop  Bp                 ;Restore Bp
                Pop  Cx                 ;Restore String Length
Dspc3:          Mov  Ah,[Bp+6]          ;Get Attribute
Dspc4:          Lodsb                   ;Get A Character
                Mov  Dx,Es              ;Get Video Buffer Address
                Cmp  Byte Ptr[Bp+8],0   ;Protect Against Show?
                Je   Dspc7              ;Jump Ahead If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Ax Contents
Dspc5:          In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Dspc5              ;Loop Untill 0
                Cli                     ;Disable Interrupts
Dspc6:          In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Dspc6              ;Loop Untill 1
                Mov  Ax,Bx              ;Restore Ax Contents
Dspc7:          Stosw                   ;Write Char And Attri
                Loop Dspc4              ;Go Do Next
                Sti                     ;Reenable Interrupts
                Mov  Ax,Di              ;Now Set New Cursor Pos
                Mov  Dl,160             ;Chars In A Y_Pos
                Div  Dl                 ;Divide Scrn Ptr
                Shr  Ah,1               ;Div Remainder By 2
                Mov  Dl,Ah              ;Bios: X_Pos In Dl
                Mov  Dh,Al              ;Y_Pos In Dh
                Mov  Bh,[Bp+9]          ;Page Number
                Mov  Ah,2               ;Function Number
                Int  10H                ;Set The Cursor
Dspc8:          Pop  Ds                 ;Restore Ds And Quit
                Pop  Bp                 ;Restore Bp
                Ret  6
Dspcolour Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dsp(Strx: Stype);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Video_Page:Byte
        Extrn  Snow_Check:Byte
        Extrn  Textattr:Byte
Data    Ends
;
;
Dsp    Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Push Ds                 ;Ds Changed
                Cld                     ;Direction Flag Forward
                Mov  Ax,Video_Buff      ;Get Video Buffer Address
                Mov  Es,Ax              ;Place It In Es
                Mov  Al,Textattr        ;Get Colour
                Mov  Ah,Snow_Check      ;Get Snow_Check
                Mov  Bh,Video_Page      ;Set The Cursor Page
                Lds  Si,Dword Ptr[Bp+6] ;Ds:Si Pts To Strx
                Mov  [Bp+6],Ax          ;Save Colour And Snow_Check
                Mov  [Bp+8],Bh          ;Save Video_Page
                Mov  Ah,3               ;Bios Func For Cursor Pos
                Int  10H                ;Now Dh-Dl Holds Y_Pos-X_Pos
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;String Len Counted In Cx
                Cmp  Cl,0               ;Null String?
                Je   Dspll8             ;Quit If So
                Inc  Si                 ;Now Ds:Si Pts To Strx
                Mov  Ax,160             ;Cursor Pos: Bytes In Y_Pos
                Mul  Dh                 ;Multiply By Num Y_Pos
                Sub  Dh,Dh              ;Now Dx Holds Num Cols
                Shl  Dx,1               ;Double For Attri Bytes
                Add  Ax,Dx              ;Cursor Offset In Buffer
                Mov  Di,Ax              ;Now Es:Di Pts To Pos
                Mov  Bx,3998            ;Scroll If Won'T Fit...
                Sub  Bx,Di              ;Space Left
                Mov  Ax,Cx              ;Chars To Be Printed
                Shl  Ax,1               ;Double For Attributes
                Cmp  Bx,Ax              ;Enough Room?
                Jge  Dspll3             ;Jump Ahead If So
                Sub  Ax,Bx              ;Amount Space Required
                Mov  Bl,160             ;Bytes In A Y_Pos
                Div  Bl                 ;Divide
                Cmp  Ah,0               ;Any Remainder?
                Je   Dspll1             ;If Not, Jump Ahead
                Inc  Al                 ;Else, Scroll 1 More Line
Dspll1:         Push Cx                 ;Save String Length
                Push Bp                 ;Scrolling Changes Bp
                Push Ax                 ;Save Num Lines Scrolled
                Mov  Bh,7               ;Attribute Of New Lines
                Mov  Cx,0000H           ;Top Left Y_Pos-X_Pos
                Mov  Dx,184Fh           ;Bottom Right Y_Pos-X_Pos
                Mov  Ah,6               ;Upwards Scroll Function
                Int  10H                ;Make The Scroll
                Pop  Cx                 ;Num Lines Scrolled In Cl
                Sub  Ch,Ch              ;Clear Ch, Use Cx Counter
Dspll2:         Sub  Di,160             ;Screen Ptr Back 1 Line
                Loop Dspll2             ;Repeat For Ea Ln Of Scrl
                Pop  Bp                 ;Restore Bp
                Pop  Cx                 ;Restore String Length
Dspll3:         Mov  Ah,[Bp+6]          ;Get Attribute
Dspll4:         Lodsb                   ;Get A Character
                Cmp  Byte Ptr[Bp+7],0   ;Protect Against Snow?
                Je   Dspll7             ;Jump Ahead If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Char/Attri In Bx
Dspll5:         In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Dspll5             ;Loop Untill 0
                Cli                     ;Disable Interrupts
Dspll6:         In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Dspll6             ;Loop Untill 1
                Mov  Ax,Bx              ;Restore Char To Ax
Dspll7:         Stosw                   ;Write It With Attribute
                Loop Dspll4             ;Go Do Next
                Sti                     ;Reenable Interrupts
                Mov  Ax,Di              ;Now Set New Cursor Pos
                Mov  Dl,160             ;Chars In A Y_Pos
                Div  Dl                 ;Divide Scrn Ptr
                Shr  Ah,1               ;Div Remainder By 2
                Mov  Dl,Ah              ;Bios: X_Pos In Dl
                Mov  Dh,Al              ;Y_Pos In Dh
                Mov  Bh,[Bp+8]          ;Page Number
                Mov  Ah,2               ;Function Number
                Int  10H                ;Set The Cursor
Dspll8:         Pop  Ds                 ;Restore Ds And Quit
                Pop  Bp                 ;Restore Bp
                Ret  4
Dsp    Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dspln(Strx: Stype);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Video_Page:Byte
        Extrn  Snow_Check:Byte
        Extrn  Textattr:Byte
Data    Ends
;
;
Dspln  Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Push Ds                 ;Ds Changed
                Cld                     ;Direction Flag Forward
                Mov  Ax,Video_Buff      ;Get Video Buffer Address
                Mov  Es,Ax              ;Place In Es
                Mov  Al,Textattr        ;Get Colour Value
                Mov  Ah,Snow_Check      ;Get Snow_Check
                Mov  Bh,Video_Page      ;Set The Cursor Page
                Lds  Si,Dword Ptr[Bp+6] ;Ds:Si Pts To Strx
                Mov  [Bp+8],Bh          ;Save Page Numberzz
                Mov  [Bp+6],Ax          ;Save Colour And Snow_Check
                Mov  Ah,3               ;Bios Func For Cursor Pos
                Int  10H                ;Now Dh-Dl Holds Y_Pos-X_Pos
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;String Len Counted In Cx
                Inc  Si                 ;Now Ds:Si Pts To Strx
                Mov  Ax,160             ;Cursor Pos: Bytes In Y_Pos
                Mul  Dh                 ;Multiply By Num Y_Pos
                Sub  Dh,Dh              ;Now Dx Holds Num Cols
                Shl  Dx,1               ;Double For Attri Bytes
                Add  Ax,Dx              ;Cursor Offset In Buffer
                Mov  Di,Ax              ;Now Es:Di Pts To Pos
                Mov  Bx,3840            ;Scrl If Won'T Fit Y_Pos 24
                Sub  Bx,Di              ;Space Left
                Mov  Ax,Cx              ;Chars To Be Printed
                Shl  Ax,1               ;Double For Attributes
                Or   Cx,Cx              ;Test For Null String
                Jnz  Dspline1           ;Jump If Not Null
                Cmp  Di,3840            ;Last Y_Pos?
                Jnge Dspline1           ;Jump If Not
                Mov  Al,1               ;Scroll If Null On Y_Pos 25
                Jmp  Short Dspline2     ;Jump Ahead
Dspline1:       Cmp  Bx,Ax              ;Enough Room?
                Jge  Dspline4           ;Jump Ahead If So
                Sub  Ax,Bx              ;Amount Space Required
                Mov  Bl,160             ;Bytes In A Y_Pos
                Div  Bl                 ;Divide
                Cmp  Ah,0               ;Any Remainder?
                Je   Dspline2           ;If Not, Jump Ahead
                Inc  Al                 ;Else, Scroll 1 More Line
Dspline2:       Push Cx                 ;Save String Length
                Push Bp                 ;Scrolling Changes Bp
                Push Ax                 ;Save Num Lines Scrolled
                Mov  Bh,7               ;Attribute Of New Lines
                Mov  Cx,0000H           ;Top Left Y_Pos-X_Pos
                Mov  Dx,184Fh           ;Bottom Right Y_Pos-X_Pos
                Mov  Ah,6               ;Upwards Scroll Function
                Int  10H                ;Make The Scroll
                Pop  Cx                 ;Num Lines Scrolled In Cl
                Sub  Ch,Ch              ;Clear Ch, Use Cx Counter
Dspline3:       Sub  Di,160             ;Screen Ptr Back 1 Line
                Loop Dspline3           ;Repeat For Ea Ln Of Scrl
                Pop  Bp                 ;Restore Bp
                Pop  Cx                 ;Restore String Length
Dspline4:       Or   Cx,Cx              ;Test For Null String
                Jnz  Dspline5           ;Jump If Not Null
                Add  Di,160             ;Increase Screen Ptr
                Jmp  Dspline9           ;Jump And Set Cursor
Dspline5:       Mov  Ah,[Bp+6]          ;Get Attribute
                Lodsb                   ;Get A Character
                Cmp  Byte Ptr[Bp+7],0   ;Protect Against Snow?
                Je   Dspline8           ;Jump Ahead If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Char-Attri In Bx
Dspline6:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Dspline6           ;Loop Untill 0
                Cli                     ;Disable Interrupts
Dspline7:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Dspline7           ;Loop Untill 1
                Mov  Ax,Bx              ;Char-Attri Back To Ax
Dspline8:       Stosw                   ;Write It With Attribute
                Loop Dspline5           ;Go Do Next
                Sti                     ;Reenable Interrupts
Dspline9:       Mov  Ax,Di              ;Now Set New Cursor Pos
                Mov  Dl,160             ;Chars In A Y_Pos
                Div  Dl                 ;Divide Scrn Ptr
                Shr  Ah,1               ;Div Remainder By 2
                Mov  Dh,Al              ;Bios: Y_Pos In Dh
                Mov  Dl,Ah              ;X_Pos In Dl
                Cmp  Dl,0               ;Already At New Line?
                Je   Dspline10          ;If So, Jump Ahead
                Inc  Dh                 ;Else Add 1 More Line
                Mov  Dl,0               ;Set Cursor To X_Pos 0
Dspline10:      Mov  Bh,[Bp+8]          ;Page Number
                Mov  Ah,2               ;Function Number
                Int  10H                ;Set The Cursor
                Pop  Ds                 ;Restore Ds
                Pop  Bp                 ;Restore Bp
                Ret  4
Dspln  Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dspend(Strx: Stype; X_Pos,Y_Pos,Length,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Snow_Check:Byte
        Extrn  Errreturn:Byte
Data    Ends
;
;
Dspend Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Push Ds                 ;Ds Changed
                Cld                     ;Set Direction Flag
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Es Pts To Buffer
                Mov  Bl,Snow_Check      ;Get Snow_Check Before Change Ds
                Lds  Si,Dword Ptr[Bp+14] ;Ds:Si Pts To Strx
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;String Len Counted In Cx
                Inc  Si                 ;Pt Si To 1St Chr Of Strx
                Sub  Ax,Ax              ;
                Mov  Al,[Bp+10]         ;Get Y_Pos Value
                Mov  Byte Ptr[Bp+10],Bl ;Save Snow_Check
                Mov  Byte Ptr[Bp+11],1  ;Errreturn 1 = Len(Strx) > Length
                Dec  Ax                 ;Count From Zero
                Mov  Dl,160             ;160 Bytes Per Line
                Mul  Dl                 ;Times Number Y_Pos
                Sub  Dx,Dx              ;
                Mov  Dl,[Bp+8]          ;Move Line Length To Dx
                Or   Dx,Dx              ;Null?
                Jz   Dspendll1          ;Quit If So
                Mov  Byte Ptr[Bp+11],0  ;Else 0 = No Error
Dspendll1:      Cmp  Dx,Cx              ;Strx Shorter?
                Jnae Dspendll2          ;Jump Ahead If So
                Sub  Dx,Cx              ;Num Chars At End Of Line
                Jmp  Short Dspendll3    ;Jump Ahead
Dspendll2:      Mov  Dx,0               ;Else Draw No Extra Chars
Dspendll3:      Sub  Bx,Bx              ;
                Mov  Bl,[Bp+12]         ;Get X_Pos Value
                Mov  Di,Bx              ;
                Dec  Di                 ;Count From Zero
                Shl  Di,1               ;Double For Attri Bytes
                Add  Di,Ax              ;Now Es:Di Pts To Lst Pos
                Mov  Ah,[Bp+6]          ;Get Attribute
                Jcxz Dspendll5          ;Jump Ahead If Strx Null
Dspendll4:      Lodsb                   ;Get A Character
                Call Writeit            ;Write Char And Attri
                Loop Dspendll4          ;Go Do Next
Dspendll5:      Mov  Cx,Dx              ;Num Chars At End Of Line
                Mov  Al,32              ;Space Character
                Jcxz Dspendll7          ;Jump If None To Write
Dspendll6:      Call Writeit            ;Write Char And Attribute
                Loop Dspendll6          ;Go Do Next
Dspendll7:      Pop  Ds                 ;Restore Ds
                Mov  Al,[Bp+11]         ;Fetch Errreturn
                Mov  Errreturn,Al       ;Set It
                Pop  Bp                 ;Restore Bp
                Sti                     ;Reenable Interrupts
                Ret  12                 ;Return To Caller
Dspend Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dsplncolour(Strx: Stype; Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Video_Page:Byte
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Dsplncolour   Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Push Ds                 ;Ds Changed
                Cld                     ;Direction Flag Forward
                Mov  Ax,Video_Buff      ;Get Video Buffer Address
                Mov  Es,Ax              ;Place In Es
                Mov  Bh,Video_Page      ;Set The Cursor Page
                Mov  Bl,Snow_Check      ;Fetch Snow_Check
                Mov  Ah,3               ;Bios Func For Cursor Pos
                Int  10H                ;Now Dh-Dl Holds Y_Pos-X_Pos
                Lds  Si,Dword Ptr[Bp+8] ;Ds:Si Pts To Strx
                Mov  [Bp+8],Bx          ;Save Video_Page And Snow_Check
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;String Len Counted In Cx
                Inc  Si                 ;Now Ds:Si Pts To Strx
                Mov  Ax,160             ;Cursor Pos: Bytes In Y_Pos
                Mul  Dh                 ;Multiply By Num Y_Pos
                Sub  Dh,Dh              ;Now Dx Holds Num Cols
                Shl  Dx,1               ;Double For Attri Bytes
                Add  Ax,Dx              ;Cursor Offset In Buffer
                Mov  Di,Ax              ;Now Es:Di Pts To Pos
                Mov  Bx,3840            ;Scrl If Won'T Fit Y_Pos 24
                Sub  Bx,Di              ;Space Left
                Mov  Ax,Cx              ;Chars To Be Printed
                Shl  Ax,1               ;Double For Attributes
                Or   Cx,Cx              ;Test For Null String
                Jnz  Dsplnc1            ;Jump If Not Null
                Cmp  Di,3840            ;Last Y_Pos?
                Jnge Dsplnc1            ;Jump If Not
                Mov  Al,1               ;Scroll If Null On Y_Pos 25
                Jmp  Short Dsplnc2      ;Jump Ahead
Dsplnc1:        Cmp  Bx,Ax              ;Enough Room?
                Jge  Dsplnc4            ;Jump Ahead If So
                Sub  Ax,Bx              ;Amount Space Required
                Mov  Bl,160             ;Bytes In A Y_Pos
                Div  Bl                 ;Divide
                Cmp  Ah,0               ;Any Remainder?
                Je   Dsplnc2            ;If Not, Jump Ahead
                Inc  Al                 ;Else, Scroll 1 More Line
Dsplnc2:        Push Cx                 ;Save String Length
                Push Bp                 ;Scrolling Changes Bp
                Push Ax                 ;Save Num Lines Scrolled
                Mov  Bh,[Bp+6]          ;Attribute Of New Lines
                Mov  Cx,0000H           ;Top Left Y_Pos-X_Pos
                Mov  Dx,184Fh           ;Bottom Right Y_Pos-X_Pos
                Mov  Ah,6               ;Upwards Scroll Function
                Int  10H                ;Make The Scroll
                Pop  Cx                 ;Num Lines Scrolled In Cl
                Sub  Ch,Ch              ;Clear Ch, Use Cx Counter
Dsplnc3:        Sub  Di,160             ;Screen Ptr Back 1 Line
                Loop Dsplnc3            ;Repeat For Ea Ln Of Scrl
                Pop  Bp                 ;Restore Bp
                Pop  Cx                 ;Restore String Length
Dsplnc4:        Or   Cx,Cx              ;Test For Null String
                Jnz  Dsplnc5            ;Jump If Not Null
                Add  Di,160             ;Increase Screen Ptr
                Jmp  Dsplnc10           ;Jump And Set Cursor
Dsplnc5:        Mov  Ah,[Bp+6]          ;Get Attribute
Dsplnc6:        Lodsb                   ;Get A Character
                Mov  Dx,Es              ;Get Video Buffer Address
                Cmp  Byte Ptr[Bp+8],0   ;Protect Against Snow?
                Je   Dsplnc9            ;Jump Ahead If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Ax Contents
Dsplnc7:        In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Dsplnc7            ;Loop Untill 0
                Cli                     ;Disable Interrupts
Dsplnc8:        In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Dsplnc8            ;Loop Untill 1
                Mov  Ax,Bx              ;Char/Attri Back To Ax
Dsplnc9:        Stosw                   ;Write It With Attribute
                Loop Dsplnc6            ;Go Do Next
                Sti                     ;Reenable Interrupts
Dsplnc10:       Mov  Ax,Di              ;Now Set New Cursor Pos
                Mov  Dl,160             ;Chars In A Y_Pos
                Div  Dl                 ;Divide Scrn Ptr
                Shr  Ah,1               ;Div Remainder By 2
                Mov  Dh,Al              ;Bios: Y_Pos In Dh
                Mov  Dl,Ah              ;X_Pos In Dl
                Cmp  Dl,0               ;Already At New Line?
                Je   Dsplnc11           ;If So, Jump Ahead
                Inc  Dh                 ;Else Add 1 More Line
                Mov  Dl,0               ;Set Cursor To X_Pos 0
Dsplnc11:       Mov  Bh,[Bp+9]          ;Page Number
                Mov  Ah,2               ;Function Number
                Int  10H                ;Set The Cursor
                Pop  Ds                 ;Restore Ds
                Pop  Bp                 ;Restore Bp
                Ret  6
Dsplncolour   Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dsppart(Strx: Stype; Start,Numch,X_Pos,Y_Pos,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Snow_Check:Byte
        Extrn  Errreturn:Byte
Data    Ends
;
;
;
Dsppart Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Cl,Snow_Check      ;Get Snow_Check
                Push Ds                 ;Save Turbo'S Ds
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Es Pts To Buffer
                Sub  Bx,Bx              ;
                Mov  Bl,[Bp+8]          ;Y_Pos
                Dec  Bx                 ;Count From Zero
                Mov  [Bp+8],Cl          ;Save Snow_Check
                Sub  Cx,Cx              ;
                Mov  Cl,[Bp+10]         ;X_Pos
                Dec  Cx                 ;Count From Zero
                Mov  Ax,160             ;Bytes Per Y_Pos
                Mul  Bl                 ;Y_Pos Offset
                Shl  Cx,1               ;Dble Cols For Attributes
                Add  Ax,Cx              ;Offset To Start Position
                Mov  Di,Ax              ;Es:Di Pts To Start
                Lds  Si,Dword Ptr[Bp+16] ;Ds:Si Pts To Strx
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;Get String Descriptor
                Mov  Bh,1               ;Error Code 1 = Null Strx
                Jcxz Displaypartl7      ;Quit If Null
                Mov  Al,[Bp+14]         ;Startpoint
                Inc  Bh                 ;2 = Start Outside Of String
                Cmp  Al,Cl              ;Start Point In Range?
                Jnbe Displaypartl7      ;Quit If Not
                Or   Al,Al              ;Test For Zero
                Jz   Displaypartl7      ;
                Inc  Bh                 ;3 = Not Enough Room For Numch
                Cmp  Byte Ptr[Bp+12],0  ;Check For Numch Nonzero
                Jz   Displaypartl7      ;Quit If Zero
                Mov  Ah,Al              ;Copy Startpoint
                Add  Ah,[Bp+12]         ;Add Number Chars
                Dec  Ah                 ;Adjust
                Cmp  Ah,Cl              ;In Range?
                Jna  Displaypartl1      ;Jump Ahead If Ok
                Sub  Cl,[Bp+14]         ;Number Chars To Write
                Inc  Cl                 ;Adjust
                Jmp  Short Displaypartl2 ;
Displaypartl1:  Mov  Cl,[Bp+12]         ;Num Chars To Write
                Sub  Bh,Bh              ;0 = No Error
Displaypartl2:  Sub  Ah,Ah              ;Extend Byte Value
                Add  Si,Ax              ;Offset String Ptr
                Cld                     ;Forward Direction
                Mov  Ah,[Bp+6]          ;Get Screen Attribute
Displaypartl3:  Lodsb                   ;Get A Char From Strx
                Cmp  Byte Ptr[Bp+8],0   ;Protect Against Snow?
                Je   Displaypartl6      ;Jump If Not
                Push Ax                 ;Save Char-Attri
                Mov  Dx,3Dah            ;Status Byte Address
Displaypartl4:  In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Displaypartl4      ;Loop Untill 0
                Cli                     ;Disable Interrupts
Displaypartl5:  In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Displaypartl5      ;Loop Untill 1, Then Write
                Pop  Ax                 ;Restore Char-Attri
Displaypartl6:  Stosw                   ;Write The Char And Colour
                Loop Displaypartl3      ;Loop Untill Finished
Displaypartl7:  Sti                     ;Reenable Interrupts
                Pop  Ds                 ;Restore Ds And Quit
                Mov  Errreturn,Bh       ;Set Errreturn
                Pop  Bp                 ;Restore Bp
                Ret  14
Dsppart Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dspjust(Strx: Stype; X_Pos,Y_Pos,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Dspjust Proc Far
                Push Bp                 ;Save Bp
                Mov  Bp,Sp              ;Set Stack Frame
                Mov  Cl,Snow_Check      ;Get Snow_Check
                Push Ds                 ;Save Turbo'S Ds
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Es Pts To Buffer
                Sub  Bx,Bx              ;
                Mov  Bl,[Bp+8]          ;Y_Pos
                Dec  Bx                 ;Count From Zero
                Mov  Byte Ptr[Bp+8],Cl  ;Save Snow_Check
                Sub  Cx,Cx              ;
                Mov  Cl,[Bp+10]         ;X_Pos
                Dec  Cx                 ;Count From Zero
                Mov  Ax,160             ;Bytes Per Y_Pos
                Mul  Bl                 ;Y_Pos Offset
                Shl  Cx,1               ;Dble Cols For Attributes
                Add  Ax,Cx              ;Offset To Start Position
                Mov  Di,Ax              ;Es:Di Pts To Start
                Lds  Si,Dword Ptr[Bp+12] ;Ds:Si Pts To Strx
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;Get String Descriptor
                Jcxz Dspjust5           ;Quit If Null
                Add  Si,Cx              ;Pt To End Of Strx
                Std                     ;Reverse Direction
                Mov  Ah,[Bp+6]          ;Get Screen Attribute
Dspjust1:       Lodsb                   ;Get A Char From Strx
                Cmp  Byte Ptr[Bp+8],0   ;Protect Against Snow?
                Je   Dspjust4           ;Jump If Not
                Mov  Bx,Ax              ;Save Char-Attri In Bx
                Mov  Dx,3Dah            ;Status Byte Address
Dspjust2:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Dspjust2           ;Loop Untill 0
                Cli                     ;Disable Interrupts
Dspjust3:       In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Dspjust3           ;Loop Untill 1, Then Write
                Mov  Ax,Bx              ;Return Char/Attri To Ax
Dspjust4:       Stosw                   ;Write The Char And Colour
                Loop Dspjust1           ;Loop Untill Finished
Dspjust5:       Sti                     ;Reenable Interrupts
                Pop  Ds                 ;Restore Ds And Quit
                Pop  Bp                 ;Restore Bp
                Ret  10
Dspjust Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Procedure Dspvert(Strx: Stype; X_Pos,Y_Pos,Colour: Byte);
;
;
Data    Segment
        Extrn  Video_Buff:Word
        Extrn  Snow_Check:Byte
Data    Ends
;
;
Dspvert Proc Far
                Cld                     ;Direction Flag Forward
                Push Bp                 ;Bp Altered
                Mov  Bp,Sp              ;Set Stack Frame
                Push Ds                 ;Save Ds
                Mov  Ax,Video_Buff      ;Fetch Video_Buff
                Mov  Es,Ax              ;Es Points To Buffer
                Mov  Bl,Snow_Check      ;Fetch Snow_Check Before Ds Change
                Lds  Si,Dword Ptr[Bp+12] ;Ds:Si Pts To Strx
                Mov  [Bp+12],Bl         ;Save Snow_Check
                Sub  Ax,Ax              ;
                Mov  Al,[Bp+8]          ;Y_Pos To Ax
                Dec  Ax                 ;Count From 0
                Mov  Dl,160             ;Bytes Per Y_Pos
                Mul  Dl                 ;Times Y_Pos
                Sub  Dx,Dx              ;
                Mov  Dl,[Bp+10]         ;Column To Dx
                Dec  Dx                 ;Count From 0
                Shl  Dx,1               ;Double For Attributes
                Add  Ax,Dx              ;Add To Y_Pos Offset
                Mov  Di,Ax              ;Es:Di Pts To Screen
                Mov  Ah,[Bp+6]          ;Attribute To Ah
                Sub  Cx,Cx              ;Clear Cx
                Mov  Cl,[Si]            ;String Length To Cx
                Jcxz Dspvertical5       ;Quit If Null
Dspvertical1:   Inc  Si                 ;Inc String Pointer
                Mov  Al,[Si]            ;Char To Al
                Cmp  Byte Ptr[Bp+12],0  ;Protect Against Snow?
                Je   Dspvertical4       ;Jump Ahead If Not
                Mov  Dx,3Dah            ;Status Byte Address
                Mov  Bx,Ax              ;Save Char-Attri In Bx
Dspvertical2:   In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jnz  Dspvertical2       ;Loop Untill 0
                Cli                     ;Disable Interrupts
Dspvertical3:   In   Al,Dx              ;Get Status Byte
                Test Al,1               ;Test Bit
                Jz   Dspvertical3       ;Loop Untill 1
                Mov  Ax,Bx              ;Return Char-Attri To Ax
Dspvertical4:   Stosw                   ;Write The Char & Attri
                Add  Di,158             ;Ptr To Next Y_Pos
                Loop Dspvertical1       ;Go Write Next Char
Dspvertical5:   Sti                     ;Reenable Interrupts
                Pop  Ds                 ;Restore Ds
                Pop  Bp                 ;Restore Bp And Quit
                Ret  10
Dspvert Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Function Getpage: Integer;
;
;
Getpage Proc Far
                Mov  Ah,0Fh             ;Function Number
                Int  10H                ;Get The Current Page
                Mov  Al,Bh              ;Shift Page Num To Al
                Sub  Ah,Ah              ;Clear Ah
                Ret
Getpage Endp



Code    Ends

        End

;
