
PRINT_STR       equ     9
PRINT_CHAR      equ     6
END_PROG        equ     4CH
EXIT_FAILURE    equ     2
EXIT_SUCCESS    equ     0
GET_DTA         equ     2FH
GET_DATE        equ     2AH
GET_TIME        equ     2CH
FINDFIRST       equ     4EH
FINDNEXT        equ     4FH
OPENOLD_RW      equ     3D02H
CLOSEFILE       equ     3EH
SET_FILEDATE    equ     5701H

EXIT_FAILURE    equ     2


READONLY_ATR    equ     1
SYSTEM_ATR      equ     4
LABEL_ATR       equ     8
DIREC_ATR       equ     16
DONT_TOUCH      equ     DIREC_ATR+LABEL_ATR+SYSTEM_ATR

NAME_OFFSET     equ     30
ATTRIB_OFFSET   equ     21
MAX_FNAME_LEN   equ     13

CR              equ     13
LF              equ     10
TAB             equ     9


                assume  cs:_code,ds:_code

_code           segment

                org     80H
comd_len        label   byte

                org     81H
comd_line       label   byte

                org     100H

start           proc    near
                mov     dx,offset logo
                mov     ah,PRINT_STR
                int     21H

                mov     cl,[comd_len]
                or      cl,cl
                jnz     have_commands

                mov     dx,offset help_text     ;if no command line args
                mov     ah,PRINT_STR            ;  give help
                int     21H
                jmp     prog_done

have_commands:  sub     ch,ch
                mov     si,offset comd_line
                cmp     byte ptr [si],' '       ;if the command line starts
                jne     move_commands           ; with a ' ', skip past it

                inc     si

move_commands:  mov     di,offset comd_buf      ;save command address
                mov     [next_comd],di          ;  and move the command
                rep     movsb                   ;  line to local storage
                mov     byte ptr [end_char],' ' ;save space as last argument
                                                ;  ending char

                mov     ah,GET_DTA              ;get and save the
                int     21H                     ;  data transfer area addr
                mov     [dta_adr],bx


                mov     ah,GET_DATE             ;get the current date
                int     21H                     ;returns CX=year,DH=month
                                                ;  DL=day

                sub     cx,1980                 ;CH=yr-1980 in bits 8 to 14
                mov     ch,cl
                mov     cl,dh                   ;CL = month in bits 4 to 7
                add     cl,cl
                add     cl,cl
                add     cl,cl
                add     cl,cl
                add     cx,cx                   ;CX=(yr-1980) in bits 9-15
                                                ;   month in bits 5-8
                and     dx,001FH                ;   day in bits 0-4
                or      cx,dx
                mov     [orig_date],cx          ;save date

                or      cx,cx                   ;has the machine date
                jnz     get_time                ;been set?

                mov     dx,offset time_warning  ;if the machine date
                mov     ah,PRINT_STR            ;hasn't been set,
                int     21H                     ;tell of that, and
                mov     al,EXIT_FAILURE         ;end the program
                jmp     end_it

get_time:       mov     ah,GET_TIME             ;get the current time
                int     21H                     ;returns CH=hour,CL=minute
                                                ;  DH=seconds,DL=seconds/100
                add     cl,cl                   ;bit mapping for time
                add     cl,cl                   ;bits 15-11 = hour
                add     cx,cx                   ;bits 10-5 = minute
                add     cx,cx                   ;bits 4-0 = seconds/2
                add     cx,cx
                shr     dh,1
                or      cl,dh
                mov     [orig_time],cx          ;save it in DOS file format

get_argument:   cmp     [end_char],CR           ;if the last command line
                jne     process_arg             ;  ended with <cr>, all done
                jmp     prog_done

process_arg:    mov     bx,[next_comd]
                mov     si,bx
                mov     di,offset file_name
                mov     dx,((CR * 256) + ' ')

copy_comd:      lodsb                           ;copy the command arg over
                stosb                           ;stopping at 0,<cr>,' '
                cmp     al,dl
                je      copy_comd_done

                cmp     al,dh
                je      copy_comd_done

                or      al,al
                jnz     copy_comd

copy_comd_done: mov     [end_char],al           ;save last char of arg
                mov     [next_comd],si          ;save addr of next arg
                dec     di
                mov     [end_fname],di          ;save addr of end of arg
                inc     di                      ;  in file_name

                mov     byte ptr [di],'$'       ;terminate as DOS likes it
                mov     dx,offset indent_str    ;print file spec indented
                mov     ah,PRINT_STR            ;on a line by itself
                int     21H

                mov     dx,offset crlf
                mov     ah,PRINT_STR
                int     21H

                mov     byte ptr [di-1],0       ;make it an asciiz string

                mov     dx,offset file_name     ;search for the file
                sub     cx,cx                   ;attribute=0
                mov     ah,FINDFIRST
                int     21H

                jnc     trim_path

                mov     dx,offset not_found     ;if it's not found
                mov     ah,PRINT_STR            ;  say so and
                int     21H                     ;  skip to the next arg
                jmp     short get_argument

trim_path:      mov     bx,[end_fname]          ;search for last '\'
                mov     al,'\'                  ;  in the file spec

trim_path_loop: cmp     [bx],al
                je      end_path_found

                dec     bx
                cmp     bx,offset file_name
                jnb     trim_path_loop

                mov     bx,1+offset file_name   ;see if a drive is in it
                cmp     byte ptr [file_name+1],':'
                je      end_path_found

                sub     bx,2                    ;no path

end_path_found: inc     bx
                mov     byte ptr [bx],0         ;terminate path
                mov     [end_path],bx           ;save end addr

file_loop:      mov     si,[dta_adr]            ;don't touch system, rdonly
                add     si,ATTRIB_OFFSET        ;  or directories
                test    byte ptr [si],DONT_TOUCH
                jz      check_attrib
                jmp     short this_file_done

check_attrib:   add     si,(NAME_OFFSET-ATTRIB_OFFSET)
                mov     di,[end_path]           ;copy filename to
                mov     cx,MAX_FNAME_LEN        ;  end of path
                rep     movsb

                mov     bx,offset file_name     ;print the file name

print_fname:    mov     dl,[bx]
                or      dl,dl
                jz      do_linefeed

                mov     ah,PRINT_CHAR
                int     21H
                inc     bx
                jmp     short print_fname

do_linefeed:    mov     dx,offset crlf
                mov     ah,PRINT_STR
                int     21H

                mov     dx,offset file_name     ;open the file
                mov     bx,[dta_adr]
                mov     cl,[bx+ATTRIB_OFFSET]
                mov     ax,OPENOLD_RW
                int     21H
                jc      this_file_done

                push    ax                      ;save handle on stack

                mov     bx,ax                   ;set date and time
                mov     cx,[orig_time]
                mov     dx,[orig_date]
                mov     ax,SET_FILEDATE
                int     21H

                pop     bx                      ;close the file
                mov     ah,CLOSEFILE
                int     21H

this_file_done: mov     ah,FINDNEXT             ;look for the next file
                int     21H
                jnc     file_loop               ;if found, do it again
                jmp     get_argument            ;else get next argument



prog_done:      sub     al,al                   ;same as "mov al,EXIT_SUCCESS"
end_it:         mov     ah,END_PROG
                int     21H
start           endp




logo            db      TAB,'Touch2  v1.1 An Alternative Touch Program',CR,LF
                db      TAB,'Copyright 1992,1993  E Mulroy'
crlf            db      CR,LF,'$'
help_text       db      CR,LF,TAB,'Usage: Touch2 FileSpec {FileSpec ...}',CR,LF
                db      TAB,'Sets files to the current date and time.',CR,LF
                db      TAB,'Wildcards, drives and paths are allowed.',CR,LF,'$'
time_warning    db      TAB,'Error: Computer date is invalid',CR,LF,'$'
not_found       db      TAB,'File not found',CR,LF,'$'
indent_str      db      'finding '
file_name       db      81 dup (?)      ;filename with path
end_fname       dw      1 dup (?)       ;end addr of string in "file_name"
end_path        dw      1 dup (?)       ;end of path in "file_name"
end_char        db      1 dup (?)       ;end char from previous comd arg
comd_buf        db      128 dup (?)     ;local copy of the command line
next_comd       dw      1 dup (?)       ;addr of comd about to be processed
dta_adr         dw      1 dup (?)       ;addr of data transfer area
orig_time       dw      1 dup (?)       ;time when program started
orig_date       dw      1 dup (?)       ;date when program started
_code           ends

                end     start
