%TITLE  "Parse DOS command-line parameters"

	IDEAL
	DOSSEG
	MODEL	small

;----- Equates
TailLen		EQU	0080h
CommandTail	EQU	0081h

	DATASEG

numParams	dw	?
params		db   	128 DUP (?)


	CODESEG

	PUBLIC	ParamCount, GetParams, GetOneParam

%NEWPAGE
;--------------------------------------------------------------------
;  Separators - private routine to check for blanks, tabs, and CRs
;--------------------------------------------------------------------
;	Input:
;		ds:si addresses character to check
;	Output: zf = 1 : (je) character is a blank, tab or cr
;               zf = 0 : (jne) character is not a separator
;	Registers:
;		al
;-------------------------------------------------------------------
PROC	Separators
	mov	al,[si]
	cmp	al,020h
	je	@@10
	cmp	al,009h
	je	@@10
	cmp	al,00Dh
@@10:
	ret
ENDP	Separators
%NEWPAGE
;----------------------------------------------------------------------
;  ParamCount - returns number of parameters
;----------------------------------------------------------------------
;	Input:  none
:	Output:
;		dx = number of command-line parameters
;                 NOTE: when calling GetOneParam, cx should be less than
;			the value returned in dx by ParamCount
;	Registers:  dx
;----------------------------------------------------------------------
PROC	ParamCount
	mov	dx,[numParams]
	ret
ENDP	ParamCount
%NEWPAGE
;----------------------------------------------------------------------
; GetParams - get DOS command-line parameters
;----------------------------------------------------------------------
;	Input:  ds = Program Segment Prefix (PSP)
;		es = program's data segment
;			NOTE: until you change it,
;			      ds addresses the PSP when all *.EXE programs begin
:	Output: global params filled with ASCIIZ strings
;		[numParams] = number of parameters
;               ds = program's data segment (es not changed)
;	Registers:   al,bx,dx,si,di,ds
;----------------------------------------------------------------------
PROC	GetParams
        xor      ch,ch
        mov      cl,[ds:TailLen]
        inc      cx
        mov      si,CommandTail
        mov      di, offset params
@@10:
	call	Separators
	jne	@@20
	inc	si
	loop	@@10
@@20:
	push	cx
	jcxz	@@30
	cld
	rep	movsb
@@30:
	push	es
	pop	ds
	pop	cx
	xor	bx,bx
	jcxz	@@60
	mov	si, offset params
@@40:
	call	Separators
	jne	@@50
	mov	[byte ptr si],0
	inc 	bx
@@50:
	inc	si
	loop 	@@40
@@60:
	mov	[numParams], bx
	ret
ENDP	GetParams

%NEWPAGE
;----------------------------------------------------------------------
;  GetOneParam  - get one parameter address by number
;----------------------------------------------------------------------
;	Input:  cx = parameter number (0 = first)
;			NOTE: cx should always be less than the value
;				returned in dx by ParamCount
:	Output:
;		di = offset of ASCIIZ string for this parameter
;	Registers:  al,cx,di
;----------------------------------------------------------------------
PROC	GetOneParam
	xor	al,al
	mov	di, offset params
	jcxz	@@99
	cmp	cx, [numParams]
	jae	@@99
	cld
@@10:
	scasb
	jnz	@@10
	loop	@@10
@@99:
	ret
ENDP	GetOneParam

	END
