%TITLE  "Copy Input to Output"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256

;----- Equates
cr	EQU	13
lf	EQU	10

	DATASEG

exitCode	db	0
inFile		dw	0
outFile		dw	0
oneByte		db	0
prompt		db	cr,lf,'Erase this file? (y/n) ', 0
diskFull	db	cr,lf,'*** ERROR: disk is FULL', 0

notes	db	cr,lf,' KOPY copies all bytes from one file to a new file'
	db	cr,lf,'as a demonstration of file read/write methods'
	db	cr,lf,'in assembly language.  The program can be modified'
	db	cr,lf,'to process data on its way to the output file,'
	db	cr,lf,'although this version makes no changes to the'
	db	cr,lf,'information in the input file.  Use the program by'
	db	cr,lf,'supplying two file names: the first name is the'
	db	cr,lf,'file you want to read; the second is the new file'
	db	cr,lf,'that you want KOPY to create:',cr,lf
	db	cr,lf,'    KOPY <input file> <output file>',cr,lf, 0

	CODESEG

;---------- from STRIO.obj
	EXTRN	StrWrite:proc, NewLine:proc

;---------- from DISKERR.obj
	EXTRN	DiskErr:proc

;---------- from PARAMS.obj
	EXTRN	GetParams:proc, ParamCount:proc, GetOneParam:proc

Start:
	mov	ax,@data
	mov	es,ax
	call	GetParams
	call	ParamCount
	cmp	dx,2
	je	@@10
	mov	di, offset notes
	call	StrWrite
	jmp	Exit
@@10:
	xor	cx,cx
	call	GetOneParam
	mov	dx,di
	xor	al,al
	mov	ah,3Dh
	int	21h
	jnc	@@20
	jmp	Errors
@@20:
	mov	[inFile],ax
	mov	cx,1
	call	GetOneParam
	mov	dx,di
	call	FileExists
	jc	@@30
	call	StrWrite
	call	Confirm
	je	@@30
	jmp	Exit
@@30:
	mov	cx,1
	call	GetOneParam
	mov	dx,di
	xor	cx,cx
	mov	ah,3Ch
	int	21h
	jnc	@@40
	jmp	Errors
@@40:
	mov	[OutFile],ax
@@50:
	mov	ah,3Fh
	mov	bx,[inFile]
	mov	cx,1
	mov	dx, offset oneByte
	int 	21h
	jnc	@@60
	jmp	Errors
@@60:
	or	ax,ax
	jz	@@80
	mov	ah,40h
	mov	bx,[outFile]
	mov	cx,1
	mov	dx, offset oneByte
	int	21h
	jnc	@@70
	jmp	Errors
@@70:
	or	ax,ax
	jnz	@@50

	mov	di, offset diskFull
	call	StrWrite
@@80:
	mov	bx,[inFile]
	mov	ah,3Eh
	int	21h
	mov	bx,[outFile]
	mov	ah,3Eh
	int	21h
	jnc	Exit
	jmp	Errors
Exit:
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h
Errors:
	mov	[exitCode],al
	call	DiskErr
	jmp	Exit
%NEWPAGE
;------------------------------------------------------------------------
; FileExists - tests whether a file already exists
;------------------------------------------------------------------------
;	Input:  ds:dx = address of ASCIIZ file name
;	Output: cf = 0 : (jnc) file of this name exits
;		cf = 1 : (jc)  file of this name does not exist
;       Registers:
;------------------------------------------------------------------------
PROC	FileExists
	xor	al,al
	mov	ah,3Dh
	int	21h
	jc	@@99
	mov	bx,ax
	mov	ah,3Eh
	int	21h
	clc
@@99:
	ret
ENDP	FileExists
%NEWPAGE
;------------------------------------------------------------------------
; Confirm -  get YES/NO answer from user
;------------------------------------------------------------------------
;	Input:  none
;	Output: zf = 0 : (jnz) user typed N or n
;		zf = 1 : (jz)  user typed Y or y
;       Registers:
;------------------------------------------------------------------------
PROC	Confirm
	mov	di, offset Prompt
	call	StrWrite
	mov	ah,1
	int	21h
	cmp	al,'Y'
	je	@@99
	cmp	al,'y'
	je	@@99
	cmp	al,'N'
	je	@@20
	cmp	al,'n'
	jne	Confirm
@@20:
	cmp	al,'@'
@@99:
	ret
ENDP	Confirm

	END	Start
