%TITLE  "Keyboard INPUT routines"

	IDEAL
	DOSSEG
	MODEL	small

	CODESEG

	PUBLIC	KeyWaiting, GetCh

%NEWPAGE
;-----------------------------------------------------------------------
;  KeyWaiting - checks if a key press is available
;-----------------------------------------------------------------------
;	Input:  none
;	Output:	zf = 0 : (JNZ) Character is waiting to be read
;		zf = 1 : (JZ) No character is waiting
;	Registers: none (flags only)
;-----------------------------------------------------------------------
PROC	KeyWaiting
	push	ax
	mov	ah,1
	int	16h
	pop	ax
	ret
ENDP	KeyWaiting
%NEWPAGE
;-----------------------------------------------------------------------
;  GetCh - returns ASCII,control or function key value
;-----------------------------------------------------------------------
;	Input:  none
;	Output:	zf = 0 (ah = 1): (JNZ)  al = ASCII character
;		zf = 1 (ah = 0): (JZ)   al = ASCII control or function
;	Registers: ax
;-----------------------------------------------------------------------
PROC	GetCh
	xor	ah,ah
	int	16h
	or	al,al
	jnz	@@10
	xchg	ah,al
	add	al,32
	jmp	short @@20
@@10:
	xor	ah,ah
	cmp	al,32
	jb	@@20
	inc	ah
@@20:
	or	ah,ah
	ret
ENDP	GetCh

	END
