%TITLE  "Displays PC equipment information"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256

EOS	EQU	0
cr	EQU	13
lf	EQU	10

RECORD Equip printers:2,x:1,game:1,ports:3,y:1,drives:2,mode:2,ram:2,z:1,disk:1

;---------------------------------
;AND Mask 	|	FIELD
;---------------------------------
maskPrinters	= MASK	printers
maskGame	= MASK  game
maskPorts	= MASK  ports
maskDrives	= MASK  drives
maskMode	= MASK  mode
maskDisk	= MASK  disk

	DATASEG

exitCode	db	0
welcome		db	cr,lf,'Equipment determination'
		db	cr,lf,'(C) 1989 by Tom Swan',cr,lf,cr,lf,EOS
strPrinters	db	'Number of printers ........ ', EOS
strGame		db	'Game I/O ports ............ ', EOS
strPorts	db	'Number of RS232 ports ..... ', EOS
strDrives	db	'Disk drives (minus 1) ..... ', EOS
strMode		db	'Initial video mode ........ ', EOS
strDisk		db	'Has disk drive (1 = yes) .. ', EOS
string		db	40 DUP (?)


	CODESEG

;------ From STRIO.OBJ & BINASC.OBJ

	EXTRN	BinToAscDec:proc, StrWrite:proc, NewLine:proc

Start:
	mov	ax,@data
	mov	ds,ax
	mov	es,ax

	mov	di, OFFSET welcome
	call	StrWrite
	int	11h
	mov	bx,ax
	mov	di, OFFSET strPrinters
	mov	dx,maskPrinters
	mov	cl,printers
	call	ShowInfo
	mov	di, OFFSET strGame
	mov	dx,maskGame
	mov	cl,game
	call	ShowInfo
	mov	di, OFFSET strPorts
	mov	dx,maskPorts
	mov	cl,ports
	call	ShowInfo
	mov	di, OFFSET strDrives
	mov	dx,maskDrives
	mov	cl,drives
	call	ShowInfo
	mov	di, OFFSET strMode
	mov	dx, maskMode
	mov	cl,mode
	call	ShowInfo
	mov	di, OFFSET strDisk
	mov	dx,maskDisk
	mov	cl,disk
	call	ShowInfo
Exit:
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h
%NEWPAGE
;---------------------------------------------------------------------
;  ShowInfo - displays label & equipment value
;---------------------------------------------------------------------
; 	Input:	bx = Equipment data from int 11h
;		cl = Bit field shift count
;		dx = Bit field AND mask
;		di = Address of label string
;	Output:	label & data value displayed
;	Registers:  ax,cx
;---------------------------------------------------------------------
PROC	ShowInfo
	mov	ax,bx
	and	ax,dx
	shr	ax,cl
	call	StrWrite
	mov	di, OFFSET string
	mov	cx,1
	call	BinToAscDec
	call	StrWrite
	call	NewLine
	ret
ENDP	ShowInfo

	END	Start
