%NOLIST

;  *** Subset of DOS macros for Turbo Assembler (Ideal mode) ***

;----------------------------------------------------------------------
;  MS_DOS - call any DOS function
;----------------------------------------------------------------------
;	Input:  functionNumber = DOS function number
;	Output:	depends upon specific function
;	Registers: depends upon specific function
;----------------------------------------------------------------------
MACRO	MS_DOS	functionNumber
	mov	ah,functionNumber
	int	21h
ENDM	MS_DOS	functionNumber

;----------------------------------------------------------------------
;  (01h)  DOS_GetChar - get character with echo
;----------------------------------------------------------------------
;	Input:  none
;	Output:	al = next character from standard input
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_GetChar
	mov	ah,1
	int	21h
ENDM	DOS_GetChar

;----------------------------------------------------------------------
;  (02h)  DOS_PutChar - Write character to standard output
;----------------------------------------------------------------------
;	Input:  dl = ASCII character (0-255)
;	Output:	none
;	Registers: ah
;----------------------------------------------------------------------
MACRO	DOS_PutChar
	mov	ah,2
	int	21h
ENDM	DOS_PutChar

;----------------------------------------------------------------------
;  (05h)  DOS_PrintChar - Send character to standard list device
;----------------------------------------------------------------------
;	Input:  dl = ASCII character (0-255)
;	Output:	none
;	Registers: ah
;----------------------------------------------------------------------
MACRO	DOS_PrintChar
	mov	ah,5
	int	21h
ENDM	DOS_PrintChar

;----------------------------------------------------------------------
;  (07h)  DOS_GetRawChar - get unfiltered character with no echo
;----------------------------------------------------------------------
;	Input:  none
;	Output:	al = next character from standard input
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_GetRawChar
	mov	ah,7
	int	21h
ENDM	DOS_GetRawChar

;----------------------------------------------------------------------
;  (08h)  DOS_GetCharNoEcho - get Filtered character with no echo
;----------------------------------------------------------------------
;	Input:  none
;	Output:	al = next character from standard input
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_GetCharNoEcho
	mov	ah,8
	int	21h
ENDM	DOS_GetCharNoEcho

;----------------------------------------------------------------------
;  (09h)  DOS_PutString - write ASCII$ string to standard output
;----------------------------------------------------------------------
;	Input:  string = label of ASCII$ variable
;	Output:	none
;	Registers: ah,dx
;----------------------------------------------------------------------
MACRO	DOS_PutString string
	mov	ah,9
	mov	dx, offset string
	int	21h
ENDM	DOS_PutString

;----------------------------------------------------------------------
;  (0Bh)  DOS_Keypressed - checks if a keyboard character is waiting
;----------------------------------------------------------------------
;	Input:  none
;	Output:	 zf = 0 : (jnz) A character is waiting to be read
;	  	 zf = 1 : (jz) No character waiting
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_Keypressed
	mov	ah,0Bh
	int	21h
	or	al,al
ENDM	DOS_Keypressed

;----------------------------------------------------------------------
;  (0Eh)  DOS_SetDrive - change current drive
;----------------------------------------------------------------------
;	Input:  dl = drive number (0 = A:, 1 = B:, 2 = C:,..., 25 = Z:)
;		NOTE:   F: to Z: requires LASTDRIVE=Z in config.sys file
;	Output:	 al = total number of drives available
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_SetDrive
	mov	ah,0Eh
	int	21h
ENDM	DOS_SetDrive

;----------------------------------------------------------------------
;  (19h)  DOS_GetDrive - get current drive number
;----------------------------------------------------------------------
;	Input:  none
;	Output:	 al = drive number (0 = A:, 1 = B:, 2 = C:,..., 25 = Z:)
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_GetDrive
	mov	ah,19h
	int	21h
ENDM	DOS_GetDrive

;----------------------------------------------------------------------
;  (25h)  DOS_SetVector - set interrupt vector
;----------------------------------------------------------------------
;	Input:  interrupt = interrupt number (0-255)
;		address   = label at start of interrupt routine
;	Output:	 none
;	Registers: ax,dx
;----------------------------------------------------------------------
MACRO	DOS_SetVector  interrupt,address
	push	ds
	mov	ax, SEG address
	mov	ds,ax
	mov	dx, OFFSET address
	mov	ah,025h
	mov	al,interrupt
	int	21h
	pop	ds
ENDM	DOS_SetVector

;----------------------------------------------------------------------
;  (35h)  DOS_GetVector - get interrupt vector
;----------------------------------------------------------------------
;	Input:  interrupt = interrupt number (0-255)
;	Output:	es:bx = segment:offset address of interrupt
;	Registers: ax,bx,es
;----------------------------------------------------------------------
MACRO	DOS_GetVector  interrupt
	mov	al,interrupt
	mov	ah,35h
	int	21h
ENDM	DOS_GetVector

;----------------------------------------------------------------------
;  (3Bh)  DOS_ChDir - change current directory
;----------------------------------------------------------------------
;	Input:  dirName = label of ASCIIZ string in ds data segment
;	Output:	cf = 0 : (jnc) change was successful
;		cf = 1 : (jc) change was not successful
;		     ax = error code (3 = directory not found)
;	Registers: ax,dx
;----------------------------------------------------------------------
MACRO	DOS_ChDir	dirName
	mov	ah,3Bh
	mov	dx, OFFSET dirName
	int	21h
ENDM	DOS_ChDir

;----------------------------------------------------------------------
;  (3Ch)  DOS_CreateFile - creates a new file
;----------------------------------------------------------------------
;	Input:  fileName = label of ASCIIZ string in ds data segment
;		cx = attribute to use in directory
;			00 = normal file
;			01 = read-only (access denied for read/write)
;			02 = hidden (DIR does not show name)
;			04 = system file
;	Output:	cf = 0 : (jnc) File created
;			ax = file handle for future operations
;		cf = 1 : (jc)  File NOT created
;			ax = error code
;				3 = path not found
;				4 = no more handles available
;				5 = access denied
;	Registers: ax,dx
;----------------------------------------------------------------------
MACRO	DOS_CreateFile	fileName
	mov	ah,3Ch
	mov	dx, OFFSET fileName
	int	21h
ENDM	DOS_CreateFile

;----------------------------------------------------------------------
;  (3Dh)  DOS_OpenFile - open file for I/O
;----------------------------------------------------------------------
;	Input:  fileName = label of ASCIIZ string in ds data segment
;	Output:	cf = 0 : (jnc) File opened
;			ax = file handle for future operations
;		cf = 1 : (jc)  File NOT opened
;			ax = error code
;				2 = file not found
;				3 = path not found
;				4 = no more handles available
;				5 = access denied
;	Registers: ax,dx
;----------------------------------------------------------------------
MACRO	DOS_OpenFile	fileName
	mov	ah,3Dh
	mov	al,02
	mov	dx, OFFSET fileName
	int	21h
ENDM	DOS_OpenFile

;----------------------------------------------------------------------
;  (3Eh)  DOS_CloseFile - close a previously opened file
;----------------------------------------------------------------------
;	Input:  bx = file handle from DOS_CreateFile or DOS_OpenFile
;	Output:	cf = 0 : (jnc) File closed
;		cf = 1 : (jc)  File NOT closed
;			ax = error code
;				6 = bad handle or file was not open
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_CloseFile	fileName
	mov	ah,3Eh
	int	21h
ENDM	DOS_CloseFile

;----------------------------------------------------------------------
;  (3Fh)  DOS_ReadFile - read from  file or device
;----------------------------------------------------------------------
;	Input:  bx = file handle from DOS_CreateFile or DOS_OpenFile
;		cx = number of bytes requested to read
;		buffer = label of destination buffer in ds data segment
;		  NOTE: buffer must be at least cx bytes long !!
;	Output:	cf = 0 : (jnc) Read was successful
;			ax = actual number of bytes read (0 = at end of file)
;		cf = 1 : (jc)  read NOT successful
;			ax = error code
;				5 = access denied
;				6 = bad handle or file was not open
;	Registers: ax,dx
;----------------------------------------------------------------------
MACRO	DOS_ReadFile	buffer
	mov	ah,3Fh
	mov	dx, OFFSET buffer
	int	21h
ENDM	DOS_ReadFile

;----------------------------------------------------------------------
;  (40h)  DOS_WriteFile - write to  file or device
;----------------------------------------------------------------------
;	Input:  bx = file handle from DOS_CreateFile or DOS_OpenFile
;		cx = number of bytes requested to write
;		buffer = label of source buffer in ds data segment
;	Output:	cf = 0 : (jnc) Write was successful
;			ax = actual number of bytes written (0 = disk is FULL)
;		cf = 1 : (jc)  Write NOT successful
;			ax = error code
;				5 = access denied
;				6 = bad handle or file was not open
;	Registers: ax,dx
;----------------------------------------------------------------------
MACRO	DOS_WriteFile	buffer
	mov	ah,40h
	mov	dx, OFFSET buffer
	int	21h
ENDM	DOS_WriteFile

;----------------------------------------------------------------------
;  (42h)  DOS_Seek - change location for next read/write
;----------------------------------------------------------------------
;	Input:  bx = file handle from DOS_CreateFile or DOS_OpenFile
;		cx = high word of 32-byte offset
;		dx = low word of 32-byte offset
;	Output:	cf = 0 : (jnc) Seek was successful
;			dx = high word of 32-byte offset position after seek
;			ax = low word of 32-byte offset position after seek
;		cf = 1 : (jc)  Seek NOT successful
;			ax = error code
;				6 = bad handle or file was not open
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_Seek
	mov	ah,42h
	xor	al,al
	int	21h
ENDM	DOS_Seek

;----------------------------------------------------------------------
;  (47h)  DOS_GetDir - get name of current directory
;----------------------------------------------------------------------
;	Input:  string = address of 64-byte (minimum) variable
;	Output:	directory name inserted into string in ASCIIZ format
;	Registers: ax,dl,si
;----------------------------------------------------------------------
MACRO	DOS_GetDir	string
	mov	ah,47h
	xor	dl,dl
	mov	si, OFFSET string
	int	21h
ENDM	DOS_GetDir

;----------------------------------------------------------------------
;  (4Ch)  DOS_Terminate - End program
;----------------------------------------------------------------------
;	Input:  code = [label] or value to pass to DOS or parent process
;	Output:	none
;	Registers: ax
;----------------------------------------------------------------------
MACRO	DOS_Terminate	code
	mov	ah,4Ch
	mov	al,code
	int	21h
ENDM	DOS_Terminate

%LIST
