/******************************************************************
updown.c
	an in-line assembly language Function example
	   NOTE: you must use the TCC comand-line compiler for this !
********/

#pragma inline
#include <stdio.h>

extern void BumpStrUp(unsigned char far * TheString, int StringLength);
extern void BumpStrDown(unsigned char far * TheString, int StringLength);

char *MixedUp = "UppER aNd LOwEr CaSE";

main()
{
	printf("Before BumpStrUp: %s\n", MixedUp);
	BumpStrUp(MixedUp, strlen(MixedUp) );
	printf("After BumpStrUp:   %s\n", MixedUp);
	BumpStrDown( MixedUp, strlen(MixedUp) );
	printf("After BumpStrDown: %s\n", MixedUp);
}

void BumpStrUp(unsigned char far * TheString, int StringLength)
{
	asm 	les 	di,TheString
	asm	mov	cx,StringLength
	asm	jcxz	Exit
	asm	cld
NextChar:
	asm	mov	al, [Byte ptr es:di]
	asm	cmp	al, 'a'
	asm	jb	NotLower
	asm	cmp	al,'z'
	asm	ja	NotLower
	asm	sub	al,32
NotLower:
	asm	stosb
	asm	loop	NextChar
Exit:;
}


void BumpStrDown(unsigned char far * TheString, int StringLength)
{
	asm 	les 	di,TheString
	asm	mov	cx,StringLength
	asm	jcxz	Exit
	asm	cld
NextChar:
	asm	mov	al, [Byte ptr es:di]
	asm	cmp	al, 'A'
	asm	jb	NotUpper
	asm	cmp	al,'Z'
	asm	ja	NotUpper
	asm	add	al,32
NotUpper:
	asm	stosb
	asm	loop	NextChar
Exit:;
}
