%TITLE  "Single-step (trap) demo"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256


cr		EQU 	13
lf		EQU	10
Trapping	EQU	0
TurnOnTrap	EQU	1
TurnOffTrap	EQU	2


	DATASEG

exitCode	db	0
spaces		db	'    ',0
offMsg		db	cr,lf,'Single-step trap is off',cr,lf,0
onMsg		db	cr,lf,'Single-step trap is on',cr,lf,0
pauseMsg	db	cr,lf,'Press any key to continue ...',0
countMsg	db	cr,lf,lf,'Count = 50!',cr,lf,0
trapSwitch	db	0
string		db	40 DUP (?)
count		dw	?
trapSeg		dw	?
trapOfs		dw	?


	CODESEG

;--------- from STRIO.obj, BINASC.obj, KEYBOARD.obj
	EXTRN	StrWrite:proc, NewLine:proc, BinToAscDec:proc
	EXTRN	BinToAscHex:proc, GetCh:proc

Start:
	mov	ax,@data
	mov	ds,ax
	mov	es,ax
	mov	ax,3501h
	mov	[trapSeg],es
	mov	[trapOfs],bx
	push	ds
	mov	ax,2501h
	push	cs
	pop	ds
	mov	dx, offset Stepper
	int	21h
	pop	ds
	mov	di, offset offMsg
	call	Counter
	mov	di, offset onMsg
	mov	[trapSwitch], TurnOnTrap
	int	1
	call	Counter
	mov	[trapSwitch],TurnOffTrap

	mov	di, offset offMsg
	call	Counter
Exit:
	push 	ds
	mov	ax,2501h
	mov	ds,[trapSeg]
	mov	dx,[trapOfs]
	int	21h
	pop	ds
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h

PROC	Counter
	call	StrWrite
	call	Pause
	mov	[count],0
@@10:
	inc	[count]
	mov	ax,[count]
	mov	cx,4
	mov	di, offset string
	call	BinToAscDec
	call	StrWrite
	mov	di, offset spaces
	call	StrWrite
	cmp	[count],100
	jb	@@10
	ret
ENDP	Counter

PROC	Pause
	mov	di, offset pauseMsg
	call	StrWrite
	call	GetCh
	call	NewLine
	ret
ENDP	Pause

%NEWPAGE
;------------------------------------------------------------------------
; Stepper -   Single-step trap ISR
;------------------------------------------------------------------------
;	Input:   [trapSwitch] = TurnOnTrap    -> Single-step mode enabled
;		 [trapSwitch] = TurnOffTrap   -> Single-step mode disabled
;		 [trapSwitch] = ???           -> NO action
;	Output:  none
;       Registers:  none
;------------------------------------------------------------------------
PROC	Stepper
	sti
	push	bp
	mov	bp,sp
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	push	es
	mov	ax,@data
	mov	ds,ax
	mov	es,ax
	cmp	[trapSwitch], TurnOnTrap
	jne	@@10
	or	[word bp + 6], 0100h
	mov	[trapSwitch], Trapping
	jmp	@@99
@@10:
	cmp	[trapSwitch], TurnOffTrap
	jne	@@20
	and	[word bp + 6], 0FEFFh
	jmp	@@99
@@20:
	cmp	[count], 50
	jne	@@99
	mov	di,offset countMsg
	call	StrWrite
	call	Pause
	inc	[count]
	call	NewLine
@@99:
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	bp
	iret
ENDP	Stepper

	END	Start
