%TITLE  "Filter shell"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256

;----- Equates
InputHandle		EQU	0
OutputHandle		EQU	1
ErrOutHandle		EQU	2
bell			EQU	07
cr			EQU	13
lf			EQU	10
eof			EQU	26


	DATASEG

exitCode	db	0
errMessage	db	bell,cr,lf, '** Filter ERROR: '
lenErrMessage	=	$-errMessage
codeAccess	EQU	5
errAccess	db	'access denied',cr,lf
lenErrAccess	=	$-errAccess
codeNotOpen	EQU	6
errNotOpen	db	'bad handle or file not open', cr,lf
lenErrNotOpen	=	$-errNotOpen
codeDiskFull	EQU	29
errDiskFull	db	'disk full',cr,lf
lenErrDiskFull	=	$-errDiskFull
errGeneral	db	'unknown cause',cr,lf
lenErrGeneral	=	$-errGeneral
onechar	db	?


	CODESEG

Start:
	mov	ax,@data
	mov	ds,ax
	mov	es,ax

Repeat:
	call	ReadChar
	jz	Done
	call	WriteChar
	jnz	Repeat
	mov	[exitCode],codeDiskFull
	jmp	Exit
Done:
	mov	[oneChar],eof
	call	WriteChar
Exit:
	cmp	[exitCode],0
	jz	@@99
	call	DisplayError
@@99:
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h
%NEWPAGE
;----------------------------------------------------------------------
;  ReadChar - reads one character from standard input
;----------------------------------------------------------------------
; 	Input: none
;       Output: zf = 0 : al = next input character (0...255)
;               zf = 1 : no more input available
;       Registers: ax
;----------------------------------------------------------------------
PROC	ReadChar
	push	bx
	push	cx
	push	dx
	mov	ah,03Fh
	mov	bx,InputHandle
	mov	cx,1
	mov	dx, offset oneChar
	int	21h
	jnc	@@10
	mov	[exitCode],al
	jmp	Exit
@@10:
	or	ax,ax
	pop	dx
	pop	cx
	pop	bx
	ret
ENDP	ReadChar
%NEWPAGE
;----------------------------------------------------------------------
;  WriteChar - writes one character to standard output
;----------------------------------------------------------------------
; 	Input: [oneChar] = character to write
;       Output: zf = 0 : character written to standard output file
;               zf = 1 : output device is FULL (disk output only)
;       Registers: ax
;----------------------------------------------------------------------
PROC	WriteChar
	push	bx
	push	cx
	push	dx
	mov	ah,040h
	mov	bx,OutputHandle
	mov	cx,1
	mov	dx, offset oneChar
	int	21h
	jnc	@@10
	mov	[exitCode],al
	jmp	Exit
@@10:
	or	ax,ax
	pop	dx
	pop	cx
	pop	bx
	ret
ENDP	WriteChar
%NEWPAGE
;----------------------------------------------------------------------
;  DisplayError - displays error message
;----------------------------------------------------------------------
; 	Input: [exitCode] = nonZero error code
;       Output: none: error message sent to standard error-output device
;       Registers: ax,bx,cx,dx
;----------------------------------------------------------------------
PROC	DisplayError
	mov	cx,lenErrMessage
	mov	dx, offset errMessage
	call	DisplayString
	cmp	[exitCode],codeAccess
	jne	@@10
	mov	cx,lenErrAccess
	mov	dx, offset errAccess
	jmp	DisplayString
@@10:
	cmp	[exitCode],codeNotOpen
	jne	@@20
	mov	cx,lenErrNotOpen
	mov	dx, offset errNotOpen
	jmp	DisplayString
@@20:
	cmp	[exitCode], codeDiskFull
	jne	@@30
	mov	cx, lenErrDiskFull
	mov	dx,offset errDiskFull
	jmp	DisplayString
@@30:
	mov	cx, lenErrGeneral
	mov	dx, offset errGeneral
DisplayString:
	mov	ah,040h
	mov	bx,ErrOutHandle
	int	21h
	ret
ENDP	DisplayError

	END	Start
