%TITLE  "Display Disk Directory"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256

;----- Equates
FileName	EQU	30

	DATASEG

exitCode	db	0
defaultSpec	db	'*.*', 0
DTAseg		dw	?
DTAofs		dw	?
dirData		db	43 DUP (?)

	CODESEG

;---------- from PARAMS.obj
	EXTRN	GetParams:proc, ParamCount:proc, GetOneParam:proc

;---------- from STRINGS.obj
	EXTRN	StrLength:proc, StrWrite:proc, NewLine:proc

Start:
	mov	ax,@data
	mov	es,ax
	call	GetParams
	call	NewLine
	call	ParamCount
	mov	di, offset defaultSpec
	or	dx,dx
	jz	@@10
	xor	cx,cx
	call	GetOneParam
@@10:
	mov	bx, offset Action
	call	DirEngine
Exit:
	call	NewLine
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h
%NEWPAGE
;------------------------------------------------------------------------
; DirEngine - directory scan "engine"
;------------------------------------------------------------------------
;	Input:  cs:bx = address of subroutine
;		ds:di = address of ASCIIZ search string (e.g. *.ASM)
;	Output: routine at cs:bx called for each directory entry match
;       Registers:  ax,cx,dx + any changed in Action subroutine at cs:bx
;------------------------------------------------------------------------
PROC	DirEngine
	push	es
	push	bx
	mov	ah,2Fh
	int	21h
	mov	[DTAseg],es
	mov	[DTAofs],bx
	pop	bx
	pop     es
	mov	dx, offset dirData
	mov	ah,1Ah
	int	21h
	mov	ah,4Eh
	mov	cx,10h
	mov	dx,di
	jmp	short @@20
@@10:
	mov	ah,4Fh
@@20:
	int	21h
	jc	@@99
	call	bx
	jmp	@@10
@@99:
	push	ds
	mov	ds,[DTAseg]
	mov	dx,[DTAofs]
	mov	ah,1Ah
	int	21h
	pop	ds
	ret
ENDP	DirEngine
%NEWPAGE
;------------------------------------------------------------------------
; Action - called for each directory entry "hit"
;------------------------------------------------------------------------
;	Input:  dirData = directory entry (as returned by DOS)
;	Output: one file/subdirectory name displayed
;       Registers: ah,dl,cx,di
;------------------------------------------------------------------------
PROC	Action
	mov	di, offset dirData + FileName
	call	StrWrite
	call	StrLength
	sub	cx,16
	neg	cx
@@10:
	mov	ah,2
	mov	dl, ' '
	int	21h
	loop	@@10
	ret
ENDP	Action

	END	Start
