%TITLE  "80286/386 divide-fault ISR installer"

	IDEAL
	DOSSEG
	MODEL	tiny

;----- Equates
cr		EQU	13
lf		EQU	10

	DATASEG

welcome		db	cr,lf,'80286/386 Divide-Fault handler installed'
		db	cr,lf,'Address = ', 0
string		db	40 DUP (?)

	CODESEG

	ORG	100h

	EXTRN	StrWrite:proc, BinToAscHex:proc, NewLine:proc


Start:
	jmp	Begin

%NEWPAGE
;------------------------------------------------------------------------
; DivFault - divide-fault handler ISR
;------------------------------------------------------------------------
;	Input:  none (called internally upon a DIV or IDIV fault)
;	Output:  ax = 0 (al = 8-bit quotient, ax = 16-bit quotient)
;		   NOTE: program continues normally with the instruction
;			following the DIV or IDIV that caused the fault.
;       Registers:  ax changed
;------------------------------------------------------------------------
PROC	DivFault
	sti
	push	bp
	mov	bp,sp
	push	si
	push    ds
	lds	si,[bp + 2]
	lodsw
	and	ah,0C0h
	cmp	ah,0C0h
	je	@@10
	add	[word bp + 2], 2
@@10:	add	[word bp + 2], 2
	xor	ax,ax
	pop	ds
	pop	si
	pop	bp
	iret
ENDP	DivFault

Begin:
	mov	ax,2500h
	mov	dx, offset DivFault
	int	21h
	mov	di, offset welcome
	call	StrWrite
	mov	ax,cs
	call	ShowAX
	mov	dl, ':'
	mov	ah,2
	int	21h
	mov	ax, offset DivFault
	call	ShowAX
	call	NewLine
Exit:
	mov	dx, offset Begin
	int	27h



PROC	ShowAX
	mov	cx,4
	mov	di, offset string
	call	BinToAscHex
	call	StrWrite
	ret
ENDP	ShowAX

	END	Start
