%TITLE  "Convert Binary/Hexadecimal/Decimal numbers"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256

EOS	EQU	0
cr	EQU	13
lf	EQU	10
maxLen	EQU	40


	DATASEG

exitCode	db	0
welcome		db	cr,lf,'Convert binary/hexadecimal/decimal values'
		db	cr,lf,'(C) 1989 by Tom Swan',cr,lf
		db	cr,lf,'Press <ENTER> to quit.',cr,lf,EOS
prompt		db	cr,lf,cr,lf,'Value to convert? ', EOS
error		db	cr,lf,'*** ERROR:  illegal character in string',EOS
binary		db      cr,lf,'Binary ............. : ', EOS
hex		db	cr,lf,'Hexadecimal ........ : ', EOS
decimal		db	cr,lf,'Unsigned decimal ... : ', EOS
sdecimal	db	cr,lf,'Signed decimal ..... : ', EOS
value		dw	?
response	db	maxLen + 1 DUP (?)


	CODESEG

;----- from STRINGS.OBJ & STRIO.OBJ

	EXTRN	StrLength:proc, StrRead:proc
	EXTRN	StrWrite:proc, NewLine:proc

;----- from BINASC.OBJ

	EXTRN	BinToAscHex:proc, SBinToAscDec:proc, BinToAscDec:proc
	EXTRN	BinToAscBin:proc, AscToBin:proc


Start:
	mov	ax,@data
	mov	ds,ax
	mov	es,ax

	mov	di, OFFSET welcome
	call	StrWrite
Again:
	mov	di, OFFSET prompt
	call	StrWrite
	mov	di, OFFSET response
	mov	cx,maxLen
	call	StrRead
	call	NewLine
	call	StrLength
	jcxz	Exit
	call	AscToBin
	mov	[value],ax
	jnc	Continue
	mov	di, OFFSET error
	call	StrWrite
	jmp	Again
Continue:
	mov	di,OFFSET binary
	call	StrWrite
	mov	ax,[value]
	mov	cx,16
	mov	di,OFFSET response
	call	BinToAscBin
	call	StrWrite
	mov	di,OFFSET hex
	call	StrWrite
	mov	ax,[value]
	mov	cx,4
	mov	di,OFFSET response
	call	BinToAscHex
	call	StrWrite
	mov	di,OFFSET decimal
	call	StrWrite
	mov	ax,[value]
	mov	cx,1
	mov	di,OFFSET response
	call	BinToAscDec
	call	StrWrite
	mov	di,OFFSET sdecimal
	call	StrWrite
	mov	ax,[value]
	mov	cx,1
	mov	di,OFFSET response
	call	SBinToAscDec
	call	StrWrite
	jmp	Again
Exit:
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h

	END	Start
