%TITLE  "Slow Motion interrupt generator"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256

;----- Equates
delay		EQU	0010h
cr		EQU	13
lf		EQU	10
BIOSData	EQU	040h
LowTimer	EQU	006Ch
PIC8259		EQU	0020h
EOI		EQU	0020h

	DATASEG

exitCode	db	0
string		db	'This is a test of the timer',cr,lf
		db	' Slow-Mo interrupt handler',cr,lf,0
timerSeg	dw	?
timerOfs	dw	?


	CODESEG

;---------- from STRIO.obj  &  KEYBOARD.obj
	EXTRN	StrWrite:proc, KeyWaiting:proc


Start:
	mov	ax,@data
	mov	ds,ax
	mov	es,ax
	mov	[word cs:difference],delay
	push	es
	mov	ax, 351Ch
	int	21h
	mov	[timerSeg],es
	mov	[timerOfs],bx
	pop	es
	push	ds
	mov	ax,251Ch
	push	cs
	pop	ds
	mov	dx, offset SlowMo
	int	21h
	pop	ds
	mov	di, offset string
@@10:
	call	StrWrite
	call	KeyWaiting
	jz	@@10
	push	ds
	mov	ax,251Ch
	mov	dx,[timerOfs]
	mov	ds,[timerSeg]
	int	21h
	pop	ds
Exit:
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h

%NEWPAGE
;------------------------------------------------------------------------
; SlowMo - Slow motion timer  Interrupt Service Routine (ISR)
;------------------------------------------------------------------------
;	Input:  none
;	Output: none (waits for time difference)
;       Registers:  none
;------------------------------------------------------------------------
inProgress	db	0
difference	dw	0

PROC	SlowMo
	cmp	[byte cs:inProgress],0
	jne	@@99
	inc	[byte cs:inProgress]
	sti
	push	ax
	push	ds
	push	dx
	mov	al,EOI
	out	PIC8259,al
	mov	ax,BIOSData
	mov	ds,ax
	mov	ax, [word LowTimer]
@@10:
	mov	dx, [word LowTimer]
	sub	dx,ax
	cmp	dx, [cs:difference]
	jb	@@10
	cli
	dec	[byte cs:inProgress]
	pop	dx
	pop	ds
	pop	ax
@@99:
	iret
ENDP	SlowMo

	END	Start
