cat vrs2.h
/********************************************************
*                                                       *
*                        NOTICE                         *
*             AT&T COMMUNICATIONS PROPRIETARY           *
*          USE PURSUANT TO COMPANY INSTRUCTIONS         *
*                                                       *
*********************************************************
 
Name
    vrs2.h
    
Title
    Video Reservation Scheduler Header File
    
Date
        11/14/87
        08/12/88

Author
        Edgar J. Clark
        Tammy Johnson

Special Instructions
        Use  the compiler -D opt. for AMC, AFLC or SDIO to define COI.
 */

#include <stdio.h>
#include <time.h>


/*
 *   Place universal defines here...
 */

#define RESDIR "../submit_res/"

#define S_RES   "Sub_MAPS"

#define CLR_LINE    "n    |             |            |            |           |"
#define BUFF_FORM   "         |            |            |           |"
#define TELE "1-800-367-8722 or 1-703-430-5270"
#define TRUE 1
#define FALSE 0
#define ERROR -1
#define ROWS 50
#define COLS 80

/*
 *      Begin IFDEF's for the COI's
 */

#ifdef  AMC

#define COI     "amc_"
#define RMS 12

#define MAP_FORM        "/usr/vrcc/forms/res_amc.frm"

#define COI_HDR         "                        AMC VIDEO RESERVATION\
 SCHEDULER\n"

#endif


#ifdef  AFLC

#define COI     "aflc"
#define RMS 7

#define MAP_FORM        "/usr/vrcc/forms/res_aflc.frm"

#define COI_HDR         "                        AFLC VIDEO RESERVATION\
 SCHEDULER\n"

#endif


#ifdef  SDIO

#define COI     "sdio"
#define RMS 8

#define MAP_FORM        "/usr/vrcc/forms/res_sdio.frm"

#define COI_HDR         "                        SDIO VIDEO RESERVATION\
 SCHEDULER\n"

#endif


#ifdef  HQDA

#define COI     "hqda"
#define RMS 7

#define MAP_FORM        "/usr/vrcc/forms/res_hqda.frm"

#define COI_HDR         "                        HQDA VIDEO RESERVATION\
 SCHEDULER\n"

#endif

/*
 * Header file DEFINES for the editor.
 */


#define CR      0x0d
#define BSP     0x08
#define BELL    putchar(7)
#define CNTL(x) ('x'&0x1f)      /* CONTROL X */
#define DEL     0x7f
#define TAB     0x09
#define ESC     0x1b

/* Control character macros */
#define is_ctrl(x)      ((x > 0 && x < 0x1f) ? 1 : 0) /* returns 1 if control */


/* 5425 - ANSI Terminal definitions
 * and a PC6300 or MS DOS compatible
 * machine with the ANSI device driver
 * installed..
 */
#define CUR_ADD 0x5b
#define HOME    0x48
#define CLR     0x4a
#define LEFT    0x44
#define RIGHT   0x43
#define UP      0x41
#define DOWN    0x42
#define SEP     0x3b
#define END     0x48
<VRCC-ejc>