;****************************************************************************
;
; SHELL.ASM-
;
; 	This is a "typical" piece of starting code for the stdlib package.
;	Whenever you begin a new assembly language program you should start
;	with this code (or something similar to it).
;
;
; Global variables go here:
;
dseg		segment	para public 'data'
;
; Insert your global variables in here.
;
dseg		ends
;
;
;
;
cseg		segment	para public 'code'
		assume	cs:cseg, ds:dseg
;
		include	stdlib.a
;
; lesi- macro to do a "les di, constant"
;
lesi		macro	adrs
		mov     di, seg adrs
		mov	es, di
		lea	di, adrs
		endm
;
; ldxi- macro to do a "ldx si, constant" operation.
;
ldxi		macro	adrs
		mov	dx, seg adrs
		lea	si, adrs
		endm
;
; Variables that wind up being used by the standard library routines.
; The MemInit routine uses "PSP" and "zzzzzzseg" labels.  They must be
; present if you intend to use getenv, MemInit, malloc, and free.
;
;
		public	PSP
PSP		dw	?			;Must be in CODE segment!
;
;
; Some useful constants:
;
cr		equ	13
lf		equ	10
eos		equ	0
;
true		equ	1
false		equ	0
;
;
; Main is the main program.  Program execution always begins here.
;
Main		proc
		mov	cs:PSP, es		;Save pgm seg prefix
		mov	ax, seg dseg		;Set up the segment registers
		mov	ds, ax
		mov	es, ax
		mov	dx, 0			;Allocate all available RAM.
		MemInit
;
; Insert your main program here:
;
Quit:		mov     ah, 4ch
		int     21h
;
Main		endp
;
;
;
; Insert other procedures and functions down here.
;
;
;
cseg            ends
;
;
; Allocate a reasonable amount of space for the stack (2k).
;
sseg		segment	para stack 'stack'
stk		db	256 dup ("stack   ")
sseg		ends
;
;
;
; zzzzzzseg must be the last segment that gets loaded into memory!
; WARNING! Do not insert any segments (or other code/data) after
; this segment.
;
zzzzzzseg	segment	para public 'zzzzzz'
LastBytes	db	16 dup (?)
heap		db	1024 dup (?)	;Gets grabbed by Mem Mgr anyway!
zzzzzzseg	ends
		end	Main
