COMMENT ~RM132

Convert strings (up to 127 bytes long ONLY) to and from 6/8 bit bytes.
The high bit of the length byte is used to indicate a compressed string,
the original length is not changed -- the output length of each string
must be calculated: length - (length div 4)

str := 'That';
SixPack(str);     { length byte will be 128 + 4 afterwards }

{ to ouput }

I := length(str);
if I > 128 then   { string is compressed }
  begin
    dec(I,128);
    WriteLength := I - (I div 4);
  end
else WriteLength := length(str);

for I := 0 to WriteLength do
  write(str[I]);


Paul O'Nolan
CIS 72007,242
15 May 1989

Newstead, Forbes Place, Hatton of Fintray, Aberdeen AB2 0YB, Scotland UK

EndComment RM132~

; function ConvertibleToSixBits (var EightBitString): boolean;

	.MODEL	TPASCAL
	.DATA
TARGET		DB	255	DUP (?)
ENCODE		DW	255	DUP (?)
DECODE		DB	64	DUP (?)
EXTRN 	NONAZ:	BYTE			;' (),-.01:;=?'
	.CODE

SetupCodeTables PROC FAR; RETURNS binary: BYTE
	PUBLIC SetupCodeTables

; Used for mapping characters over a 64 character range.
; Range used is A..Z, a..z and 12 additional characters
; comprising NonAToZChars (NONAZ) -- externally defined.

	MOV	AX,SEG ENCODE
	MOV	ES,AX
	MOV	AX,-1
	MOV	CX,255			; for I := 0 to 255 do
	MOV	DI,OFFSET ENCODE	;   encode[I] := -1 (= no Xlation)
	CLD
	REP	STOSW			; [ES:DI] <- AX; DI <- DI + 2

	XOR	AX,AX			; for I := 0 to 11 do
	XOR	BX,BX
	MOV	CX,12
L1:
	MOV	SI,AX			;   begin
	MOV	BL,BYTE PTR NONAZ[SI]
	MOV	BYTE PTR DECODE[SI],BL	;     decode[I] := nonaz[I]
	MOV	DI,BX
	SHL	DI,1			; DI is SI as word ptr
	MOV	WORD PTR ENCODE[DI],SI	;     encode[nonaz[I]] := I
	INC	AX
	LOOP	L1			;   end


	MOV	BX,'A'
	SHL	BX,1
	LEA	DI,ENCODE[BX]		; ES set up already
	MOV	BX,'a'
	SHL	BX,1
	LEA	SI,ENCODE[BX]		; I2 := 'a'

	MOV	AX,12			; J := 12
	MOV	BX,38			; J2 := 38
	MOV	CX,26			; for I := 'A' to 'Z' do
	CLD				;   begin
NXTJ:
	MOV	[SI],BX 		;     encode[I2] := J2
	STOSW				;     encode[I]  := J
	INC	SI
	INC	SI
	INC	AX
	INC	BX
	DEC	CX
	JNZ	NXTJ			;   end

	MOV	DI,12			; J  := 12
	MOV	SI,38			; J2 := 38
	MOV	AL,'A'			; I  := 'A'
	MOV	BL,'a'			; I2 := 'a'
	MOV	CX,26			; for I := 'A' to 'Z' do
NXTDEC:					;   begin
	MOV	BYTE PTR DECODE[DI],AL	;     decode[J] := I
	MOV	BYTE PTR DECODE[SI],BL  ;     decode[J2] := I2
	INC	AX			;   end
	INC	BX
	INC	DI
	INC	SI
	DEC	CX
	JNZ	NXTDEC

	RET

SetupCodeTables ENDP


ConvertibleToSixBits PROC NEAR SIXSTR:DWORD; RETURNS BINARY: BYTE

	LES	SI,SIXSTR
	XOR	CX,CX
	MOV	CL,ES:[SI]		; load length byte
	LEA	DI,TARGET		; DI -> target[0] -- length byte
	MOV	BYTE PTR [DI],CL	; set up target length byte

	LEA	DX,ENCODE		; -> encode table
	XOR	BH,BH
NXTCHR:
	INC	SI			; -> next source character
	INC	DI			; -> next target character
	MOV	BL,ES:[SI]		; BL <- string[SI]
	SHL	BL,1			; convert to word ptr
	XCHG	DX,DI
	MOV	AX,WORD PTR [DI+BX]	; AX <- encode[string[SI]] (nb: AX)
	XCHG	DX,DI
	CMP	AX,-1			; translatable to 6 bits?
	JNZ	TX6OK			; Y
	XOR	AX,AX			; N
	JMP	BYENOW			;  --too bad
TX6OK:
	MOV	[DI],AL			; translate character
	LOOP	NXTCHR

	INC	CX			; was 0, set 'True'
	MOV	AX,CX			; set AX to 1: string is convertible

BYENOW:
	RET				; boolean result in AL

ConvertibleToSixBits ENDP


SixPack PROC FAR SIXSTR:DWORD;
	PUBLIC SixPack

	LES	SI,SIXSTR		; get address of string

	XOR	CX,CX
	MOV	CL,ES:[SI]		; load length byte
	CMP	CL,4			; if length < 4 or > 127 then
	JB	HDOZEN			;   it's not compressible
	CMP	CL,127
	JA	HDOZEN

	PUSH	SI			; save address ptr
	PUSH	CX			; and length byte

	PUSH	ES			; transfer
	PUSH	SI			;   on stack & check
	CALL	CONVERTIBLETOSIXBITS	; if string is convertible
	POP	CX			; restore length byte
	POP	SI			;   and address ptr
	OR	AL,AL
	JZ	HDOZEN			; N? then exit

; now transmit packed bytes from target to source (length byte not packed)

	LEA	DI,TARGET

	XOR	BX,BX			; BH = output byte
	MOV	BL,128			; mask for ORing with output byte
	OR	ES:[SI],BL		; high bit = packed string
	INC	SI			; -> 1st byte after length byte

GETNEXT:                                ; repeat
	INC	DI
	MOV	AL,[DI]			;   get "source" byte (from TARGET)
	MOV	CH,6			;   source bits; CL = source length
	SHL	AL,1			;   shift out
	SHL	AL,1			;             high nibble

ROLLYO:
	ROL	AL,1			;   set carry flag
	JNC	NOCARRY
	OR	BH,BL			;   set output bit
NOCARRY:
	SHR	BL,1			;   move mask to next bit
	OR	BL,BL			;   set flags
	JNZ	NOLOAD

	MOV	ES:[SI],BH		;   output packed byte
	XOR	BH,BH
	INC	SI
	MOV	BL,128

NOLOAD:
	DEC	CH
	JNZ	ROLLYO			;   loop until AL bits output
	DEC	CL
	JNZ	GETNEXT			; until all bytes packed
	MOV	ES:[SI],BH		; output any pending bits

HDOZEN:
	RET

SixPack	ENDP


UnSixpack PROC FAR SIXSTR:DWORD;
	PUBLIC UnSixpack

	LES	SI,SIXSTR		; get address of string
	MOV	AL,ES:[SI]		; load length byte
	RCL	AL,1			; is it a packed string?
	JNC	NOTSIX

	CLC				; restore length byte
	RCR	AL,1			; to unpacked length
	MOV	ES:[SI],AL		; update length byte
	XOR	CX,CX
	MOV	CL,AL			; transfer length byte to CX

; now transmit packed bytes from source to target (length byte not packed)

	LEA	DI,TARGET[1]		; skip length byte

	PUSH	SI			; save
	PUSH	DI			;  for
	PUSH	CX			;   use later

	XOR	BX,BX			; BH = output byte
	MOV	BL,32			; mask for ORing with output byte

FETCH:	                                ; repeat
	INC	SI
	MOV	AL,ES:[SI]		;   get source byte
	MOV	CH,8			;   source bits; CL = source length

UNROLL:
	ROL	AL,1			;   set carry flag
	JNC	NOCFLAG
	OR	BH,BL			;   set output bit
NOCFLAG:
	SHR	BL,1			;   move mask to next bit
	OR	BL,BL			;   set flags
	JNZ	BLNOTZ

	MOV	[DI],BH			;   output unpacked byte
	XOR	BH,BH
	INC	DI
	MOV	BL,32

BLNOTZ:
	DEC	CH
	JNZ	UNROLL			;   loop until AL bits output
	DEC	CL
	JNZ	FETCH			; until all bytes unpacked

; now translate unpacked bytes via lookup table

	POP	CX			; byte count
	POP	DI			; -> TARGET[1]
	POP	SI			; -> SIXPTR
	MOV	BX,OFFSET DECODE	; -> DECODE
XLATE:
	INC	SI
	MOV	AL,[DI]
	XLAT	DECODE			; decode the unpacked byte
	MOV	ES:[SI],AL
	INC	DI
	LOOP	XLATE

NOTSIX:
	RET

UnSixpack	ENDP


CODE	ENDS
	END
