#include <io.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

// compile with: bcc -ml -v read.cpp

const int SCRMAX = 38400U; // # of bytes pre plane (640 * 480 / 8)

char dac[0x100*3];
char egadac[17];

void SetEGAPal (char *p)
{
  asm {
    les dx, [p]
    mov ax, 1002h
    int 10h
  }
}

void SetPalette (char *p)
{
  asm {
    les dx, [p]
    mov ax, 1012h
    mov bx, 0
    mov cx, 100h
    int 10h
  }
}

void setPlane (int x)
{
  outportb (0x3C4, 2);
  outportb (0x3C5, (1 << x));
}

int display (char *fname)
{
  FILE *fp;
  int j;
  char far *ptr;
  char far *screen = (char far *)MK_FP (0xA000, 0);

  ptr = new char [SCRMAX];
  if (!ptr)
    return -1;

  if ((fp = fopen (fname, "rb")) == NULL)
    return -2;

  j = 3;


  fread (egadac, 17, 1, fp);
  fread (dac, 0x100*3, 1, fp);

  do
  {
    fread (ptr, SCRMAX, 1, fp);
    setPlane (j);
    memcpy (screen, ptr, SCRMAX);
  } while (j--);

  SetEGAPal (egadac);
  SetPalette (dac);

  delete ptr;
  return 0;
}

int main (int argc, char *argv[])
{

  if (argc < 2)
  {
    printf ("\nSpecify Filename\n");
    return 1;
  }

  if (access (argv[1], 0) != 0)
  {
    perror (argv[1]);
    return -1;
  }

  asm {
    mov ah, 0
    mov al, 12h
    int 10h          // enter graphics mode (640x480x16)
  }

  if (display (argv[1]) == 0)   // display the image
    getch ();                   // pause for a key

  asm {
    mov ah, 0
    mov al, 3h
    int 10h         // return to 80x25 text mode
  }

  return 0;
}