         name      showenv
         page      55,132
         title     SHOWENV -- getenv demo
;
; SHOWENV.ASM --- demonstrate use of getenv routine
;
; (C) 1987 ZD, by Ray Duncan
;

stdin   equ     0               ; MS-DOS handles for
stdout  equ     1               ; standard devices
stderr  equ     2

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed
blank   equ     020h            ; ASCII blank
tab     equ     09h             ; ASCII tab 

        extrn   getenv:near     ; returns address of env. string

DGROUP  group   _DATA,STACK

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:DGROUP,ss:STACK

main    proc    far             ; entry point from MS-DOS

        mov     es,es:[2ch]     ; get environment segment

main1:                          ; get env. variable to 
                                ;   search for...       

        mov     ax,DGROUP       ; make our data segment
        mov     ds,ax           ; addressable

        mov     dx,offset msg1  ; display cue to user
        mov     cx,msg1_len     ;   'Enter name: '
        mov     bx,stdout
        mov     ah,40h
        int     21h

        mov     dx,offset inbuf ; input name of environment 
        mov     cx,inbuf_len    ;   variable from user
        mov     bx,stdin
        mov     ah,3fh
        int     21h

        sub     ax,2            ; remove cr-lf characters
        or      ax,ax           ; anything entered?
        jz      main3           ; no, exit

        mov     bx,ax           ; append null to string
        mov     byte ptr [bx+inbuf],0

        mov     dx,offset msg2  ; print message
        mov     cx,msg2_len     ;   'The value is: '
        mov     bx,stdout
        mov     ah,40h
        int     21h

                                
        mov     si,offset inbuf ; address of ASCIIZ string
        call    strupr          ; fold to upper case
        call    getenv          ; search environment    

        or      ax,ax           ; find anything?
        jz      main2           ; no, display error message

        push    es              ; display value of
        pop     ds              ;   environment string
        mov     dx,di
        mov     cx,ax
        mov     bx,stdout
        mov     ah,40h
        int     21h
        jmp     main1           ; go ask for another

main2:                          ; env. variable not found,
        mov     dx,offset msg3  ; display error message
        mov     cx,msg3_len
        mov     bx,stdout
        mov     ah,40h
        int     21h
        jmp     main1           ; go look for another

main3:  mov     ax,4c00h        ; exit to MS-DOS
        int     21h

main    endp


pmsg    proc    near            ; print message on stdout
                                ; DS:DX=message, CX=length
        mov     bx,stdout
        mov     ah,40h
        int     21h
        ret

pmsg    endp

strupr  proc    near            ; convert ASCII string to
                                ;  upper case
                                ; call with DS:SI = string
        push    si              ; save string address

strup1: lodsb                   ; next character
        or      al,al           ; found end (null byte) ? 
        jz      strup2          ; yes, jump
        cmp     al,'a'          ; test if in range 'a'-'z'
        jb      strup1          ; skip it if not >= a
        cmp     al,'z'
        ja      strup1          ; skip it if not <= z
                                ; change char to lower case
        sub     byte ptr [si-1],'a'-'A'
        jmp     strup1          ; get another char

strup2: pop     si              ; restore original string
        ret                     ; address and return
        
strupr  endp

_TEXT   ends


_DATA   segment word public 'DATA'

msg1    db      cr,lf,lf,'Enter name:    '
msg1_len equ $-msg1

msg2    db      cr,lf,   'The value is:  '
msg2_len equ $-msg2

msg3    db      'not found!'
msg3_len equ $-msg3

inbuf   db      64 dup (0)      ; keyboard input buffer
inbuf_len equ $-inbuf

_DATA   ends


STACK   segment para stack 'STACK'

        dw      64 dup (?)

STACK   ends

        end     main
