;A little program to initialize memory to either all 0's or all 1's or F4 (HLT)
;Conceived of and written by Jonathan Goldblatt 
;(CompuServe 72500,306 Internet jag@digex.com) and released into the public domain.
;I used tasm and tlink.  



		JUMPS				;Make all jmps addressable

MemoryControlBlock Struc
MCB_Type       db ?        			;'M' intermediate 'Z' last
MCB_PSP        dw ?                             ;PSP of owning program
MCB_Size       dw ?                             ;Size of memory block in
                                                ;paragraphs excluding this
                                                ;paragraph
MCB_Pad        db 11 dup(?)                     ;Unused before Dos5.0
MemoryControlBlock Ends

MCB_LastBlock equ 'Z'			
MCB_InterBlock equ 'M'

CR		equ	0Dh
LF		equ	0Ah
		code	segment	common
		org	80h
lastseg		dw	?			;Last segment to process
relocated_code:
		ends

	        code    segment	common
	        assume  cs:code,ds:code

	        org     2ch
local_environment       dw      ?               ;Word containing the segment
	                                        ;  of the program's env. block.
	        org     80h
command_length	db	?
command_tail    db      ?                       ;Offset of the command tail.

	        org     100h
main:		jmp	start
help		db	"Usage: setmem [0] [1] [F]",CR,LF
		db	"       a 0 on the command line sets memory to 0",CR,LF
		db	"       a 1 on the command line sets memory to FF",CR,LF
		db	"       a F on the command line sets memory to F4 (HLT)",CR,LF
		db	"       anything else prints this message",CR,LF,CR,LF
		db	"       (This is useful for discovering or working around uninitialized",CR,LF
		db  	"        variables, or jumps into never, never land)",CR,LF,CR,LF
		db  	"       Released into the public domain by author Jonathan A Golblatt",CR,LF
		db  	"       CompuServe: 72500,306 Internet: jag@digex.com.",CR,LF,CR,LF
		db	"       USE AT YOUR OWN RISK.  I use it all the time, BUT WHO KNOWS",CR,LF
		db  	"       WHAT IT WILL DO TO YOU!!! (Version 1.01)",CR,LF
endhelp		db	26			;^Z		
bitpattern	dw	?
zero_mesg	db	"Memory set to all 0",CR,LF,'$'
one_mesg	db	"Memory set to all 1",CR,LF,'$'
F4_mesg		db	"Memory set to all F4",CR,LF,'$'
runcode:
	;bx is current segment to 0 out
	;ax is first segment after multiples of 64K to 0 out.
full64Kloop:					;FFFF out full 64K segments
		cmp	bx,lastseg
		jae	last64K
		mov	cx,8000H		;FFFF out full 64K segments
		rep 	stosw
		mov	bx,es
		add	bx,1000H
		mov	es,bx
		jmp	full64Kloop
last64K:
		sub	bx,lastseg
		sub	bx,1000h		
		neg	bx			;Remaining paragraphs
		mov	cl,3			;Multiply by 8 to get no of words
		shl	bx,cl
		mov	cx,bx
		rep	stosw
exit:		mov	ax,4c00h
		int	21h
start:
		cld				;String instructions increment
; Check for parameters
		
		xor	cx,cx
		mov	cl,[command_length]
		cmp	cl,0
		je	printhelp
		mov	al,'1'
		mov	di,offset command_tail
		repne	scasb
		jne	check_for_0
		mov	[bitpattern],0FFFFh
		mov	dx,offset one_mesg
		jmp	relocate_code
check_for_0:			
		mov	cl,[command_length]	;cx is 0 because 1st test failed
		mov	al,'0'
		mov	di,offset command_tail
		repne	scasb
		jne	check_for_F
		mov	[bitpattern],0
		mov	dx,offset zero_mesg
		jmp	relocate_code
check_for_F:
		mov	cl,[command_length]	;cx is 0 because 1st test failed
		mov	al,'F'
		mov	di,offset command_tail
		repne	scasb
		jne	printhelp
		mov	[bitpattern],0F4F4h
		mov	dx,offset F4_mesg
relocate_code:
; Print appropriate message
		mov	ah,09h
		int	21h
; Relocate code to command string area
		mov	si,offset runcode
		mov	di,offset relocated_code
		mov	cx,40h
		rep	movsw			;Move code to command string
; Determine where to stop
		mov	ax,es
		dec	ax
		mov	es,ax			;Point to progs MCB
		add	ax,[es:MCB_Size]	;Get no of paragraphs in block
		inc	ax			;Make up for dec
		sub	ax,1000h		;Get 64K below
		mov	lastseg,ax		
; Setup to do work
		push	cs
		pop	bx
		add	bx,10h                  
		mov	es,bx                   ;es points right after PSP.
		mov	ax,[bitpattern]
		xor	di,di
		jmp 	relocated_code		;es must = bx
printhelp:	mov	dx,offset help
		mov	[endhelp],'$'
		mov	ah,09h
		int	21h
		jmp	exit
		ends
		end	main
