;
; Structures for SCSI commands
;
io_cmd		struc
io_cmd_op	db	?		;Opcode
		if extended_io
io_cmd_lun	db	?
io_cmd_lba_b3	db	?		;Logical Block Address
io_cmd_lba_b2	db	?
io_cmd_lba_b1	db	?
io_cmd_lba_b0	db	?
io_cmd_dummy1	db	?
io_cmd_cnt_b1	db	?		;Block Count
io_cmd_cnt_b0	db	?
io_cmd_dummy2	db	?
		else
io_cmd_lba_b2	db	?		;Logical Block Address / Lun
io_cmd_lba_b1	db	?
io_cmd_lba_b0	db	?
io_cmd_cnt_b0	db	?		;Block Count
io_cmd_dummy1	db	?
		endif
io_cmd		ends

tio_cmd		struc
tio_cmd_op	db	?		;Opcode
tio_cmd_lun	db	?		;Lun
tio_cmd_cnt_b2	db	?		;Block Count
tio_cmd_cnt_b1	db	?
tio_cmd_cnt_b0	db	?
tio_cmd_dummy1	db	?
tio_cmd		ends

;
; Format the Unit
;
fmt_cmd		struc
fmt_cmd_op	db	?		;Opcode
fmt_cmd_type	db	?		;Format Type
fmt_cmd_dummy1	db	?
fmt_cmd_il_b1	db	?		;Interleave (MSB)
fmt_cmd_il_b0	db	?		;Interleave (LSB)
fmt_cmd_dummy3	db	?
fmt_cmd		ends

;
; Verify Sectors
;
ver_cmd		struc
ver_cmd_op	db	?		;Opcode
ver_cmd_lun	db	?		;Lun
ver_cmd_lba_b3	db	?		;Logical Block Address MSB
ver_cmd_lba_b2	db	?
ver_cmd_lba_b1	db	?
ver_cmd_lba_b0	db	?		;Logical Block Address LSB
ver_cmd_dummy1	db	?
ver_cmd_len_b1	db	?		;Length MSB
ver_cmd_len_b0	db	?		;Length LSB
ver_cmd_dummy2	db	?
ver_cmd		ends

;
; Load / Unload a Tape
;
load_cmd	struc
load_cmd_op	db	?		;Opcode
load_cmd_lun	db	?		;Lun
load_cmd_dummy1	db	2 dup (?)
load_cmd_type	db	?		;Load / Unload
load_cmd_dummy2	db	?
load_cmd	ends

;
; Write Filemarks on a Tape
;
fm_cmd		struc
fm_cmd_op	db	?		;Opcode
fm_cmd_lun	db	?		;Lun
fm_cmd_cnt_b2	db	?		;Filemark MSB
fm_cmd_cnt_b1	db	?
fm_cmd_cnt_b0	db	?		;Filemark LSB
fm_cmd_dummy	db	?
fm_cmd		ends

;
; Space a Tape
;
space_cmd	struc
space_cmd_op	db	?		;Opcode
space_cmd_code	db	?
space_cmd_cnt2	db	?		;Count
space_cmd_cnt1	db	?
space_cmd_cnt0	db	?
space_cmd_dummy	db	?
space_cmd	ends

;
; Reassign a Block
;
remap_cmd	struc
remap_cmd_op	db	?		;Opcode
remap_cmd_lun	db	?		;Lun
remap_cmd_dum1	db	?		;Reserved
remap_cmd_dum2	db	?
remap_cmd_dum3	db	?
remap_cmd_dum4	db	?
remap_cmd	ends

;
; Structure(s) returned by the sense command(s)
;
sense		struc
sense_sense	db	?		;Sense (Error) code
sense_lba_b2	db	?		;Failed Block Address
sense_lba_b1	db	?
sense_lba_b0	db	?
sense		ends

e_sense		struc
e_sense_ccs	db	?		;0x70 for Extended Sense
e_sense_dummy1	db	?
e_sense_sense	db	?		;Sense (Error) Group
e_sense_lba_b3	db	?		;Failed Block Address
e_sense_lba_b2	db	?
e_sense_lba_b1	db	?
e_sense_lba_b0	db	?
e_sense		ends

;
; Structure returned by the unit inquiry command
;
inq		struc
inq_dev_type	db	?		;Device Type
inq_dev_qual	db	?		;Device Qualifier
		ife mini_inquire
inq_stand_rev	db	?		;Standard Revision Level
inq_format	db	?		;Response Format
inq_length	db	?		;Length of Extra Data
inq_reserv1	db	?
inq_reserv2	db	?
inq_reserv3	db	?
inq_manufact	db	8 dup (?)	;Manufacture
inq_product	db	16 dup (?)	;Product
		endif
inq		ends

;
; Structure returned by the read drive capacity command
;
cap		struc
cap_sectors_b3	db	?		;MSB of sector count
cap_sectors_b2	db	?
cap_sectors_b1	db	?
cap_sectors_b0	db	?		;LSB of sector count
cap_size_b3	db	?		;MSB of sector size
cap_size_b2	db	?
cap_size_b1	db	?
cap_size_b0	db	?		;LSB of sector size
cap		ends

;
; Structure Definitions For Our Device Driver
;
bpb		struc
bpb_ss		dw	?		;Sector Size
bpb_au		db	?		;Cluster Size in Sectors
bpb_rs		dw	?		;Reserved Sectors
bpb_nf		db	?		;Number of Fats
bpb_de		dw	?		;Number of Root Directory Entries
bpb_ts		dw	?		;Total Number Of Sectors
bpb_md		db	?		;Media Descriptor
bpb_fs		dw	?		;Number of Sectors in each Fat
bpb_st		dw	?		;Number of Sectors per Track
bpb_nh		dw	?		;Number of Heads
bpb_hs_lsw	dw	?		;Hidden Sectors (Least Sig Word)
bpb_hs_msw	dw	?		;Hidden Sectors (Most Sig Word)
bpb_ts_lsw	dw	?		;Large Total Sector Count
bpb_ts_msw	dw	?
bpb_res		db	6 dup (?)	;Reserved
bpb		ends

;
; ioctl function 42h/62h
;
ioctl_fmt	struc
ioctl_fmt_spec	db	?		;Special Flags
ioctl_fmt_head	dw	?		;Head to Format
ioctl_fmt_cyl	dw	?		;Cylinder to Format
ioctl_fmt_len	dw	?		;How Many Tracks
ioctl_fmt	ends

;
; ioctl function 61h
;
ioctl_read	struc
ioctl_read_spec	db	?		;Special Flags
ioctl_read_head	dw	?		;Head to Read
ioctl_read_cyl	dw	?		;Cylinder to Read
ioctl_read_sect	dw	?		;Sector to Read
ioctl_read_len	dw	?		;How Many Sectors
ioctl_read_ofs	dw	?		;Buffer Offset
ioctl_read_seg	dw	?		;Buffer Segment
ioctl_read	ends

;
; ioctl function 60h/61h return
;
dpb		struc
dpb_special	db	?		;Special Flags
dpb_type	db	?		;Device Type
dpb_attr	dw	?		;Device Attributes
dpb_cyl		dw	?		;Device Cylinder Count
dpb_media	db	?		;Device Media Type if Diskette
dpb_bpb		db	size bpb dup (?)
dpb_sectors	dw	?		;Sectors in Track
dpb_track	dd	SECT_TRACK dup (?)
dpb		ends

;
; The internal control structure for a SCSI device
;
unit		struc
unit_1st_drv	db	?		;DOS Drive Numbers
unit_num_drv	db	?		;DOS Drive Count
unit_select	db	?		;SCSI Select Bit
unit_mcheck	db	?		;Media Check Byte
unit_inq_buf	db	size inq dup (?)
unit_inq_term	db	?
unit_cap_buf	db	size cap dup (?)
unit_sense	db	size sense dup (?)
unit_e_sense	db	size e_sense dup (?)
unit		ends

;
; Ioctl Commands
;
ioc		struc
ioc_command	dw	?		;Command
ioc_param1	dw	?		;Command Dependent Data
ioc_param2	dw	?		;Command Dependent Data
ioc_buf_seg	dw	?		;Buffer Segment
ioc_buf_ofs	dw	?		;Buffer Offset
ioc_buf_len	dw	?		;Buffer Length
ioc		ends

;
; DOS requests
;
rh		struc
rh_len		db	?		;Length of Packet
rh_unit		db	?		;Unit Code (Block Only)
rh_cmd		db	?		;Command Code
rh_status	dw	?		;Returned Status
rh_res		db	8 dup (?)	;Reserved
rh		ends

rh0		struc			;INITIALIZATION
rh0_rh		db	size rh dup (?)	;Fixed Portion
rh0_nunits	db	?		;Number of units (Block Only)
rh0_brk_ofs	dw	?		;Break Address (Offset)
rh0_brk_seg	dw	?		;Break Address (Segment)
rh0_bpb_tbo	dw	?		;Pointer to BPB Array (Offset)
rh0_bpb_tbs	dw	?		;Pointer to BPB Array (Segment)
rh0_drv_ltr	db	?		;First Available Drive (DOS 3+, Block Only)
rh0		ends

rh1		struc			;MEDIA CHECK
rh1_rh		db	size rh dup (?)	;Fixed Portion
rh1_media	db	?		;Media Descriptor from DPB
rh1_md_stat	db	?		;Media Status returned by Device Driver
rh1_volid_ofs	dw	?		;Offset of Volume ID String (DOS 3+)
rh1_volid_seg	dw	?		;Segment of Volume ID String (DOS 3+)
rh1		ends

rh2		struc			;GET BPB
rh2_rh		db	size rh dup (?)	;Fixed Portion
rh2_media	db	?		;Media Descriptor from DPB
rh2_buf_ofs	dw	?		;Offset of Data Transfer Area
rh2_buf_seg	dw	?		;Segment of Data Transfer Area
rh2_pbpbo	dw	?		;Offset of Pointer to BPB
rh2_pbpbs	dw	?		;Segment of Pointer to BPB
rh2		ends

rh4		struc			;INPUT
rh4_rh		db	size rh dup (?)	;Fixed Portion
rh4_media	db	?		;Media Descriptor from DPB
rh4_buf_ofs	dw	?		;Offset of Data Transfer Area
rh4_buf_seg	dw	?		;Segment of Data Transfer Area
rh4_count	dw	?		;Transfer Count (Sectors)
rh4_sector	dw	?		;Start Sector Number
		dd	?
rh4_lsect_lsw	dw	?		;Start Sector LSW (32 bit)
rh4_lsect_msw	dw	?		;Start Sector MSW (32 bit)
rh4		ends

rh8		struc			;OUTPUT
rh8_rh		db	size rh dup (?)	;Fixed Portion
rh8_media	db	?		;Media Descriptor from DPB
rh8_buf_ofs	dw	?		;Offset of Data Transfer Area
rh8_buf_seg	dw	?		;Segment of Data Transfer Area
rh8_count	dw	?		;Transfer Count (Sectors)
rh8_sector	dw	?		;Start Sector Number
		dd	?
rh8_lsect_lsw	dw	?		;Start Sector LSW (32 bit)
rh8_lsect_msw	dw	?		;Start Sector MSW (32 bit)
rh8		ends

rh12		struc			;OUTPUT IOCTL
rh12_rh		db	size rh dup (?)	;Fixed Portion
rh12_media	db	?		;Media Descriptor from DPB
rh12_buf_ofs	dw	?		;Offset of Data Transfer Area
rh12_buf_seg	dw	?		;Segment of Data Transfer Area
rh12_count	dw	?		;Transfer Count (Sectors)
rh12_sector	dw	?		;Start Sector Number
rh12		ends

rh19		struc			;IOCTL
rh19_rh		db	size rh dup (?)	;Fixed Portion
rh19_major	db	?		;Major Code
rh19_minor	db	?		;Minor Code
rh19_si		dw	?		;Caller SI Register
rh19_di		dw	?		;Caller DI Register
rh19_buf_ofs	dw	?		;Caller Buffer Offset
rh19_buf_seg	dw	?		;Caller Buffer Segment
rh19		ends
