/*
** SCSI Disk Block Reassign
**
** usage: sremap drive:
**
** Revision History:
**
** Version 1.0  10/17/90 Initial Release
*/
#include <stdio.h>
#include <dos.h>
#include "ioctl.h"

#define TRUE (1)
#define FALSE (0)
#define VERSION "sremap Version 1.0 BWA"

extern int _doserrno;

struct cmd ioctl_data;
struct remaps remap_list;
union REGS inregs, outregs;
struct SREGS segregs;
unsigned char drive;
char far *cp;

main(argc, argv)
int argc;
char *argv[];
{
	long block;
	short remap_count = 0;
	char answer[BUFSIZ];

	/*
	** say hello
	*/
	puts(VERSION);
	if (argc != 2) usage();

	/*
	** figure out who to format
	*/
	if (argv[1][1] != ':') usage();
	drive = argv[1][0];
	drive = toupper(drive);
	drive -= '@';

	/*
	** ask for remap list
	*/
	puts("Input your remap list, <enter> to terminate.");
	while (remap_count < MAX_DEFECTS)
	{
		printf("Logical Block Address: ");
		fflush(stdout);
		fgets(answer, BUFSIZ, stdin);
		if ( answer[0] == '\n' ) break;
		sscanf(answer, "%lx", &block);
		remap_list.list[remap_count].remap_lba3 = (block >> 24) & 0x00FF;
		remap_list.list[remap_count].remap_lba2 = (block >> 16) & 0x00FF;
		remap_list.list[remap_count].remap_lba1 = (block >> 8) & 0x00FF;
		remap_list.list[remap_count].remap_lba0 = block & 0x00FF;
		remap_count++;
	}

	/*
	** adjust to length of list in bytes
	*/
	remap_count *= sizeof(struct remap_entry);

	/*
	** verify that this is what the user really wants to do
	*/
	printf("Do you really wish to remap blocks on the SCSI\n");
	printf("device that contains drive %c: (y,n)? ", argv[1][0]);
	fflush(stdout);
	if ( getchar() != 'y' )
	{
		puts("Aborting reassign ....");
		exit(1);
	}

	/*
	** build the remap list header
	*/
	remap_list.header.reserved = 0;
	remap_list.header.reserved2 = 0;
	remap_list.header.rll_msb = (remap_count >> 8) & 0x00FF;
	remap_list.header.rll_lsb = remap_count & 0x00FF;

	/*
	** put together the command
	*/
	inregs.h.ah = 0x44;			/* ioctl */
	inregs.h.al = 0x05;			/* write */
	inregs.h.bl = drive;		/* unit */
	inregs.x.cx = sizeof(struct cmd);
	cp = (char *) &ioctl_data;
	inregs.x.dx = FP_OFF(cp);
	segregs.ds = FP_SEG(cp);
	ioctl_data.command = I_REASSIGN;
	cp = (char *) &remap_list;
	ioctl_data.buf_ofs = FP_OFF(cp);
	ioctl_data.buf_seg = FP_SEG(cp);
	ioctl_data.buf_len = sizeof(struct remap_header) + remap_count;

	/*
	** start the remap
	*/
	puts("Now reassigning ....");
	puts("Please wait ....");
	intdosx(&inregs, &outregs, &segregs);

	/*
	** see what happened
	*/
	if ( outregs.x.cflag )
		printf("DOS error %d occured during reassign.\n", _doserrno);
	else
		puts("Reassigning complete.");
	exit(0);
}

usage()
{
	puts("usage: sremap drive:");
	exit(1);
}
