#ifndef RTGRAF_h
#define RTGRAF_h

   void far setmode (int mode);
   void far clearscreen (int color);
   void far hardware_check(void);

   void far pix_set     (int x, int y, int color);
   int  far pix_read    (int x, int y);

   void far egamplot
                 (int x, int y,
                 unsigned char far *picture,
                 unsigned char far *mask,
                 int rule);
   void far egaplot
                 (int x, int y,
                  unsigned char far *picture,
                  int rule);
   void far eread
                 (int x, int y,
                  int width, int height,
                  unsigned char far *picture);
   int  far  etext
                 (int x, int y,
                  char far *string,
                  int color,
                  char far *font);
   void far  solid_box
                 (int x0,int y0,
                  int x1,int y1,
                  int color);
   void far draw_line
                 (int x0, int y0,
                  int x1, int y1,
                  int color );
   void far bilblt
                 (int Xsrc, int Ysrc,
                  int Xdst, int Ydst,
                  int width, int depth,
                  int function);

   /*=================================================================
       Extrenals from RTGRAF
   ===================================================================*/

   extern int far   pixels_wide   ;   // screen width in pixels
   extern int far   scan_deep     ;   // scan lines on the screen
   extern int far   curr_vid_mode ;   // video mode after setmode (if it worked)
   extern int far   curr_vid_mon  ;   // monitor type
                                      // 0 = ???
                                      // 3 = Enhanced Color Display (EGA)
                                      // 4 = CGA
                                      // 5 = Monochrome
                                      // 7 = Monochrome VGA
                                      // 8 = Color VGA or MultiSync
   extern int far   curr_vid_card ;   // video card
                                      // 0 = CGA
                                      // 1 = EGA
                                      // 2 = VGA
   extern int far   prior_vid_mode;   // old mode prior to set_mode
   extern int far   max_scan_deep ;   // max scan lines in video memory
   extern int far   bytes_per_line;   // max scan lines in video memory

//###########################################################################
//
// Definitions for font files

#ifndef FONTSTRUCT_h
#define FONTSTRUCT_h

#define BYTESWIDE      0
#define SCANHIGH       1
#define BASELINE       2
#define PIXWIDE        3
#define FIRSTCHAR      4
#define LASTCHAR       5
#endif


//int  load_font (char * font_name, char * far *pointer);
//int  multi_string (int x, int y, char *str, unsigned char *font, int color);
//int  prompt (int x, int y, char * text, char * font , int fgc, int bgc, char * accept);
//void box ( int x1, int y1, int x2, int y2, int color, int lines);

#endif
