.386
.model small,pascal

quad	struc
q0	dd	?
q1	dd	?
quad	ends

.code

;-----------------------------------------------------------------------------
;void pascal quadinc(quad* z, quad x)
;compute z=z+x

public	QUADINC
QUADINC	proc	z:ptr, x:qword

	mov	eax,(x).q0
	mov	edx,(x).q1
	mov	ebx,z
	add	[ebx].q0,eax
	adc	[ebx].q1,edx
	ret

QUADINC	endp

;-----------------------------------------------------------------------------
;void pascal quadinca(quad* z, quad* x)
;compute z=z+x

public	QUADINCA
QUADINCA	proc	z:ptr, x:ptr

	mov	ebx,x
	mov	eax,[ebx].q0
	mov	edx,[ebx].q1
	mov	ebx,z
	add	[ebx].q0,eax
	adc	[ebx].q1,edx
	ret

QUADINCA	endp

;-----------------------------------------------------------------------------
;void pascal quaddec(quad* z, quad x)
;compute z=z-x

public	QUADDEC
QUADDEC	proc	z:ptr, x:qword

	mov	eax,(x).q0
	mov	edx,(x).q1
	mov	ebx,z
	sub	[ebx].q0,eax
	sbb	[ebx].q1,edx
	ret

QUADDEC	endp

;-----------------------------------------------------------------------------
;void pascal quaddeca(quad* z, quad* x)
;compute z=z-x

public	QUADDECA
QUADDECA	proc	z:ptr, x:ptr

	mov	ebx,x
	mov	eax,[ebx].q0
	mov	edx,[ebx].q1
	mov	ebx,z
	sub	[ebx].q0,eax
	sbb	[ebx].q1,edx
	ret

QUADDECA	endp

;-----------------------------------------------------------------------------
;void pascal quadadd(quad* z, quad x, quad y)
;compute z=x+y

public	QUADADD
QUADADD	proc	z:ptr, x:qword, y:qword

	mov	eax,(x).q0
	mov	edx,(x).q1
	add	eax,(y).q0
	adc	edx,(y).q1
	mov	ebx,z
	mov	[ebx].q0,eax
	mov	[ebx].q1,edx
	ret

QUADADD	endp

;-----------------------------------------------------------------------------
;void pascal quadadda(quad* z, quad* x, quad* y)
;compute z=x+y

public	QUADADDA
QUADADDA	proc	z:ptr, x:ptr, y:ptr

	mov	ebx,x
	mov	eax,[ebx].q0
	mov	edx,[ebx].q1
	mov	ebx,y
	add	eax,[ebx].q0
	adc	edx,[ebx].q1
	mov	ebx,z
	mov	[ebx].q0,eax
	mov	[ebx].q1,edx
	ret

QUADADDA	endp

;-----------------------------------------------------------------------------
;void pascal quadsub(quad* z, quad x, quad y)
;compute z=x-y

public	QUADSUB
QUADSUB	proc	z:ptr, x:qword, y:qword

	mov	eax,(x).q0
	mov	edx,(x).q1
	sub	eax,(y).q0
	sbb	edx,(y).q1
	mov	ebx,z
	mov	[ebx].q0,eax
	mov	[ebx].q1,edx
	ret

QUADSUB	endp

;-----------------------------------------------------------------------------
;void pascal quadsuba(quad* z, quad* x, quad* y)
;compute z=x-y

public	QUADSUBA
QUADSUBA	proc	z:ptr, x:ptr, y:ptr

	mov	ebx,x
	mov	eax,[ebx].q0
	mov	edx,[ebx].q1
	mov	ebx,y
	sub	eax,[ebx].q0
	sbb	edx,[ebx].q1
	mov	ebx,z
	mov	[ebx].q0,eax
	mov	[ebx].q1,edx
	ret

QUADSUBA	endp

;-----------------------------------------------------------------------------
;void pascal quadmult(quad* z, quad x, quad y)
;compute z=x*y

public	QUADMULT
QUADMULT	proc	z:ptr, x:qword, y:qword

	mov	eax,(x).q0
	mov	ebx,eax
	mul	(y).q1
	xchg	eax,ebx
	mov	ecx,(y).q0
	mul	ecx
	add	ebx,edx
	xchg	eax,ecx
	mul	(x).q1
	add	eax,ebx
	mov	ebx,z
	mov	[ebx].q0,ecx
	mov	[ebx].q1,eax
	ret

QUADMULT	endp

;-----------------------------------------------------------------------------
;void pascal quadmulta(quad* z, quad* x, quad* y)
;compute z=x*y

public	QUADMULTA
QUADMULTA	proc	uses esi, z:ptr, x:ptr, y:ptr

	mov	ebx,x
	mov	esi,[ebx].q0
	mov	ecx,[ebx].q1
	mov	ebx,y
	mov	eax,[ebx].q1
	mov	ebx,[ebx].q0
	mul	esi
	xchg	eax,ecx
	mul	ebx
	add	ecx,eax
	mov	eax,ebx
	mul	esi
	add	edx,ecx
	mov	ebx,z
	mov	[ebx].q0,eax
	mov	[ebx].q1,edx
	ret

QUADMULTA	endp

;-----------------------------------------------------------------------------
;void pascal quaddiv(quad* z, quad x, quad y)
;compute z=x/y

public	QUADDIV
QUADDIV	proc	uses esi edi, z:ptr, x:qword, y:qword

	xor	edi,edi		;sign

	mov	eax,(x).q0
	mov	edx,(x).q1
	or	edx,edx
	jns	quaddiv1

	inc	edi
	neg	eax
	adc	edx,0
	neg	edx
	mov	(x).q1,edx
	mov	(x).q0,eax
quaddiv1:
	mov	ebx,(y).q0
	mov	esi,(y).q1
	or	esi,esi
	jns	quaddiv2

	inc	edi
	neg	ebx
	adc	esi,0
	neg	esi
quaddiv2:
	jnz	quaddiv3	;y >= 2^16?

;---------------------------------------
;y < 2^16:

	or	ebx,ebx
	jz	quaddiv9	;divide by zero?

	mov	ecx,eax
	mov	eax,edx
	xor	edx,edx
	div	ebx
	xchg	eax,ecx
	div	ebx
	jmp	quaddiv6

;---------------------------------------
;y >= 2^16:

quaddiv3:
	bsr	ecx,esi		;shift right x and y so that y<2^16
	inc	cl
	push	ebx
	shrd	ebx,esi,cl
	shrd	eax,edx,cl
	shr	edx,cl

	div	ebx		;estimate z

	mov	ebx,eax		;multiply z with y
	mul	esi
	mov	ecx,eax
	pop	eax
	mul	ebx
	add	edx,ecx

	jc	quaddiv4	;compare z*y with x
	cmp	edx,(x).q1
	ja	quaddiv4
	jb	quaddiv5
	cmp	eax,(x).q0
	jbe	quaddiv5
quaddiv4:
	dec	ebx		;decrement z if z*y > x
quaddiv5:
	xor	ecx,ecx
	mov	eax,ebx

;---------------------------------------
quaddiv6:
	dec	edi
	jnz	quaddiv7

	neg	eax		;change sign of result
	adc	ecx,0
	neg	ecx

quaddiv7:
	mov	ebx,z
	mov	[ebx].q0,eax
	mov	[ebx].q1,ecx
	ret

quaddiv9:			;divide error
	xor	eax,eax
	dec	eax
	mov	ecx,7fffffffh
	jmp	quaddiv6	;return 7fffffffffffffffh

QUADDIV	endp

;-----------------------------------------------------------------------------
;void pascal quaddiva(quad* z, quad* x, quad* y)
;compute z=x*y

public	QUADDIVA
QUADDIVA	proc	z:ptr, x:ptr, y:ptr

	push	z
	mov	ebx,x
	push	[ebx].q1
	push	[ebx].q0
	mov	ebx,y
	push	[ebx].q1
	push	[ebx].q0
	call	QUADDIV

	ret

QUADDIVA	endp

;-----------------------------------------------------------------------------
end
