         name      modenv
         page      55,132
         title     MODENV --- demo of PUTENV function
;
; MODENV.ASM --- demonstrate use of PUTENV routine
; (C) 1987 Ziff Davis, by Ray Duncan
;

stdin   equ     0               ; MS-DOS handles for
stdout  equ     1               ; standard devices
stderr  equ     2

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed

stksize equ     128             ; size of stack segment

        extrn   putenv:near     ; changes environment string

DGROUP  group   _DATA,STACK

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:DGROUP,ss:STACK

main    proc    far             ; entry point from MS-DOS

        mov     ax,DGROUP       ; make our data segment 
        mov     ds,ax           ; addressable

                                ; now give back extra memory...
        mov     ax,es           ; let AX = segment of PSP base
        mov     bx,ss           ; and BX = segment of stack base
        sub     bx,ax           ; reserve seg stack - seg psp 
        add     bx,stksize/16   ; plus paragraphs of stack
        inc     bx              ; round up for safety
        mov     ah,4ah          ; fxn 4ah = modify memory block
        int     21h             ; transfer to MS-DOS
        jc      main9           ; exit if resize failed

        mov     pspseg,es       ; save segment of PSP   

        mov     dx,offset msg1  ; display message
        mov     cx,msg1_len     ; 'Before call to PUTENV'
        call    pmsg

        mov     es,es:[002ch]   ; get environment pointer
        call    dumpenv         ; dump environment strings

                                ; change PROMPT= in environment
        mov     es,pspseg       ; ES = PSP segment
        mov     si,offset prompt; DS:SI = new value for PROMPT
        call    putenv  

        mov     dx,offset msg2  ; display message
        mov     cx,msg2_len     ; 'After call to PUTENV'
        call    pmsg

        mov     es,pspseg       ; let ES = segment of environment
        mov     es,es:[002ch]
        call    dumpenv         ; dump environment strings

main9:  mov     ax,4c00h        ; final exit to MS-DOS
        int     21h

main    endp


dumpenv proc    near            ; dump contents of environment
                                ;  block to standard output
                                ; call with ES = env. base

        xor     di,di           ; initialize env. offset

dump1:                          ; reached end of env. block?
        cmp     byte ptr es:[di],0
        je      dump2           ; yes, exit

        mov     dx,offset msg3  ; no, move to new line
        mov     cx,msg3_len     ;  by sending carriage 
        call    pmsg            ;  return/line feed

        mov     dx,di           ; save address of next 
        mov     cx,-1           ;  environment variable
        xor     al,al           ;  and find its length
        repne scasb             ; scan for terminating null
        not     cx
        dec     cx              ; now CX = length
        push    ds              ; save our data segment
        mov     ax,es           ; let DS:DX = address
        mov     ds,ax           ;  of environment variable
        call    pmsg            ;  and display it
        pop     ds              ; restore our data segment
        jmp     dump1           ; get next env. variable

dump2:  ret                     ; back to caller

dumpenv endp


pmsg    proc    near            ; print message on stdout
                                ; DS:DX=message, CX=length
        mov     bx,stdout
        mov     ah,40h
        int     21h
        ret

pmsg    endp

_TEXT   ends


_DATA   segment word public 'DATA'

pspseg  dw      ?               ; segment of program segment prefix

msg1    db      cr,lf,'Before call to PUTENV:'
msg1_len equ $-msg1

msg2    db      cr,lf,lf,'After call to PUTENV:'
msg2_len equ $-msg2

msg3    db      cr,lf           ; carriage return/line feed
msg3_len equ $-msg3

prompt  db      'PROMPT=This is a test!$_$p$g',0

_DATA   ends


STACK   segment para stack 'STACK'

        db      stksize dup (?)

STACK   ends

        end     main
