DISTANCE        EQU     6
PUBLIC _put2dosenv
;******************************** ALFA Project by CASH (c) Products *******
;*       Function: _PUT2DOSENV       Created: 1990/5/14 at 16:44 Updated:   
;*     Parameters: char far *new_string (VARIABLE_NAME=VARIABLE_VALUE)
;*        Returns: 00h if success, else error code 1 or 2
;*          Calls: -
;*    Description: Append the specified string to COMMAND.COM's environment
;*                 variables.
;*                 Does not check if a variable of the same name
;*                 already exists.
;*                 Should work with PC-DOS 3.3
;**************************************************************************
_put2dosenv     proc    far
        push    bp
        mov     bp,sp
        push    bx
        push    cx
        push    es
        push    si
        push    di
        push    ds

        mov     ah,62h
        int     21h
        mov     es,bx                  ; current psp 
prev_psp:
        mov     ax,word ptr es:[16h]   ; psp of parent program
        cmp     bx,ax                  ; is it same as current ?
        je      com_psp_found          ; if so, it is the shell
        mov     es,ax                  ; (normally COMMAND.COM)
        mov     bx,ax
        jmp     prev_psp               ; if not, go on
com_psp_found:
        mov     ax,word ptr es:[2ch]   ; get segment of environment
        push    ax                     ; save environment segment
        dec     ax                     ; get segment of environment's
        mov     es,ax                  ; Memory Control Block (MCB)

        mov     ax,word ptr es:[03h]   ; get length of environment block
        mov     cl,4
        shl     ax,cl                  ; convert para's to bytes

        mov     cx,ax
        pop     ax                     ; get environment segment again

        push    cx                     ; save length of environment

        mov     es,ax                  ; environment segment of command.com
        
        mov     al,00h
        mov     di,00h                 ; scan all strings in environment
        cld
search_on:
        repne   scasb
        je      env_end_found          ; 
        mov     ax,01h                 ; exit with error code 1
        pop     cx                     ; restore stack
        jmp     err_exit
env_end_found:
        cmp     byte ptr es:[di],00h   ; if a double 00h, we are at the end
                                       ; of all environment strings
        jne     search_on              ; else scan on

        pop     cx                     ; restore length of environment
        sub     cx,di                  ; calculate remaining length
        dec     cx                     

        push    cx                     ; save length of remaining space
        push    es                     ; save offset where to put
        push    di                     ; new variable

        mov     di,ss:[bp+DISTANCE]     offset of variable
        mov     ax,ss:[bp+DISTANCE+2]   segment of variable
        mov     es,ax
        push    es
        push    di                     ; save pointer to string
        xor     al,al
        mov     cx,0ffffh
        repne   scasb
        inc     cx                     ; get length of string
        not     cx                     ; into cx 

        pop     si
        pop     ds                     ; get pointer to string

        pop     di
        pop     es                     ; get pointer into environment

        pop     ax                     ; get remaining length 
        cmp     ax,cx                  ; if not long enough
        mov     ax,2                   ; return error code 2
        jle     err_exit

        rep     movsb                  ; move string into
                                       ; environment
        xor     ax,ax
        stosw                          ; add end of strings marker
err_exit:
        pop     ds
        pop     di
        pop     si
        pop     es
        pop     cx
        pop     bx
        pop     bp
        ret
_put2dosenv     endp
