;  CRLF filter for text files.  Insures that ALL carriage returns (CR=0Dh)
;  are followed by line feeds (LF=OAh) and that ALL LF's are preceded by
;  CR's.  This is the ASCII standard format, and is required by the PMS editor.
;  Use it on text files that have odd looking characters and behave strangely
;    when edited.

;  Modified UNWS by J. Naleszkiewicz, by J. Rebold & H. Flank

;  Usage:  CRLF <source.fil >dest.fil

Code	Segment
	Assume	CS:Code,DS:Code,ES:code,SS:code

CR	Equ	0Dh
LF	Equ	0Ah
Bfrsiz	Equ	16384		; length of the input buffer
	Org	100h

Start:	Jmp	Begin

Banner:	Db	cr,lf,'CRLF.COM  V1.6',cr,lf
	Db	'By H. Flank after J. Rebold after John R. Naleszkiewicz  '
	Db	'Apr 87 - Sep 93',cr,lf,cr,lf
	Db	'Insures that each line ends with ASCII standard CR,LF'
	Db	cr,lf,cr,lf,'Usage:    CRLF <infile >outfile',cr,lf,'$',1Ah

Begin:	Mov	SI,80h		; point to no. of bytes in command line
	LodsB
	Or	AL,AL
	JNZ	Main1
;there is no command line
	Mov	DX,Offset Banner
	Mov	AH,9
	Int	21h
	Mov	AX,4C01h	;exit w/Errorlevel 1
	Int	21h

;
Main1:	Cld			; Go forwards
	Xor	AL,AL		; Clear previous byte for 1st Pop
	Push	AX		; Save dummy prev byte in AL
RdText:	Xor	BX,BX		; handle = std input
	Mov	CX,Bfrsiz	; get buffer size (chars to read)
	Lea	DX,Input	; input buffer address
	Mov	AH,3Fh		; read from device
	Int	21h
	Or	AX,AX		; test for EOF (AX=bytes read or 0 for EOF)
	JZ	Exit		; if no bytes were read

;------	Process the Text in the Input Buffer ------
	Mov	SI,Offset Input	; input buffer address (source)
	Mov	DI,Offset Output; output buffer address (destination)
	Mov	CX,AX		; set counter to chars input
	Pop	AX		; restore prev byte (1st pass, 0 was pushed)
Next:	Mov	AH,AL		; save the previous byte
	LodsB			; get this byte
	Cmp	AL,LF
	JNE	ChekCR
;this char is a LF -  was the previous byte a CR?
	Cmp	AH,CR
	JE	Store		; Yes: things are OK
	Mov	AH,CR		; No: Put a CR in the output buffer first
	Mov	[DI],AH
	Inc	DI
	Jmp	Store
;this char is NOT a LF -  was the previous byte a CR?
ChekCR:	Cmp	AH,CR
	JNE	Store		; No: that's good since this byte is not a LF
;previous was a CR and this is not a LF
	Mov	AH,LF		; insert a LF before this char
	Mov	[DI],AH
	Inc	DI
Store:	StosB
	Loop	Next		; process next byte from input buffer

	Push	AX		; Save prev byte reg
;------	write the Output Buffer ------
Wrtext:	Mov	BX,1		; std output file handle
	Mov	DX,Offset Output; output buffer address
	sub	DI,DX		; Calc the output buffer length
	Mov	CX,DI		; output buffer length
	Mov	AH,40h		; write to device
	Int	21h
	jmp	RdText		; Go read next block

;------	return to DOS ------
Exit:	Pop	AX
	Mov	AX,4C00h	; exit w/errorlevel = 0
	Int	21h

Input	Equ	$		; input buffer starts here
Output	Equ	$+Bfrsiz	; output buffer starts here

Code	Ends
	End 	Start
