/*
    BCDOP.CPP

    1993 by Jens Reckendorf, Vectron Systems GmbH,
            48163 Mnster, Germany

    BCD number library - implementation, headers in opbcd.hpp

    Link with OPBCD.ASM in the version modified for C++.

    Should work with all memory models exept huge (requires many
    changes in the ASM-part) and with every optimization (SI and DI
    are saved because they can be used as register vars but the
    ASM-routines designed for Pascal do not save them. This is a
    bit of a dirty solution; maybe there are problems in some
    special situations or new versions of the compiler).

    Further details in OPBCD.HPP and OPBCD.ASM.
*/

#include "bcdop.hpp"

#pragma inline

typedef char tPasStr[256];  // Pascal string type

// Prototypes for routines in OPBCD.ASM

extern "C" pascal far AddBcd (tBcd far&, tBcd far&, tBcd far&);
extern "C" pascal far SubBcd (tBcd far&, tBcd far&, tBcd far&);
extern "C" pascal far MultBcd (tBcd far&, tBcd far&, tBcd far&);
extern "C" pascal far DivBcd (tBcd far&, tBcd far&, tBcd far&);

extern "C" pascal far unsigned char EqualBcd (tBcd far&, tBcd far&);
extern "C" pascal far unsigned char NotEqualBcd (tBcd far&, tBcd far&);
extern "C" pascal far unsigned char GreaterBcd (tBcd far&, tBcd far&);
extern "C" pascal far unsigned char GreaterEqualBcd (tBcd far&, tBcd far&);
extern "C" pascal far unsigned char LessBcd (tBcd far&, tBcd far&);
extern "C" pascal far unsigned char LessEqualBcd (tBcd far&, tBcd far&);

extern "C" pascal far LongintToBcd (long, tBcd far&);
extern "C" pascal far AbsBcd (tBcd far&, tBcd far&);
extern "C" pascal far IntBcd (tBcd far&, tBcd far&);
extern "C" pascal far FracBcd (tBcd far&, tBcd far&);
extern "C" pascal far long RoundBcd (tBcd far&);
extern "C" pascal far long TruncBcd (tBcd far&);

extern "C" pascal far StrBcd (tPasStr far*, tBcd far&, unsigned char, unsigned char);
extern "C" pascal far ValBcd (tPasStr far*, tBcd far&, int far&);

// Implementation of friend functions and methods for tBcd

const cMaxWidth = 60;   // max. BCD string length

tBcd operator+ (tBcd& a, tBcd& b)
  {
    tBcd c;
    asm { push si
          push di };
    AddBcd (a, b, c);
    asm { pop di
          pop si };
    return c;
  };

tBcd operator- (tBcd& a, tBcd& b)
  {
    tBcd c;
    asm { push si
          push di };
    SubBcd (a, b, c);
    asm { pop di
          pop si };
    return c;
  };

tBcd operator* (tBcd& a, tBcd& b)
  {
    tBcd c;
    asm { push si
          push di };
    MultBcd (a, b, c);
    asm { pop di
          pop si };
    return c;
  };

tBcd operator/ (tBcd& a, tBcd& b)
  {
    tBcd c;
    asm { push si
          push di };
    DivBcd (a, b, c);
    asm { pop di
          pop si };
    return c;
  };

int operator== (tBcd& a, tBcd& b)
  {
    int i;
    asm { push si
          push di };
    i = EqualBcd (a, b);
    asm { pop di
          pop si };
    return i;
  };

int operator!= (tBcd& a, tBcd& b)
  {
    int i;
    asm { push si
          push di };
    i = NotEqualBcd (a, b);
    asm { pop di
          pop si };
    return i;
  };

int operator>= (tBcd& a, tBcd& b)
  {
    int i;
    asm { push si
          push di };
    i = GreaterEqualBcd (a, b);
    asm { pop di
          pop si };
    return i;
  };

int operator<= (tBcd& a, tBcd& b)
  {
    int i;
    asm { push si
          push di };
    i = LessEqualBcd (a, b);
    asm { pop di
          pop si };
    return i;
  };

int operator> (tBcd& a, tBcd& b)
  {
    int i;
    asm { push si
          push di };
    i = GreaterBcd (a, b);
    asm { pop di
          pop si };
    return i;
  };


int operator< (tBcd& a, tBcd& b)
  {
    int i;
    asm { push si
          push di };
    i = LessBcd (a, b);
    asm { pop di
          pop si };
    return i;
  };

tBcd tBcd::operator- ()
  {
    number [0] ^= 0x80;
    return *this;
  };

tBcd::tBcd (long x)
  {
    asm { push si
          push di };
    LongintToBcd (x, *this);
    asm { pop di
          pop si };
  };

tBcd BcdAbs (tBcd& a)
  {
    tBcd b;
    asm { push si
          push di };
    AbsBcd (a, b);
    asm { pop di
          pop si };
    return b;
  };

tBcd BcdInt (tBcd& a)
  {
    tBcd b;
    asm { push si
          push di };
    IntBcd (a, b);
    asm { pop di
          pop si };
    return b;
  };

tBcd BcdFrac (tBcd& a)
  {
    tBcd b;
    asm { push si
          push di };
    FracBcd (a, b);
    asm { pop di
          pop si };
    return b;
  };

long BcdRound (tBcd& a)
  {
    long l;
    asm { push si
          push di };
    l = RoundBcd (a);
    asm { pop di
          pop si };
    return l;
  };

long BcdTrunc (tBcd& a)
  {
    long l;
    asm { push si
          push di };
    l = TruncBcd (a);
    asm { pop di
          pop si };
    return l;
  };

void BcdStr (char* St, tBcd& a, unsigned char Width, unsigned char Places)
  {
    tPasStr TempStr;
    asm { push si
          push di };
    StrBcd (&TempStr, a, Width, Places);
    asm { pop cx   // remove &TempStr from the stack. StrBcd does not
          pop cx   // because in Pascal the string is a function result
          pop di
          pop si };
    for (int i = 1; i <= TempStr [0]; i++)
      *St++ = TempStr [i];
    *St = 0;
  };

int BcdVal (char* St, tBcd& a)
  {
    tPasStr TempStr;
    int Code;
    unsigned char Len = 0;
    while (*St && (Len < 0xFF))
      {
        TempStr [++Len] = *St;
        ++St;
      };
    TempStr [0] = Len;
    asm { push si
          push di };
    ValBcd (&TempStr, a, Code);
    asm { pop di
          pop si };
    return Code;
  };

#ifdef __tBcdStreamIO__
  ostream& operator<< (ostream& os, tBcd& a)
    {
      char* Str = new char[os.width () > cMaxWidth ? cMaxWidth : os.width ()];
      BcdStr (Str, a, os.width (), os.precision ());
      os << Str;
      delete Str;
      return os;
    };

  istream& operator>> (istream& is, tBcd& a)
    {
      char* Str = new char[cMaxWidth];
      cin >> Str;
      BcdVal (Str, a);
      delete Str;
      return is;
    };
#endif