	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	video.mac
ENDIF


	EXTRN	Self:WORD

	.CODE

COMMENT	%
==============================================================================
Gets and saves the current screen attributes.

=============================================================================%
getVideoState	PROC	NEAR
	readChar	al,ah			;Get al=char, ah=attr
	setInst		OldAttr,ah,Self		;Save attribute
	getVideoMode	bh,al			;Get bh=page, al=mode
	setInst		OldMode,al		;Save video mode
	call		getVideoSegment		;Get video segment addr
	ret
getVideoState	ENDP



COMMENT	%
==============================================================================
Gets and saves the correct video segment to use depending on wether a color
card is installed or not.

=============================================================================%
getVideoSegment	PROC	NEAR
	mov		bx,0040h		;Get port addr
	mov		es,bx			;Point to port seg
	mov		bx,es:10h		;Get equipment list
	and		bx,30h			;Only want bits 5-4
	mov		ax,ColorAddr
	mov		es,ax			;Make es point to color mem
	neq		bx,30h,gvs1		;Exit if color card present
	mov		ax,MonoAddr
	mov		es,ax			;Make es point to mono mem
gvs1:	ret
getVideoSegment	ENDP



COMMENT	%
==============================================================================
Restores the original screen attributes.

=============================================================================%
resetVideoState	PROC	NEAR
	getInst		bl,OldMode,Video	;Get original video mode
	setVideoMode	0,bl			;Display page 0, mode
	ret
resetVideoState	ENDP



	.DATA

defMsg	Video,\
	Init,\
	<getVideoState,,>

defMsg	Video,\
	Reset,\
	<resetVideoState,,>

defObj	Video,\
	<>,\
	<OldAttr,1,07h,\
	OldMode,1,2>,\
	<Init,Reset>



	END

