	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	UR	EQU	9			;Upper row
	LC	EQU	10			;Left column
	LR	EQU	15			;Lower row
	RC	EQU	60			;Right column
	MR	EQU	LR-(RowOffset+1)	;Mouse row
	MC	EQU	LC+ColOffset+1		;Mouse column

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	clrNextContext:NEAR
	EXTRN	hideMouseCursor:NEAR
	EXTRN	prtString:NEAR
	EXTRN	sendMsg:NEAR

	EXTRN	Dialog:WORD
	EXTRN	Dir:WORD
	EXTRN	DlgMenu:WORD
	EXTRN	DosError:WORD
	EXTRN	Exec:WORD
	EXTRN	File:WORD
	EXTRN	Hardware:WORD
	EXTRN	Help:WORD
	EXTRN	Master:WORD
	EXTRN	MenuBar:WORD
	EXTRN	Self:WORD
	EXTRN	Screen:WORD
	EXTRN	Video:WORD


	.CODE

COMMENT	%
==============================================================================
Resets the video display.

=============================================================================%
resetVideo	PROC	NEAR
	send		Video,Reset		;Reset video 
	ret
resetVideo	ENDP



IF Dbug
	PUBLIC suspendPgm
ENDIF
COMMENT	%
==============================================================================
Displays the exit text message when before suspending program execution.

=============================================================================%
suspendPgm	PROC	NEAR
	lea		si,ExitMsg		;Get addr of msg text
	xor		dx,dx			;Cursor position
	mov		bl,07h			;Text color
	call		prtString		;Display the string
	send		Exec,Execute		;Load and execute DOS shell
	setInst		?ReadDir,Nil,Dir,2	;Must re-read directory
	ret
suspendPgm	ENDP



COMMENT	%
==============================================================================
Refreshes the video display, and enters the top-level executive driver.

=============================================================================%
initSys	PROC	NEAR
	send		Video,Init		;Initialize video 
	send		File,Init		;Save program's path info
	send		DosError,Init		;Verify error handler exists
	send		Screen,Init		;Initialize objects' color 
	send		Screen,Refresh		;Refresh screen
	send		Help,Refresh		;Refresh help menu
	send		Hardware,Init		;Initialize hardware cursor
	send		MenuBar,Refresh		;Refresh menubar
	send		MenuBar,Init		;Start executive loop
	ret
initSys	ENDP



COMMENT	%
==============================================================================
Returns control to the operating system.

=============================================================================%
returnToOS	PROC	NEAR
	exit					;Return to DOS
returnToOS	ENDP



	.DATA

SystemText	DB	"Session termination options:",0
ExitMsg		DB	"Type EXIT to return.",0

defMenu		System,<" Quit Program "," Suspend Program "," Cancel ">

defMenuTbl	System,\
	<System,Reset>,\
	<System,Suspend>,\
	<System,Clear>

defSlaveTbl	System,<DlgMenu>

defDispTbl	System,\
	<0,0,3,0,0,0,0,System,Reset>,\
	<0,75,3,0,0,0,0,DlgMenu,Prev>,\
	<0,77,3,0,0,0,0,DlgMenu,Next>,\
	<13,28,3,0,0,0,0,System,Select>,\
	<0,Nil,1,MR,MC,MR+2,MC+44,System,Click>,\
	<27,1,3,0,0,0,0,System,Clear>,\
	<Nil,Nil,Nil,0,0,24,79,Hardware,Refresh>

defMsg	System,\
	Clear,\
	<,,clrNextContext>

defMsg	System,\
	Reset,\
	<resetVideo,hideMouseCursor,returnToOS>

defMsg	System,\
	Init,\
	<,,initSys>

defMsg	System,\
	Suspend,\
	<resetVideo,suspendPgm,initSys>

defObj	System,\
	<Dialog,Master>,\
	<Row1,1,UR,\
	Col1,1,LC,\
	Row2,1,LR,\
	Col2,1,RC,\
	Color,1,13h,\
	Unused,1,Nil,\
	TxtPtr,2,SystemText,\
	InxPtr,2,0,\
	MasterObj,2,Nil,\
	DispTbl,2,SystemDispTbl,\
	MenuPtr,2,SystemMenu,\
	MenuTbl,2,SystemMenuTbl,\
	SlaveTbl,2,SystemSlaveTbl>,\
	<Refresh,Read,Select,Clear,Reset,Init,Suspend,Click>




	END

