	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	UR	EQU	5			;Upper row
	LC	EQU	15			;Left column
	LR	EQU	17			;Lower row
	RC	EQU	56			;Right column

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	cursor.mac
ENDIF

	EXTRN	convertDigits:NEAR
	EXTRN	findFirst:NEAR
	EXTRN	getFileName:NEAR
	EXTRN	longToString:NEAR
	EXTRN	prtString:NEAR
	EXTRN	prtString_:NEAR
	EXTRN	sendMsg:NEAR

	EXTRN	Buffer:WORD
	EXTRN	DBorder:WORD
	EXTRN	Dispatch:WORD
	EXTRN	DosError:WORD
	EXTRN	FileAttr:WORD
	EXTRN	FileDate:WORD
	EXTRN	FileName:WORD
	EXTRN	FileSize:WORD
	EXTRN	FileTime:WORD
	EXTRN	Hardware:WORD
	EXTRN	PopUp:WORD
	EXTRN	Self:WORD
	EXTRN	System:WORD


	.CODE

IF Dbug
	PUBLIC	findFile
ENDIF
COMMENT	%
==============================================================================
Gets file information from DOS.

=============================================================================%
findFile	PROC	NEAR
	lea		dx,FileName		;Get ptr to file name
	call		findFirst		;Find file
	jc		ff1			;Jump if error

	send		Self,Read		;Display file info
	jmp		ff2			;Exit

ff1:	push		ax			;Save error code
	send		Self,Clear		;Clear window
	pop		ax			;Restore error code
	push		Self			;Save yourself
	send		DosError,Error,ax	;Handle error
	pop		Self			;Restore yourself

ff2:	ret
findFile	ENDP



IF Dbug
	PUBLIC	disFileInfo
ENDIF
COMMENT	%
==============================================================================
Displays file information in FileInfo window.

=============================================================================%
disFileInfo	PROC	NEAR
	push		es
	push		ds			;Make ds and es the same
	pop		es
	getInst		dh,Row1,Self		;Get window coords
	getInst		dl,Col1
	add		dh,RowOffset
	add		dl,ColOffset

	getInst		bl,Color		;Get window color
	getInst		si,TxtPtr		;Get field text tbl ptr

	call		disFields		;Display fields
	call		disFileName		;Display file name
	call		disFileAttr		;Display file attribute
	call		disFileDate		;Display file creation date
	call		disFileTime		;Display file creation time
	call		disFileSize		;Display file size
	pop		es
	ret
disFileInfo	ENDP



COMMENT	%
==============================================================================
Displays fields for FileInfo window.

Passed:	bl - Color
	cx - Lower/Right row/column
	dx - Upper/Left row/column
	si - Pointer to field text tbl

=============================================================================%
disFields	PROC	NEAR
	push		dx
	mov		cx,NumOfFields
dflds1:	call		prtString		;Display string
	add		dh,NumOfRows
	add		si,FieldSize
	loop		dflds1
	pop		dx
	add		dl,FieldSize+2		;Set new left column
	ret
disFields	ENDP



COMMENT	%
==============================================================================
Displays file name in FileInfo window.

Passed:	bl - Color
	dx - Upper/Left row/column

=============================================================================%
disFileName	PROC	NEAR
	lea		si,FileName		;Pass ptr to file name
	call		prtString		;Display string
	add		dh,NumOfRows		;Set new row
	ret
disFileName	ENDP



COMMENT	%
==============================================================================
Displays file attribute in FileInfo window.

Passed:	bl - Color
	dx - Upper/Left row/column

=============================================================================%
disFileAttr	PROC	NEAR
	push		dx
	setCur		dh,dl
	lea		di,Buffer
	lea		si,FileAttr
	mov		dl,Bptr[si]
	mov		al,dl
	or		al,100000b
	neq		al,100000b,dfa1
	lea		si,Attr1
	call		disFileAttr_
dfa1:	mov		al,dl
	or		al,010000b
	neq		al,010000b,dfa2
	lea		si,Attr2
	call		disFileAttr_
dfa2:	mov		al,dl
	or		al,001000b
	neq		al,001000b,dfa3
	lea		si,Attr3
	call		disFileAttr_
dfa3:	mov		al,dl
	or		al,000010b
	neq		al,000010b,dfa4
	lea		si,Attr4
	call		disFileAttr_
dfa4:	or		dl,000001b
	neq		dl,000001b,dfa5
	lea		si,Attr6
	call		disFileAttr_
dfa5:	lea		si,Buffer		;Pass buffer addr
	call		prtString_		;Display string
	pop		dx
	add		dh,NumOfRows		;Set new row
	ret
disFileAttr	ENDP



COMMENT	%
==============================================================================
Moves a text string to the text buffer for display.

Passed:	di - Next available location in Buffer
	si - Address of text string

Passes:	di - Next available location in Buffer

=============================================================================%
disFileAttr_	PROC	NEAR
	lea		ax,Buffer
	eq		ax,di,dfa_1
	mov		ax,Wptr[CommaSpace]	;Get delimiters
	mov		Wptr[di-1],ax		;Save them in buffer
	inc		di			;Poin to next location
dfa_1:	lodsb
	mov		Bptr[di],al
	inc		di
	notZero		al,dfa_1
	dec		di
	ret
disFileAttr_	ENDP



COMMENT	%
==============================================================================
Displays file creation date in FileInfo window.

Passed:	bl - Color
	dx - Upper/Left row/column

=============================================================================%
disFileDate	PROC	NEAR
	push		dx
	setCur		dh,dl
	lea		di,Buffer
	lea		si,FileDate
	mov		dx,Wptr[si]
	mov		ax,dx
	and		ax,01Fh
	mov		cl,5
	shr		dx,cl
	mov		cx,dx
	and		cx,01Fh
	push		dx
	push		ax
	call		disMonth
	pop		ax
	call		disDay
	pop		dx
	mov		cl,4
	shr		dx,cl
	and		dx,03Fh
	call		disYear
	lea		si,Buffer		;Pass buffer addr
	call		prtString_		;Display string
	pop		dx
	add		dh,NumOfRows		;Set new row
	ret
disFileDate	ENDP



COMMENT	%
==============================================================================
Displays file creation month in FileInfo window.

Passed:	cl - Month of year
	di - Next available Buffer addr

Passes:	di - Next available Buffer addr

=============================================================================%
disMonth	PROC	NEAR
	lea		di,Buffer
	lea		si,MonthTbl
	mov		ax,2
	dec		cl
	mul		cl
	add		si,ax
	mov		si,Wptr[si]
dmth1:	lodsb
	mov		Bptr[di],al
	inc		di
	notZero		al,dmth1
	dec		di
	ret
disMonth	ENDP



COMMENT	%
==============================================================================
Displays file creation day in FileInfo window.

Passed:	al - Day of month in BCD
	di - Next available Buffer addr

Passes:	di - Next available Buffer addr

=============================================================================%
disDay	PROC	NEAR
	call		convertDigits		;Convert BCD to ASCII
	eq		al,30h,dd1		;Don't display leading zero
	mov		Bptr[di],al		;Move hi-order into buffer
	inc		di
dd1:	mov		Bptr[di],ah		;Move lo-order into buffer
	inc		di
	mov		ax,Wptr[CommaSpace]	;Get delimiters
	mov		Wptr[di],ax		;Move into buffer
	add		di,2			;Return next available addr
	ret
disDay	ENDP



COMMENT	%
==============================================================================
Displays file creation year in FileInfo window.

Passed:	dx - Year
	di - Next available Buffer addr

=============================================================================%
disYear	PROC	NEAR
	push		bx
	mov		ax,1980			;Get current year
	add		ax,dx
	cwd
	call		longToString		;Convert to ASCII
	pop		bx
	ret
disYear	ENDP



COMMENT	%
==============================================================================
Displays file creation time in FileInfo window.

Passed:	bl - Color
	dx - Upper/Left row/column

=============================================================================%
disFileTime	PROC	NEAR
	push		dx
	setCur		dh,dl
	lea		di,Buffer
	lea		si,FileTime
	mov		ch,0			;Clear pm flag
	mov		ax,Wptr[si]
	mov		cl,11d
	shr		ax,cl
	mov		cl,10d
	div		cl
	zero		al,dft1			;Don't display leading zero
	moreThan	al,1,dft2		;If > 1 must be pm
	lessThan	ah,2,dft3		;If 2nd digit < 2 must be am
dft2:	sub		al,1			;Don't use military time
	sub		ah,2
	mov		ch,1			;Set pm flag
	zero		al,dft1			;Don't display leading zero
dft3:	add		al,30h
	mov		Bptr[di],al
	inc		di
dft1:	add		ah,30h
	mov		Bptr[di],ah
	inc		di
	mov		Bptr[di],":"		;Move colon into buffer
	inc		di
	mov		ax,Wptr[si]
	and		ax,11111100000b		;Mask off hours and seconds
	mov		cl,5d
	shr		ax,cl
	mov		cl,10d
	div		cl
	add		al,30h
	mov		Bptr[di],al
	inc		di
	add		ah,30h
	mov		Bptr[di],ah
	inc		di
	zero		ch,dft4			;Jump if am
	mov		ax,"mp"			;Afternoon (pm)
	jmp		dft5
dft4:	mov		ax,"ma"			;Morning (am)
dft5:	mov		Wptr[di],ax		;Save am/pm
	mov		Bptr[di+2],0		;Mark end of string
	lea		si,Buffer		;Pass buffer addr
	call		prtString_		;Display numeric string
	pop		dx
	add		dh,NumOfRows		;Set new row
	ret
disFileTime	ENDP



IF Dbug
	PUBLIC	disFileSize
ENDIF
COMMENT	%
==============================================================================
Displays file size in FileInfo window.

Passed:	bl - Color
	dx - Upper/Left row/column

=============================================================================%
disFileSize	PROC	NEAR
	setCur		dh,dl			;Position cursor

	lea		di,Buffer		;Pass buffer addr
	lea		si,FileSize		;Get ptr to file size
	mov		ax,Wptr[si]		;Pass long integer
	mov		dx,Wptr[si+2]		;In dx:ax

	push		bx
	call		longToString		;Convert to ASCII
	pop		bx

	lea		si,Buffer		;Pass buffer addr
	call		prtString_		;Display numeric string
	lea		si,Bytes		;Pass ptr to description
	call		prtString_		;Display numeric string
	ret
disFileSize	ENDP



	.DATA


FieldTxtTbl	LABEL	WORD
		DB	"File Name: ",0
		DB	"Attributes:",0
		DB	"File Date: ",0
		DB	"File Time: ",0
		DB	"File Size: ",0

FieldSize	EQU	12			;Number of bytes per field
NumOfFields	EQU	05			;Number of fields
NumOfRows	EQU	02			;Number of rows between fields

Attr1		DB	"Archive",0		;File attribute descriptions
Attr2		DB	"Subdirectory",0
Attr3		DB	"Volume Label",0
Attr4		DB	"System",0
Attr5		DB	"Hidden",0
Attr6		DB	"Read Only",0

January		DB	"January ",0
February	DB	"February ",0
March		DB	"March ",0
April		DB	"April ",0
May		DB	"May ",0
June		DB	"June ",0
July		DB	"July ",0
August		DB	"August ",0
September	DB	"September ",0
October		DB	"October ",0
November	DB	"November ",0
December	DB	"December ",0

MonthTbl	LABEL	WORD
		DW	OFFSET January
		DW	OFFSET February
		DW	OFFSET March
		DW	OFFSET April
		DW	OFFSET May
		DW	OFFSET June
		DW	OFFSET July
		DW	OFFSET August
		DW	OFFSET September
		DW	OFFSET October
		DW	OFFSET November
		DW	OFFSET December


MonthSize	EQU	11			;Length of month text strings
CommaSpace	DB	", "
Bytes		DB	" Bytes",0

defDispTbl	FileInfo,\
	<0,0,3,0,0,0,0,System,Reset>,\
	<0,68,3,0,0,0,0,FileInfo,Clear,System,Refresh,System,Read>,\
	<Nil,Nil,1,UR,LC,LR,RC,FileInfo,Clear>,\
	<0,Nil,Nil,0,0,24,79,Hardware,Refresh>


defMsg	FileInfo,\
	Refresh,\
	<getFileName,,findFile>

defMsg	FileInfo,\
	Read,\
	<disFileInfo,,>

defObj	FileInfo,\
	<Dispatch,PopUp,DBorder>,\
	<Row1,1,UR,\
	Col1,1,LC,\
	Row2,1,LR,\
	Col2,1,RC,\
	Color,1,17h,\
	Unused,1,Nil,\
	TxtPtr,2,FieldTxtTbl,\
	InxPtr,2,Nil,\
	MasterObj,2,Nil,\
	DispTbl,2,FileInfoDispTbl>,\
	<Refresh,Read,Clear>




	END
