	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	video.mac
ENDIF

	EXTRN	hideMouseCursor:NEAR

	EXTRN	Self:WORD
	EXTRN	Shadow:WORD
	EXTRN	Window:WORD

	.CODE

COMMENT	%
==============================================================================
Calculates window coordinate data for saving/restoring a window.

Passes:	cx - Column counter
	dx - Row counter
	si - Video segment offset
	di - Screen buffer addr

=============================================================================%
getWinCoords	PROC	NEAR
	getInst		al,?Shadow,Shadow	;Get shadow flag
	getInst		bh,Row1,Self		;Get upper row
	getInst		bl,Col1			;Get left column
	getInst		dh,Row2			;Get lower row
	getInst		dl,Col2			;Get right column
	null		al,gwc1			;No shadow? - Skip
	inc		dh			;Else - incr win size
	inc		dl
gwc1:	lea		di,ImageBuf		;Get addr of image buffer

	mov		ax,dx
	sub		ah,bh
	inc		ah			;Number of rows

	sub		al,bl
	inc		al			;Number of columns
	mov		cx,ax			;Save rows/columns

	mov		al,160d
	mul		bh
	mov		si,ax
	mov		al,2
	mul		bl
	add		si,ax			;Offset into video seg

	xor		dx,dx
	mov		dl,cl			;Save column counter
	mov		cl,ch			
	xor		ch,ch			;Row counter
	ret
getWinCoords	ENDP



COMMENT	%
==============================================================================
Saves a window area for later restoration.

Passed:	cx - Column counter
	dx - Row counter
	si - Video segment offset
	di - Screen buffer addr

=============================================================================%
saveWin	PROC	NEAR
	call		getWinCoords
	pushData	<ds,es,ds,es>
	popData		<ds,es>

swn1:	pushData	<cx,si>
	mov		cx,dx
	rep		movsw
	popData		<si,cx>
	add		si,160			;Next row
	loop		swn1
	popData		<es,ds>
	ret
saveWin	ENDP



COMMENT	%
==============================================================================
Restores a window area previously saved.

Passed:	cx - Column counter
	dx - Row counter
	si - Video segment offset
	di - Screen buffer addr

=============================================================================%
restoreWin	PROC	NEAR
	call		getWinCoords
	xchg		si,di
rwn1:	pushData	<cx,di>
	mov		cx,dx
	rep		movsw
	popData		<di,cx>
	add		di,160			;Next row
	loop		rwn1
	ret
restoreWin	ENDP



	.DATA

ImageBuf	DB	2000 DUP (Nil)		;Screen image buffer

defMsg	PopUp,\
	Refresh,\
	<saveWin,,>

defMsg	PopUp,\
	Clear,\
	<hideMouseCursor,,restoreWin>

defObj	PopUp,\
	<Window>,\
	<>,\
	<Refresh,Clear>



	END

