	.MODEL	SMALL

	INCLUDE	equates.inc

	CombinedMthSpace	EQU	400h	;Amount of space to allocate
						;  for combined methods.
						;  Depends on number of
                                                ;  messages.

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	.CODE

	PUBLIC	initObject
COMMENT %
=============================================================================
Initializes an object by flattening its inheritance lattice to create 
combined methods for its messages.

Passed:	si - Addr ptr to object structure

=============================================================================%
initObject	PROC	NEAR
	lea		di,Buffer		;Get buffer addr
	call		findAncestors		;Find/Save all ancestors
	call		evalMsgs		;Evaluate messages
	ret
initObject	ENDP



COMMENT %
=============================================================================
Finds all of an object's ancestors and saves them for use by the message 
evaluator.

Passed:	bx - Addr ptr to message table (end of object table)
	di - Addr ptr to temporary object table
	si - Addr ptr to object structure

=============================================================================%
findAncestors	PROC	NEAR
	pushData	<bx,si>			;Save obj ptr
	mov		bx,Wptr[si].Messages	;Get addr ptr to msg tbl
	mov		si,Wptr[si].Objects	;Get addr of object tbl
	movsw					;Move obj ptr
fas1:	eq		bx,si,fas2		;Exit if end of tbl
	push		si
	mov		si,Wptr[si]		;Get next object
	call		findAncestors		;Find others
	pop		si
	add		si,2
	jmp		fas1			;More in tbl - Loop
fas2:	mov		Wptr[di],Nil		;Mark end of list
	popData		<si,bx>			;Restore obj ptr
	ret
findAncestors	ENDP



COMMENT %
=============================================================================
Creates combined methods for all of an object's messages.

Passed:	si - Addr ptr to object structure

=============================================================================%
evalMsgs	PROC	NEAR
	mov		bx,Wptr[si].Messages	;Get addr of message tbl
	mov		cx,Wptr[si].Instances	;Get addr of instance tbl
ems1:	mov		dl,Bptr[bx]		;Get msg number
	xor		dh,dh
	call		combineMethods		;Combine methods
	add		bx,3			;Point to next tbl entry
	neq		bx,cx,ems1		;More in tbl? - loop
	ret
evalMsgs	ENDP



COMMENT %
=============================================================================
Combines methods for all included objects.

Passed:	dx - Message number
	si - Addr ptr to object structure

=============================================================================%
combineMethods	PROC	NEAR
	push		bx
	mov		?Compiled,Nil		;Clear compiled flag
	mov		bx,Wptr[CompileStart]	;Get start of combined mthd
	mov		Wptr[CompilePtr],bx	;Init location ptr

	mov		di,Nil			;Zero count word
	call		saveMethodAddr		;Save value

	call		saveBefores		;Save Before methods

	mov		bx,Primary		;Select Primary method type
	lea		di,Buffer		;Get addr of tmp object tbl
	mov		di,Wptr[di]		;Get tbl entry
	call		saveMethod		;Save method

	call		saveAfters		;Save After methods

	null		?Compiled,cms1		;Nothing compiled? - Exit
	call		updatePtrs		;Update message, location ptrs
cms1:	pop		bx
	ret
combineMethods	ENDP



COMMENT %
=============================================================================
Updates the message and location pointers.

Passed:	dx - Message number
	si - Addr ptr to object structure

=============================================================================%
updatePtrs	PROC	NEAR
	push		si
	findMsg		si,dl			;Find message
	mov		di,Wptr[CompileStart]	;Get ptr to combined method
	mov		Wptr[si],di		;Change message ptr

	mov		bx,Wptr[CompilePtr]	;Get current compile location
	mov		Wptr[CompileStart],bx	;Reset start of combined mthd 
	pop		si
	ret
updatePtrs	ENDP



COMMENT %
=============================================================================
Save the Before method type for the specified object.

Passed:	dx - Message number

=============================================================================%
saveBefores	PROC	NEAR
	push		si
	mov		bx,Before		;Select Before method type
	lea		si,Buffer		;Get addr of tmp object tbl
	mov		di,Wptr[si]		;Get tbl entry
sbs1:	call		saveMethod		;Save method
	add		si,2			;Point to next tbl entry
	mov		di,Wptr[si]		;Get next tbl entry
	identity	di,sbs1			;More in table? - loop
	pop		si
	ret
saveBefores	ENDP



COMMENT %
=============================================================================
Save the After method type for the specified object.

Passed:	dx - Message number

=============================================================================%
saveAfters	PROC	NEAR
	pushData	<cx,si>
	mov		bx,After		;Select After method type
	lea		si,Buffer		;Get addr of tmp object tbl
	mov		cx,si			;Save addr of object tbl
sas1:	mov		ax,Wptr[si]		;Get tbl entry
	null		ax,sas2			;Null? - End of tbl, exit
	add		si,2			;Point to next tbl entry
	jmp		sas1			;Loop

sas2:	sub		si,2			;Point to previous tbl entry
	mov		di,Wptr[si]		;Get next tbl entry
	call		saveMethod		;Save method
	neq		si,cx,sas2
	popData		<si,cx>
	ret
saveAfters	ENDP



COMMENT %
=============================================================================
Save the specified method for specified object.

Passed:	bx - Method type
	di - Addr ptr to object structure
	dx - Message number

=============================================================================%
saveMethod	PROC	NEAR
	pushData	<bx,di,si>
	findMsg		di,dl,svm3		;Find message
	mov		di,Wptr[si]		;Get method tbl addr ptr
	null		di,svm3			;Exit if no local methods
	mov		di,Wptr[di+bx]		;Get method addr ptr
	null		di,svm3			;Exit if no message

	mov		bx,Wptr[CompileStart]	;Get start of combined mthd
svm1:	eq		bx,Wptr[CompilePtr],svm2
	eq		di,Wptr[bx],svm3	;Exit if duplicate method
	add		bx,2			;Point to next addr
	jmp		svm1			;Check next addr

svm2:	call		saveMethodAddr		;Save method addr
svm3:	popData		<si,di,bx>
	ret
saveMethod	ENDP



COMMENT %
=============================================================================
Save value at current compile location, and increments location pointer.

Passed:	di - Value to store

=============================================================================%
saveMethodAddr	PROC	NEAR
	mov		?Compiled,1		;Set compiled flag
	mov		bx,Wptr[CompilePtr]	;Get ptr to combined mthd end
	mov		Wptr[bx],di		;Save value
	add		bx,2			;Point to next location
	mov		Wptr[CompilePtr],bx	;Reset location ptr 

	mov		bx,Wptr[CompileStart]	;Get ptr mthd count
	mov		di,Wptr[bx]		;Get mthd count
	inc		di			;Increments mthd count
	mov		Wptr[bx],di		;Save value
	ret
saveMethodAddr	ENDP



	PUBLIC	sendMsg
COMMENT %
=============================================================================
Sends the specified object the given message. This causes the execution of 
the combined message for the object.

Passed:	dx - Message number
	si - Combined method ptr

=============================================================================%
sendMsg	PROC	NEAR
	mov		Wptr[Self],si		;Set Self variable
	findMsg		si,dl,smg2		;Search for message
	mov		si,Wptr[si]		;Get method addr
	mov		cx,Wptr[si]		;Get method count
smg1:	add		si,2			;Point to method
	pushData	<cx,si>			;Save loop cnt, addr ptr
	call		Wptr[si]		;Execute method
	popData		<si,cx>			;Restore addr ptr, loop cnt
	loop		smg1			;Loop
smg2:	ret
sendMsg	ENDP



	.DATA

INCLUDE	objects.inc

	PUBLIC	Buffer
	PUBLIC	Self
IF Dbug
	PUBLIC	?Compiled
	PUBLIC	CompilePtr
	PUBLIC	CompileStart
ENDIF
Self		DW	Nil			;Object variable
?Compiled	DW	Nil			;Flag indicating wether
						;  method addresses were
						;  compiled for message.
CompilePtr	DW	Nil			;Points to next location to
						;  compile method address.
CompileStart	DW	$+2			;Points to beginning of
						;  combined method.
		DB	CombinedMthSpace DUP (Nil)
						;Allocate space for combined
                                                ;  method tables.
Buffer		DB	BufSize DUP (Nil)	;Buffer for text input and
						;  temporay ancestor tables
                                                ;  during initialization.

	END
