	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	findFirst:NEAR
	EXTRN	getHomePath:NEAR
	EXTRN	prtString:NEAR
	EXTRN	sendMsg:NEAR

	EXTRN	Exec:WORD
	EXTRN	FileName:WORD
	EXTRN	Mouse:WORD
	EXTRN	ParCmd:WORD
	EXTRN	Self:WORD
	EXTRN	Video:WORD


	.CODE

IF Dbug
	PUBLIC	setDEVars
ENDIF
COMMENT	%
==============================================================================
Gets a pointer to the text string for the specified error message.

Passed:	StackTop - Error code

=============================================================================%
setDEVars	PROC	NEAR
	getStackArgs	ax			;Get error code
	getInst		bl,?Mouse,Mouse		;Get mouse flag
	lea		di,PgmArgs		;Get addr of command line
	mov		Bptr[di+1],al		;Save error code there
	mov		Bptr[di+2],ah
	mov		Bptr[di+3],bl		;Save mouse flag
	ret
setDEVars	ENDP



COMMENT	%
==============================================================================
Gets the current path and child process name.

=============================================================================%
getFilePath	PROC	NEAR
	lea		di,FileName		;Get file name buffer addr
	call		getHomePath		;Get home path
	lea		si,PgmName		;Get addr of program name
gfp1:	lodsb					;Get a byte
	mov		Bptr[di],al		;Move byte into buffer
	inc		di			;Point to next byte
	notZero		al,gfp1			;Loop until zero encountered
	mov		ParCmd,OFFSET PgmArgs	;Set para block command tail
	ret
getFilePath	ENDP



COMMENT	%
==============================================================================
Handles error by passing error code to Exec object who passes it to the 
error handler program.

=============================================================================%
handleError	PROC	NEAR
	send		Self,Execute
	ret
handleError	ENDP



COMMENT	%
==============================================================================
Looks for error handler program in current file path. If not found exits 
program.

=============================================================================%
?FindErrHdlr	PROC	NEAR
	lea		dx,PgmName		;Get addr of program name
	call		findFirst		;Search for file
	jnc		feh1			;Exit if found

	send		Video,Reset		;Reset video display
	lea		si,ExitMsg		;Get addr of msg text
	xor		dx,dx			;Cursor position
	mov		bl,07h			;Text color
	call		prtString		;Display the string
	exit					;Exit program
feh1:	ret
?FindErrHdlr	ENDP



	.DATA

ExitMsg		DB	"ERRDLG.EXE not found in current directory.",0
PgmName		DB	"ERRDLG.EXE",0
PgmArgs		DB	3,"   ",CR

defMsg	DosError,\
	Error,\
	<setDEVars,,handleError>

defMsg	DosError,\
	Init,\
	<,,?FindErrHdlr>

defMsg	DosError,\
	Execute,\
	<,getFilePath,>

defObj	DosError,\
	<Exec>,\
	<>,\
	<Error,Init,Execute>



	END
