Title   TimeHack.ASM - Shows/Sets Computer hh:mm Time
_TEXT   SEGMENT
        ASSUME CS:_TEXT,DS:_TEXT,ES:_TEXT,SS:_TEXT
        ORG     100H
Begin:  Jmp     Start
Program DB  13,"Time Hack Version 1.0 Copyright (c) 1988"
Usage   DB  13,10," for NON-Commercial Use ONLY!"
        DB  13,10," Use and distribution without charge"
        DB  13,10,"  IS authorized and encouraged by:"
Author  DB  13,10,9,"Tom Gilbert's Heart&Mind",26
Msg_St  DB  10                          ; Blank Line
        DB  "At the sound of the BEEP - Your Computer Time will be"
        DB  13,10,9," <== ESC to EXIT or UpDnArrows & ENTER to SET"
Time    DB  13,"  :  ",9,36             ; hh:mm+1, TAB & "$"
CRLF    DB  13,10                       ; New Line
Start:  Mov     AH,9                    ; Display
        Mov     DX,OFFSET Msg_St        ; Complete
        Int     21h                     ; Message
        Mov     AH,2Ch                  ; Get DOS
        Int     21h                     ; Time and
        Mov     BX,CX                   ; Copy into BX
        Cmp     BL,59                   ; If NOT Last Minute
        Jc      NextM                   ; Then Increment it
        Xor     BL,BL                   ; Else Zero Minutes
        Inc     BH                      ; Increment Hours
        Cmp     BH,24                   ; If NOT Next Day
        Jc      ShoTL                   ; Then Show Time
        Xor     BH,BH                   ; Else Zero Time
        Jmp     SHORT ShoTL             ;  for Next Day
NextM:  Inc     BL                      ; Set Next Minute
ShoTL:  Mov     DI,OFFSET Time+1        ; Show Time Loop
        Mov     AL,BH                   ; Make Hours
        Aam                             ; Two Byte
        Add     AX,"00"                 ; ASCII Digit
        Xchg    AH,AL                   ; in Hi/Lo
        StoSW                           ; order and
        Inc     DI                      ; skip ":"
        Mov     AL,BL                   ; Make Minutes
        Aam                             ; Two Byte
        Add     AX,"00"                 ; ASCII Digits
        Xchg    AH,AL                   ; in Hi/Lo
        StoSW                           ; order and
        Mov     AH,9                    ; Display the
        Mov     DX,OFFSET Time          ; Time String
        Int     21h
        Cmp     CX,BX                   ; If at SET Time
        Jz      Beep                    ; Then BEEP Exit
        Mov     AH,2Ch                  ; Else Get Time
        Int     21h
        Call    DoWhat                  ; If Key
        Cmp     AL,27                   ; is ESC
        Jz      Exit                    ; Then EXIT
        Cmp     AL,0Dh                  ; Else If NOT <ENTER>
        Jnz     ShoTL                   ; Then Show Time Loop
        Xor     DX,DX                   ; Else Zero the
        Mov     AH,2Dh                  ; Seconds to SET
        Mov     CX,BX                   ; Displayed Time
        Int     21h
Beep:   Mov     DL,7                    ; Send BEEP
        Mov     AH,2                    ; Character
        Int     21h                     ; to Console
Exit:   Mov     AH,40h                  ; Use Standard
        Mov     BX,1                    ; Console Output
        Mov     CX,2                    ; for EndLine
        Mov     DX,OFFSET CRLF          ; Characters
        Int     21h
        Mov     AX,4C00h                ; No Error Exit to
        Int     21h                     ; Operating System

DoWhat: Mov     AH,1                    ; Check Keyboard
        Int     16h                     ; If a Key Waiting
        Jnz     AKey                    ; Then Process it
        Xor     AL,AL                   ; Else Clear Key
        Jmp     SHORT DoWx              ;  and Exit DoWhat
AKey:   Xor     AH,AH                   ; Get
        Int     16h                     ; Key
        Cmp     AL,27                   ; If Key
        Jz      DoWx                    ; is ESC
        Cmp     AL,13                   ; Or If <ENTER>
        Jz      DoWx                    ; Then Exit DoWhat
        Or      AL,AL                   ; Or If NOT Extended
        Jnz     DoWx                    ; Then Exit DoWhat
        Cmp     AH,72                   ; Else If NOT UpArrow
        Jnz     CkDn                    ; Then Check DwnArrow
        Inc     BL                      ; Else Increase Minutes
        Cmp     BL,60                   ; If NOT 60 Minutes
        JC      DoWx                    ; Then Exit DoWhat
        Xor     BL,BL                   ; Else Zero Minutes
        Inc     BH                      ;  and Increase Hours
        Cmp     BH,24                   ; If NOT 24 hours yet
        Jc      DoWx                    ; Then Exit DoWhat
        Xor     BH,BH                   ; Else Zero Hours
CkDn:   Cmp     AH,80                   ; If NOT DwnArrow
        Jnz     DoWx                    ; Then Exit DoWhat
        Dec     BL                      ; Else Decrease Minutes
        Jnl     CkMin                   ; Unless Below Zero
SM59:   Mov     BL,59                   ; & then Last Minute
        Dec     BH                      ; and Decrease Hours
        Jnl     DoWx                    ; Unless Below Zero
        Mov     BH,23                   ; Then Time is 23:59
CkMin:  Cmp     BL,CL                   ; If Minute <> SET
        Jnz     DoWx                    ; Then Exit DoWhat
        Dec     BL                      ; Else Decrease Minutes
        Jl      SM59                    ;  and Hour If Required
DoWx:   Ret                             ; Return Flags or <ENTER>
_TEXT   EndS
        End Begin
