Title   TimeBits -- Convert CX, DX Time Values to DX Time Bit Map
COMMENT~
        Call With:  CH = Hour   (0 - 23)
                    CL = Minute (0 - 59)
                    DH = Second (0 - 59)
        Returns:    DX = compressed time in directory entry format
                     h = hour   (0 - 23)
                     m = minute (0 - 59)
                     s = two-second increments (0 - 28)

                    <     DH      > <     DL      >
                    h h h h h m m m m m m s s s s s
        ~
        .MODEL  small
        .CODE
            PUBLIC  TimeBits
TimeBits    Proc
            mov     bx,cx               ; Store hour & min. in BX while
            mov     cl,9                ; using CL as shift register
            shr     dx,cl               ; Convert seconds to secs / 2
            mov     cl,3                ; Left justify
            shl     bh,cl               ; hours and store
            mov     dh,bh               ; DX = hhhhhxxxxxxsssss
            mov     cl,5                ; Shift minutes to
            shl     bx,cl               ; mid 6 bits and
            or      dx,bx               ; combine to return DX =
            ret                         ; "hhhhhmmmmmmsssss"
TimeBits    EndP
            END
