Page 60,120
Title       FTD.ASM - File Time and Date stamper
COMMENT ~   Ver 1.0
            (c) 1988 Tom Gilbert's Heart&Mind
            for NON-Commercial use ONLY!
            Use and distribution without charge
             IS authorized and encouraged!
        ~
        DOSSEG
        .MODEL  small
        .STACK  100h
        .DATA
        DB  10
ArgV0   DB  'FTD',23 DUP (0),13,10,10
        DB  'By: Heart&Mind - OCT 88',13,10
InfoM   DB  10,'FTD file spec '
        DB  '[mm/dd/yy[yy] [hh[:mm[:ss]]]]',13
        DB  10,'stamps file(s) matching'
        DB  ' "file spec"',13,10,10
DayOW   DB  'DayOfWeek',13,10
DateS   DB  'mm/dd/yyyy',13,10
TimeS   DB  'hh:mm:ss',13,10,10
        DB  'Optional date/time fields change',13,10
        DB  'the date and/or time.  See FTD.DOC'
CR_LF   DB  13,10,36
NoFFM   DB  10,'No File(s) Found',13,10,36
Press   DB  13,10,'Press any key to continue . . . $'
Stamp   DB  13,10,'Stamping file: $'

LineC   DB  16                          ; Count of Display Lines

WrkFS   DB  'd:\',40 DUP (0),36         ; Drive:\DirPaths\filespec
DTA4D   DB  21 DUP (0)                  ; DataTransferArea Reserved
DTAFI   DB   9 DUP (0)                  ; DTA File Info: Atribs etc
DTAFN   DB  12 DUP (0)                  ; DTA Filename.Ext

DayNT   Label   Byte                    ; Table of Day Names
        DB      'Sunday   '
        DB      'Monday   '
        DB      'Tuesday  '
        DB      'Wednesday'
        DB      'Thursday '
        DB      'Friday   '
        DB      'Saturday '

CD_CX   DW  ?                           ; Current Date Year
CD_DX   DW  ?                           ; Current Month/Day

DateW   DW  ?                           ; Bit-Mapped Date
TimeW   DW  ?                           ; Bit-Mapped Time

WrkDI   DW  ?                           ; File Name Pointer

Count   DW  1                           ; Parameter Last Processed
Pars    DW  ?                           ; Number of Parameters Found

PSP     DW  ?                           ; Segment of ProgramSegmentPrefix

        .CODE
EXTRN   ArgC:Proc,ArgV:Proc
EXTRN   B2Dec:Proc,SI2Val:Proc
EXTRN   DateBits:Proc,TimeBits:Proc
Main    Proc    Far
        mov     ax,@data                ; Make data
        mov     ds,ax                   ; Addressable
        mov     PSP,es                  ; Store Segment of
        mov     bx,80h                  ; Program Segment Prefix
        call    ArgC                    ; Get and store
        mov     Pars,ax                 ; Parameter Count
        xor     ax,ax                   ; Get FTD
        call    ArgV                    ; filespec
        push    ds                      ; Exchange
        push    es                      ; Data and
        pop     ds                      ; Extra Segment
        pop     es                      ; Registers
        or      ax,ax                   ; If DOS Version < 3
        jz      GetCL                   ; then Get Command Line
        mov     si,bx                   ; else copy FTD
        mov     di,OFFSET ArgV0         ; filespec to
        mov     cx,ax                   ; bytes of
        rep     movsb                   ; Message Area
        mov     ds,es:PSP               ; Update SI Segment
GetCL:  mov     si,80h                  ; Point to and
        lodsb                           ; convert Command Line
        cbw                             ; length to a WORD and
        inc     ax                      ; include ending 0Dh=cr
        mov     cx,ax                   ; Copy Command Line
        mov     di,OFFSET DTA4D         ; into Data Area
        rep     movsb
        mov     ax,@data                ; Now, Data can be
        mov     ds,ax                   ; addressed by ES or DS
        mov     ah,19h                  ; Get and store
        int     21h                     ; Current Drive
        add     al,"A"                  ; Letter in
        mov     di,OFFSET WrkFS         ; Drive and
        stosb                           ; Directory
        mov     si,OFFSET WrkFS+3       ; Path of
        xor     dl,dl                   ; Default
        mov     ah,47h                  ; Disk Device
        int     21h
        mov     ax,5C00h                ; Find Null Byte in
        mov     cx,42                   ; Work FileSpec Area
        repnz   scasb                   ; When Null at DI-1
        mov     [di-1],ah               ; Store 5Ch = "\"
        cmp     [di-2],ah               ; If NOT ROOT
        jnz     SetDI                   ; then Set DI
        dec     di                      ; else BackUp
SetDI:  mov     WrkDI,di                ; Store FN Ptr
        mov     ah,2Ah                  ; Get DOS
        int     21h                     ; Date and
        call    SetDOW                  ; Store Day of
        mov     CD_CX,cx                ; Week and
        mov     CD_DX,dx                ; Date Values
        call    MovDatS                 ; Store Date String
        call    DateBits                ; Bit-Map and
        mov     DateW,dx                ; Date Word
        mov     ah,2Ch                  ; Store
        int     21h                     ; Time as a
        call    TimeBits                ; Bit-Mapped
        mov     TimeW,dx                ; Word Value
        mov     ah,2Ch                  ; Store
        int     21h                     ; Time
        mov     bx,OFFSET TimeS         ; ASCII
        mov     al,ch                   ; Hour
        call    B2Dec                   ; Digits
        add     bx,3                    ; plus
        mov     al,cl                   ; Minutes
        call    B2Dec                   ; Digits
        add     bx,3                    ; plus
        mov     al,dh                   ; Seconds
        call    B2Dec                   ; Digits
        mov     ax,Count                ; If File Spec
        cmp     ax,Pars                 ; entry found
        jc      CntIt                   ; then Count It
        call    Message                 ; else Message Exit
        jmp     MExit
CntIt:  inc     Count                   ; Count and
        mov     bx,OFFSET DTA4D         ; get the file
        call    ArgV                    ; spec parameter
        mov     di,bx                   ; Set Scan Pointer
        xor     bp,bp                   ; Zero ":\" Flag
        mov     cx,ax                   ; Get length
        mov     dx,ax                   ; and copy
        mov     ax,"\:"                 ; Scan first
        repne   scasb                   ; for ":"
        xchg    ah,al                   ; then scan
        mov     di,bx                   ; for "\"
        mov     cx,dx                   ; If had drive
        je      SSlash                  ; then scan for path
        or      bp,1                    ; else flag NO drive
SSlash: repne   scasb                   ; If had path
        je      CkFlag                  ; then Check Flag
        or      bp,2                    ; else flag NO path
CkFlag: mov     di,OFFSET WrkFS         ; Set Destination and
        mov     si,bx                   ; Source Indices
        or      bp,bp                   ; If Nothing Needed
        jz      MovIt                   ; then move file spec
        test    bp,1                    ; else if spec has drive
        jz      CkPath                  ; then check Path Flag
        add     di,2                    ; else use default drive
CkPath: test    bp,2                    ; If file spec has path
        jz      MovIt                   ; then add to drive
        mov     di,WrkDI                ; else add to path
MovIt:  mov     cx,dx                   ; Set length to
        rep     movsb                   ; copy file spec
        mov     BYTE PTR [di],0         ; Insure a Null
        std                             ; Work Backward to
        mov     al,"\"                  ; Find Last Path
        mov     cx,dx                   ; Delimiter in
        add     cx,2                    ; Filespec or
        repne   scasb                   ; Old Path
        cld                             ; Restore Direction
        add     di,2                    ; Calculate FileName
        mov     WrkDI,di                ; Starting Position
GetVL:  mov     ax,Count                ; If NO More
        cmp     ax,Pars                 ; Parameters
        jnc     EndVL                   ; then done
        inc     Count                   ; else count
        mov     bx,OFFSET DTA4D         ;  and get
        call    ArgV                    ; next one
        mov     di,bx                   ; Scan the
        mov     cx,ax                   ; length
        push    ax                      ; preserved
        mov     al,"/"                  ; for date
        repne   scasb                   ; delimiter
        pop     ax                      ; If NO "/"
        jcxz    TimeR                   ; then Time Routine
        call    SetDate                 ; else Date Routine
        jmp     SHORT GetVL             ; and loop 'til done
TimeR:  call    SetTime
        jmp     SHORT GetVL

EndVL:  call    Message                 ; Display Message Area
        mov     ah,1Ah                  ; Set
        mov     dx,OFFSET DTA4D         ; DTA
        int     21h                     ; Area
        mov     ah,4Eh                  ; If First
        xor     cx,cx                   ; Normal
        mov     dx,OFFSET WrkFS         ; Matching
        int     21h                     ; File Found
        jnc     FTDSI                   ; then Stamp It
        mov     ah,9                    ; else Display
        mov     dx,OFFSET NoFFM         ; "No File(s)
        int     21h                     ;  Found" and
        jmp     SHORT MExit             ; Error Exit
FNext:  mov     ah,4Fh                  ; If Another
        int     21h                     ; File NOT Found
        jc      ELine                   ; then End Line Exit
FTDSI:  mov     si,OFFSET DTAFN         ; DTA Filename and
        mov     di,WrkDI                ; Name to Open/Display
        xor     ax,ax                   ; First Null
        mov     cx,6                    ; Name area with
        rep     stosw                   ; words and then
        mov     di,WrkDI                ; Reset Destination
FCopy:  lodsb                           ; If Byte
        or      al,al                   ; is Null
        jz      RData                   ; then done
        stosb                           ; else copy
        jmp     SHORT FCopy             ; until done
RData:  mov     dx,OFFSET WrkFS         ; Open File
        mov     ax,3D00h                ; Read Only
        int     21h                     ; If Fails
        jc      FNext                   ; then try Next
        mov     dx,DateW                ; else Set Date
        mov     cx,TimeW                ;  and Time for
        mov     bx,ax                   ; file handle
        mov     ax,5701h
        int     21h                     ; If fails
        jc      FNext                   ; then try Next
        mov     ah,3Eh                  ; else close
        int     21h                     ; the file

        cmp     LineC,25                ; If Lines Left
        jc      Ok2Dis                  ; then Display
        mov     LineC,0                 ; else zero line count
        mov     ah,9                    ; Display "Press any
        mov     dx,OFFSET Press         ; key to continue . . . "
        int     21h
        mov     ah,7                    ; Wait for
        int     21h                     ; any key
Ok2Dis: mov     ah,9                    ; Display
        mov     dx,OFFSET Stamp         ; Stamping
        int     21h                     ; and add
        mov     dx,OFFSET WrkFS         ; filespec
        int     21h
        inc     LineC                   ; Increment Line Count and
        jmp     SHORT FNext             ; Loop Until No More Matches
ELine:  mov     ah,9
        mov     dx,OFFSET CR_LF         ; End the
        int     21h                     ; last line
        xor     al,al                   ; Zero Error Level
MExit:  mov     ah,4Ch                  ; Use Error Level
        int     21h                     ; DOS Exit Function
Main    EndP

SetDate Proc
        mov     bp,ax                   ; Preserve Count
        mov     si,bx                   ; Set Source Index
        call    SI2Val                  ; Get Month
        mov     dh,al                   ; Register
        or      bp,bp                   ; If 0 Left
        jz      SDExit                  ; then exit
        call    SI2Val                  ; else Get
        mov     dl,al                   ; Day Register
        or      bp,bp                   ; If 0 Left
        jz      SDExit                  ; then exit
        call    SI2Val                  ; else Get Year
        cmp     ax,1900                 ; If Century
        jnc     SDY_Ok                  ; then value Ok
        add     ax,1900                 ; else add Century
        cmp     ax,1980                 ; If => 1980
        jnc     SDY_Ok                  ; then value Ok
        add     ax,100                  ; else make Ok
SDY_Ok: mov     cx,ax                   ; Store Year
        mov     ah,2Bh                  ; Set DOS Date
        int     21h                     ; for Validity
        mov     ah,2Ah                  ; Check and to
        int     21h                     ; Get and Set
        call    SetDOW                  ; Day of Week and
        call    MovDatS                 ; Date String
        call    DateBits                ; Bit-Map Date and
        mov     DateW,dx                ; Store Date Word
        mov     cx,CD_CX                ; Restore Current
        mov     dx,CD_DX                ; Date Values
        mov     ah,2Bh                  ; Set Current
        int     21h                     ; DOS Date
SDExit: ret

SetDate EndP

SetTime Proc
        mov     bp,ax                   ; Preserve Count
        mov     si,bx                   ; Set Source and
        mov     bx,OFFSET TimeS         ; Set Destination
        call    SI2Val                  ; Get and Store
        mov     ch,al                   ; Hours Value
        call    B2Dec                   ; Move ASCII
        add     bx,3                    ; Skip ":"
        or      bp,bp                   ; If More Left
        jnz     STMins                  ; then do minutes
        xor     ax,ax                   ; else zero
        xor     cl,cl                   ; remaining
        xor     dx,dx                   ; time values
        call    B2Dec                   ; store zero
        add     bx,3                    ; minutes
        xor     ax,ax                   ; seconds
        call    B2Dec                   ; and Bit-
        jmp     SHORT ST2_MT            ; Map Time
STMins: call    SI2Val                  ; Get and Store
        mov     cl,al                   ; Minutes Value
        call    B2Dec                   ; Move ASCII
        add     bx,3                    ; Skip ":"
        or      bp,bp                   ; If More Left
        jnz     STSecs                  ; then do seconds
        xor     ax,ax                   ; else zero
        xor     dx,dx                   ; seconds value and
        call    B2Dec                   ; ASCII seconds and
        jmp     SHORT ST2_MT            ; Bit-Map Time
STSecs: call    SI2Val                  ; Get and Store
        mov     dx,ax                   ; seconds values
        call    B2Dec                   ; Move ASCII
ST2_MT: call    TimeBits                ; Bit-Map and
        mov     TimeW,dx                ; store Time Word
        ret
SetTime EndP

SetDOW  Proc
        push    cx                      ; Preserve Year
        mov     cx,9                    ; Use as Multiplier
        cbw                             ; for Day Code Word
        mul     cl                      ; to Offset from
        mov     si,OFFSET DayNT         ; Day Name Table
        add     si,ax                   ; Copy Day Name
        mov     di,OFFSET DayOW         ; into Message
        rep     movsb                   ; Area DayName
        pop     cx                      ; Return Date
        ret                             ; Values
SetDOW  EndP

MovDatS Proc
        push    cx                      ; Preserve Year
        mov     bx,OFFSET DateS         ; Set Destination
        mov     al,dh                   ; Move Month
        call    B2Dec                   ; ASCII Digits
        add     bx,3                    ; Move Day of
        mov     al,dl                   ; Month as
        call    B2Dec                   ; ASCII Digits

        add     BX,3                    ; If Year
        mov     al,20                   ; is in the
        cmp     cx,2000                 ; 21st Century
        ja      Cen21                   ; then (01 - 99)
        jb      Cen20                   ; else (80 - 99)
        xor     cx,cx                   ; else year is
        jmp     SHORT YearS             ; equal "2000"
Cen21:  sub     cx,2000                 ; Set (01 - 99)
        jmp     SHORT YearS             ; for "20yy"
Cen20:  sub     cx,1900                 ; Set (01 - 99)
        dec     al                      ; for "19yy"
YearS:  call    B2Dec                   ; Store Century,
        add     bx,2                    ; Tens and Units
        mov     al,cl                   ; Year ASCII Digits
        call    B2Dec
        pop     cx                      ; Restore Year
        ret
MovDatS EndP

Message Proc
        mov     ah,9                    ; Display
        mov     dx,OFFSET ArgV0-1       ; message
        int     21h                     ; area
        ret
Message EndP
        End     Main
