Title   ET.ASM - Measures Elapsed Time

CODE    SEGMENT PUBLIC  'CODE'
        ASSUME  CS:CODE,DS:CODE,ES:Nothing,SS:CODE
        ORG     100H
BEGIN:  JMP     START
ADJUST  DB      24,60,60,100,13         ; Hr, Min, Sec.00 +CR

Program DB  "Elapsed Time "             ; 13 byte Signon
Version     DB  "1.0 "
Copyright   DB  13,10,"(c) 1988"
Author      DB  13,10,"By: Tom Gilbert's Heart&Mind"
Usage       DB  13,10,"for NON-Commercial Use ONLY!",13,10
            DB  "Use and distribution without charge",13,10
            DB  " IS authorized and encouraged.",26

Report  DB  "started NOW",13            ; 12 byte Report
Failed  DB  "ICA in use",7              ; 11 byte Over-Write

ETHM    DB  "ETHM"      ; ElapsedTimeHeart&Mind Signature at
ICA0   EQU   0F0h       ; Beginning of Inter-application
ICA4   EQU   0F4h       ; Communication Area - ET uses 8 bytes

START:  Mov     AX,40h                  ; Point to
        Mov     ES,AX                   ; Lo-Mem
        Mov     DI,ICA0                 ;  I C A
        Cmp     Byte Ptr DS:[80h],0     ; If NO Command
        Jz      CkICA                   ; Then Check ICA
        And     Word Ptr DS:[82h],5F5Fh ; Else If UPPER
        Cmp     Word Ptr DS:[82h],"MH"  ; Case "HM" found
        Jz      FIRST                   ; Then ReStart
CkICA:  Mov     SI,OFFSET ETHM          ; Else If "ETHM"
        Mov     CX,4                    ; Signature
        Rep     CmpSB                   ; Begins ICA
        Je      NEXT                    ; Then Continue
        Mov     CX,4                    ; Else If Four
        Xor     AX,AX                   ; Null Words
        Mov     DI,ICA0                 ; mean ICA
        Rep     ScaSW                   ; NOT in Use
        Je      FIRST                   ; Then Start ET
        Mov     CX,11                   ; Else 11 Byte
        Mov     SI,OFFSET Failed        ; Over-Write
        Push    DS                      ; Data
        Pop     ES                      ; Segment
        Mov     DI,OFFSET Report        ; Report and
        Rep     MovSB                   ; Report In Use
        Jmp     Exit                    ; on Error Exit

FIRST:  Mov     DI,ICA0                 ; Point to
        Mov     SI,ICA4                 ; ICA and
        Mov     AH,2Ch                  ; Get Current
        Int     21h                     ; DOS Time and
        Mov     ES:[SI+0],CH            ; Store Hours
        Mov     ES:[SI+1],CL            ; Minutes,
        Mov     ES:[SI+2],DH            ; Seconds and
        Mov     ES:[SI+3],DL            ; Hundredths
        Jmp     SHORT DoSig             ; ETHM & Exit

NEXT:   Mov     DI,ICA0                 ; Set ICA
        Mov     SI,ICA4                 ; Pointers and
        Mov     BP,3                    ; Borrow Level
        Mov     AH,2Ch                  ; Get Current
        Int     21h                     ; MS-DOS Time
        Mov     ES:[DI+0],CH            ; Store Hours
        Mov     ES:[DI+1],CL            ; Minutes,
        Mov     ES:[DI+2],DH            ; Seconds and
        Mov     ES:[DI+3],DL            ; Hundredths
        Mov     CX,4                    ; Four Items

ETLp:   Mov     AL,ES:[DI+BP]           ; If Current
        Cmp     AL,ES:[SI+BP]           ; Is => Start
        Jnc     ETOk                    ; Then Ok to Sub
        Add     AL,DS:[ADJUST+BP]       ; Else Adjust
        Call    ETB                     ; by Borrowing
ETOk:   Sub     AL,ES:[SI+BP]           ; Calculate Elapsed
        Mov     ES:[DI+BP],AL           ; Value and Store It
        Dec     BP                      ; Move Left and Loop
        Loop    ETLp                    ; Until Hours are Done

        Mov     SI,OFFSET Report        ; Point to Report
        Mov     AL,ES:[DI+0]            ; Get Elapsed Hours
        Call    AL2ASC                  ; ASCII Decimal Digits
        Mov     [SI+0],AX               ; and Store in Report
        Mov     Byte Ptr [SI+2],":"     ; plus ":" separator
        Mov     AL,ES:[DI+1]            ; Get Elapsed Minutes
        Call    AL2ASC                  ; ASCII Decimal Digits
        Mov     [SI+3],AX               ; and Store in Report
        Mov     Byte Ptr [SI+5],":"     ; plus ":" separator
        Mov     AL,ES:[DI+2]            ; Get Elapsed Seconds
        Call    AL2ASC                  ; ASCII Decimal Digits
        Mov     [SI+6],AX               ; and Store in Report
        Mov     Byte Ptr [SI+8],"."     ; plus "." separator
        Mov     AL,ES:[DI+3]            ; Get Elapsed Hundredths
        Call    AL2ASC                  ; ASCII Decimal Digits
        Mov     [SI+9],AX               ; and Store in Report
DoSig:  Mov     SI,OFFSET ETHM          ; Restore ET
        Mov     CX,4                    ; Signature
        Rep     MovSB
Exit:   Mov     DX,OFFSET Program       ; Display
        Mov     CX,13                   ; "Elapsed Time "
        Call    StdOut
        Mov     DX,OFFSET Report        ; Display
        Mov     CX,12                   ; Report
        Call    StdOut
        Mov     AL,DS:[Report+10]       ; If Last Byte
        Cmp     AL,7                    ; of Report is Bell
        Jz      ELX                     ; Then Error Level 7
        Xor     AL,AL                   ; Else Zero Error Level
ELX:    Mov     AH,4Ch                  ; Exit to MS-DOS with
        Int     21h                     ; Error Level in AL

StdOut: Mov     AH,40h                  ; Output to
        Mov     BX,1                    ; Console
        Int     21h                     ; CX bytes at DX
        Ret

; Borrow from Seconds, Minutes and/or Hours if necessary
ETB:    Sub Byte Ptr ES:[DI+BP-1],1     ; If Borrow Ok
        Jnc ETBX                        ; Then Exit
        Mov DL,DS:[ADJUST+BP-1]         ; Else Increase
        Add ES:[DI+BP-1],DL             ; Next for Borrow
        Cmp DL,24                       ; If was Hours
        Jz  ETBX                        ; Then Done
        Sub Byte Ptr ES:[DI+BP-2],1     ; Else If Next Ok
        Jnc ETBX                        ; Then Exit
        Mov DL,DS:[ADJUST+BP-2]         ; Else Increase
        Add ES:[DI+BP-2],DL             ; Next for Borrow
        CmP DL,24                       ; If was Hours
        Jz  ETBX                        ; Then Done
        Sub Byte Ptr ES:[DI+BP-3],1     ; Else If Next Ok
        Jnc ETBX                        ; Then Exit
        Mov DL,DS:[ADJUST+BP-3]         ; Else Increase
        Add ES:[DI+BP-3],DL             ; Next for Borrow
ETBX:   Ret

AL2ASC: Aam                             ; Make BCD and
        Add     AX,"00"                 ; ASCII Digits
        Xchg    AH,AL                   ; for Storage
        Ret

CODE    EndS
        END     BEGIN
