Title   ArgC.ASM --- Return Command Line Argument Count
Comment ~
        Treats blanks and tabs as whitespace
           and carriage return as terminator.

        Call With:     ES:BX = Command Line

        Returns:          AX = Argument Count=>1
                       Other Registers Preserved
        ~
cr        equ  0Dh            ;ASCII Carriage Return
lf        equ  0Ah            ;ASCII Line Feed
tab       equ  09h            ;ASCII Tab
blank     equ  20h            ;ASCII Space
quote     equ  22h            ;ASCII Quote
          .MODEL    SMALL
          .CODE
     PUBLIC    ArgC
ArgC Proc
          Push BX             ;Preserve Pointer
          Push CX             ;and Counter
          Mov  AX,1           ;Insure => 1 Argument
ArgC1:    Mov  CX,-1          ;Set Outside Argument Flag
ArgC2:    Inc  BX             ;If Next Command Line Character
          Cmp  Byte Ptr ES:[BX],quote
          Jz   ArgC3          ;Is Quote Then Parse Quotation
          Cmp  Byte Ptr ES:[BX],cr ;Else If Carriage Return
          Jz   ArgC5          ;Then Command Line Is Done
          Cmp  Byte Ptr ES:[BX],blank
          Jz   ArgC1          ;Else If Space or Tab
          Cmp  Byte Ptr ES:[BX],tab
          Jz   ArgC1          ;Then Outside Argument
          Jcxz ArgC2          ;Else If Inside Continue Parsing
          Inc  AX             ;Else Count Start of New Argument
          Not  CX             ;Clear Flag to Inside Argument
          Jmp  Short ArgC2    ;Begin Parsing Un-Quoted Argument
ArgC3:    Inc  AX             ;Count Quoted String as Argument
ArgC4:    Inc  BX             ;If Next Command Line Character
          Cmp  Byte Ptr ES:[BX],cr ;Is a Carriage Return
          Jz   ArgC5          ;Then Command Line Is Done
          Cmp  Byte Ptr ES:[BX],quote
          Jnz  ArgC4          ;Else Continue Until Ending Quote
          Jmp  Short ArgC1    ;Then Resume Outside Parsing

ArgC5:    Pop  CX             ;Restore Counter
          Pop  BX             ;and Pointer and
          Ret                 ;Return Argument Count [AX]
ArgC Endp
          END
