Title   SI2Val.ASM -- Get Values from DS:SI String
COMMENT ~
        Call With:  DS:SI = Pointer to String
                       BP = String Bytes Left

        Returns:    DS:SI = Advanced
                       BP = Bytes Left
                       AX = HEX Value
                Zero Flag reflects Value
                Other Registers Preserved
        ~
        .MODEL  small
        .CODE
            PUBLIC  SI2Val
SI2Val  Proc
        push    bx                      ; Preserve
        push    cx                      ; Registers
        xor     bx,bx                   ; Zero Result and
        mov     cx,10                   ; Set Multiplier
ParSIL: dec     bp                      ; If NO More Bytes
        jl      ParSIE                  ; then String Ended
        lodsb                           ; else if
        cmp     al,"0"                  ; byte < "0"
        jc      ParSIX                  ; or if byte
        cmp     al,"9"+1                ; NOT <= "9"
        jnc     ParSIX                  ; then exit
        xor     ah,ah                   ; else make
        sub     al,"0"                  ; word value
        xchg    ax,bx                   ; Adjust Last
        mul     cl                      ; Place and
        add     bx,ax                   ; accumulate
        jmp     SHORT ParSIL            ; until finished
ParSIE: xor     bp,bp                   ; Zero Bytes Left
ParSIX: mov     ax,bx                   ; Get Result
        pop     cx                      ; Restore
        pop     bx                      ; Registers
        or      ax,ax                   ; Test Result
        ret
SI2Val  Endp
        END
