Title   DateHack.ASM - Shows/Sets Computer Date - Calls TimeHack
_TEXT   SEGMENT
        ASSUME CS:_TEXT,DS:_TEXT,ES:_TEXT,SS:_TEXT
        ORG     100H
Main    Proc    Far
        Jmp     Start
Program DB  13,"Date Hack Version 1.0 Copyright (c) 1988"
Useage  DB  13,10," for NON-Commercial Use ONLY!"
        DB  13,10," Use and distribution without change"
        DB  13,10,"  IS authorized and encouraged by"
Author  DB  13,10,9,"Tom Gilbert's Heart&Mind",26
Path    DB  "PATH=",128 DUP (0)
File4B  DB  "TimeHack.COM"                          ; TimeHack Program
MDTbl   DB  0,31,28,31,30,31,30,31,31,30,31,30,31   ; Days / Month
Days    DB  "   Sunday","   Monday","  Tuesday"     ; Day and
        DB  "Wednesday"," Thursday","   Friday"," Saturday"
Mons    DB  "  January"," February","    March"     ; Month Name Tables
        DB  "    April","      May","     June","     July"
        DB  "   August","September","  October"," November"," December"
Msg_St  DB  10,"Use RtLf Arrows to change Month, "
        DB  "UpDn to change Day of Month and +/- for Year"
        DB  13,10,9,9,9,9," <== ESC to EXIT or ENTER to SET this date"
Date    DB  13,32 DUP(32),36            ; CRDayName, MonthName dd, yyyy$
CRLF    DB  13,10,36                                ; New Line String
OldCX   DW  ?                                       ; Entry Year
OldDX   DW  ?                                       ; Month/Day
NewDX   DW  ?                                       ; Month/Day
NewCX   DW  ?                                       ; Year to SET
SStack  DW  ?,?                                     ; Stack Storage
PBlock  DW  0,80h,?,5Ch,?,6Ch,?                     ; Parameter Block
Start:  Mov     AH,9                    ; Display
        Mov     DX,OFFSET Msg_St        ; Complete
        Int     21h                     ; Message
        Mov     AH,2Ah                  ; Get DOS
        Int     21h                     ; Date and
        Mov     OldCX,CX                ; Store Year,
        Mov     OldDX,DX                ; Month & Day
        Mov     NewCX,CX                ; Copy for
        Mov     NewDX,DX                ; Display
ShoDL:  Call    ShowDate
        Call    DoWhat                  ; Process Input
        Cmp     AL,27                   ; If NOT ESCape Key
        Jnz     CkCR                    ; Then Check <ENTER>
        Mov     AH,2Bh                  ; Else Set Date
        Mov     CX,OldCX                ; From Old Year
        Mov     DX,OldDX                ; Month and Day
        Int     21h
        Mov     AH,2Ah                  ; Get Date and
        Int     21h                     ; Day Name to
        Mov     NewCX,CX                ; Restore Year
        Mov     NewDX,DX                ; Month and Day
        Call    ShowDate                ; Display Old Data
        Jmp     SHORT Exit              ; and Exit Unchanged
CkCR:   Cmp     AL,13                   ; If <ENTER>
        Jz      IsCR                    ; Then SET
        Mov     AH,2Ah                  ; Else Get
        Int     21h                     ; DOS Date
        Jnz     ShoDL                   ; and Loop
IsCR:   Call    DoNew                   ; Set Date
        Mov     DL,13                   ; Carriage
        Mov     AH,2                    ; Return
        Int     21h
        Mov     AH,4Ah                  ; Modify Memory
        Mov     BX,4096                 ;  to 64k Block
        Int     21h                     ; If Fails
        Jc      Exit                    ; Then Don't EXEC
        Mov     PBlock[04],AX           ; Else Store Program
        Mov     PBlock[08],AX           ; Segment Address in
        Mov     PBlock[10],AX           ; Parameter Block
        Push    DS                      ; Preserve
        Push    ES                      ; Segments
        Mov     CS:SStack[2],SS         ; and Stack
        Mov     CS:SStack[0],SP         ; Pointer
        Mov     AX,4B00h                ; EXECute with
        Mov     BX,OFFSET PBlock        ; Parameter Block
        Mov     DX,OFFSET File4B        ; TimeHack.COM
        Int     21h
        Mov     SS,CS:SStack[2]         ; Restore Stack
        Mov     SP,CS:SStack[0]         ; Pointer and
        Pop     ES                      ; Segment Registers
        Pop     DS                      ; If EXEC was Ok
        Jnc     Term                    ; Then Terminate
Exit:   Mov     DX,OFFSET CRLF          ; Else End Line
        Mov     AH,9                    ; so Blank Line
        Int     21h                     ; before prompt
Term:   Mov     AX,4C00h                ; Zero Error Level
        Int     21h                     ; Exit to MS-DOS
Main    EndP
MaxDays     Proc
            Mov     AX,NewDX            ; Get Day of Month
            Mov     BL,AH               ; as an Offset to
            Xor     BH,BH               ; Maximum Days
            Add     BX,OFFSET MDTbl     ; per Month Table
            Mov     BL,[BX]             ; Read Day Limit
            Cmp     AH,2                ; If NOT February
            Jnz     Compare             ; Then Compare to BL
            Mov     AX,NewCX            ; Else Get Year Value
            Mov     CX,4                ; Long Division by 4
            Xor     DX,DX               ; Puts Remainder in DX
            Div     CX                  ; If Remainder
            Or      DX,DX               ; Then NOT a
            Jnz     Compare             ; Leap Year
            Inc     BL                  ; Else Leap
Compare:    Cmp     Byte Ptr NewDX,BL   ; If Day Ok
            Jle     MaxDayX             ; Then Exit
            Mov     Byte Ptr NewDX,BL   ; Else Reset
            Call    Beep                ; Ring Bell
            Cmp     Byte Ptr NewDX,BL   ; Zero Flag
MaxDayX:    Ret                         ; and Exit
MaxDays     EndP
DoWhat      Proc
            Mov     AH,7                ; Get a Key
            Int     21h                 ; Without Echo
            Cmp     AL,27               ; If NOT ESCape
            Jnz     DoCR                ; Then Do<ENTER>
            Jmp     DoWx                ; Else Exit
DoCR:       Cmp     AL,13               ; If NOT <ENTER>
            Jnz     AddY                ; Then Try "+"
            Jmp     DoWx                ; Else Exit
AddY:       Cmp     AL,43               ; If "+"
            Jz      Plus                ; Or If a
            Cmp     AL,45               ; Minus "-"
            Jz      Minus               ; Then Process
            Or      AL,AL               ; Else If NOT 0
            Jnz     DoWhat              ; Then Get Again
            Mov     AH,7                ; Else Get the
            Int     21h                 ; Extended Code
            Cmp     AL,72               ; If NOT UpArrow
            Jnz     CkDn                ; Then Check Down
            Call    MaxDays             ; Else If Day Limit
            Jz      DoNew               ; Then Ignore Key
            Inc     Byte Ptr NewDX      ; Else Increment
            Jmp     SHORT DoNew         ; Day of Month
CkDn:       Cmp     AL,80               ; If NOT Dn Arrow
            Jnz     CkRt                ; Then Check Right
            Cmp     Byte Ptr NewDX,1    ; Else If NOT Limit
            Jnz     DoDn                ; Then Sub a Day
            Call    Beep                ; Else Sound Bell
            Jmp     SHORT DoWhat        ;  and Reject Key
DoDn:       Dec     Byte Ptr NewDX      ; Decrement
            Jmp     SHORT DoNew         ; Day of Month
CkRt:       Cmp     AL,77               ; If NOT Right
            Jnz     CkLf                ; Then Check Left
            Cmp     Byte Ptr NewDX[1],12; Else If NOT Limit
            Jnz     IncM                ; Then Increment
            Call    Beep                ; Else Sound Bell
            Jmp     SHORT DoWhat        ;  and Reject Key
IncM:       Inc     Byte Ptr NewDX[1]   ; Increase Month
            Call    MaxDays             ; CheckUp on Day
            Jmp     SHORT DoNew         ; and Reset Date
CkLf:       Cmp     AL,75               ; If NOT Left
            Jnz     DoWhat              ; Then Reject Key
            Cmp     Byte Ptr NewDX[1],1 ; Else If NOT Limit
            Jnz     DecM                ; Then Decrement
            Call    Beep                ; Else Sound Bell
            Jmp     SHORT DoWhat        ;  and Reject Key
DecM:       Dec     Byte Ptr NewDX[1]   ; Decrement Month
            Call    MaxDays             ; CheckUp on Day
            Jmp     SHORT DoNew         ; and Reset Date
Plus:       Cmp     NewCX,2099          ; If NOT Limit
            Jnz     UpYr                ; Then Add Year
            Call    Beep                ; Else Sound Bell
            Jmp     DoWhat              ;  and Reject Key
UpYr:       Inc     NewCX               ; Increment Year
            Jmp     SHORT DoNew         ; Set New Date
Minus:      Cmp     NewCX,1980          ; If NOT Limit
            Jnz     DnYr                ; Then Sub Year
            Call    Beep                ; Else Sound Bell
            Jmp     DoWhat              ;  and Reject Key
DnYr:       Dec     NewCX               ; Decrement Year
DoNew:      Mov     AH,2Bh              ; Set New Date
            Mov     CX,NewCX            ; Using New Year
            Mov     DX,NewDX            ; and Month/Day
            Int     21h
DoWx:       Ret
DoWhat      EndP
Beep        Proc
            Mov     DL,7                ; Ring
            Mov     AH,2                ; Console
            Int     21h                 ; Bell
            Ret
Beep        EndP
BinToDec    Proc
            Mov     CX,10               ; Set Divisor
GetDigit:   Sub     DX,DX               ; Clear Top
            Div     CX                  ; Get Decimal
            Add     DL,"0"              ; ASCII Digit
            Dec     BX                  ; Back-Up Index
            Mov     DS:[DI+BX],DL       ; and Store Digit
            Jnz     GetDigit            ; Until BX Stored
            Ret
BinToDec    EndP
ShowDate    Proc
            Mov     CX,9                ; Calculate
            Mul     CL                  ; Day Offset
            Mov     SI,OFFSET Days      ; Point to Sunday
            Add     SI,AX               ; and add Offset
            Mov     DI,OFFSET Date+1    ; Transfer Day
            Rep     MovSB               ; Name to Date
            Mov     AX," ,"             ; Add a Comma
            StoSW                       ; and a Space
            Mov     AX,NewDX            ; Get Month
            Mov     AL,AH               ; Number as
            Xor     AH,AH               ; Word Value
            Dec     AX                  ; Zero Based
            Mov     CX,9                ; Calculate
            Mul     CL                  ; Month Offset
            Mov     SI,OFFSET Mons      ; Point to January
            Add     SI,AX               ; and add Offset
            Rep     MovSB               ; Transfer MonthName
            Inc     DI                  ; Advance Pointer
            Mov     AX,NewDX            ; Get Day of Date
            Xor     AH,AH               ; and Convert to
            Aam                         ; Two Bytes as
            Add     AX,"00"             ; ASCII Digits
            Xchg    AH,AL               ; in Hi/Lo order
            StoSW                       ; to put in string
            Mov     AX," ,"             ; plus a Comma
            StoSW                       ; and a Space
            Mov     AX,NewCX            ; Get Year
            Mov     BX,4                ; for four
            Call    BinToDec            ; Digit Storage
            Mov     AH,9                ; Display the
            Mov     DX,OFFSET Date      ; Date String
            Int     21h
            Ret
ShowDate    EndP
_TEXT       EndS
            End     Main
