Title   DateBits.ASM -- Converts CX, DX Date Values to DX Date Bit Map
COMMENT~
        Call With:  CX = Year (1980 - 2099)
                    DH = Month (1 - 12)
                    DL = Day (1 - 31)
        Returns:    DX = compressed date in directory entry format
                     y = year bits (0 - 119)
                     m = month bits (1 - 12)
                     d = day bits (1 - 31)
                     <     DH      > <     DL      >
                     y y y y y y y m m m m d d d d d

                    BX and CX are destroyed
        ~
        .MODEL  small
        .CODE
            PUBLIC DateBits
DateBits    Proc
            sub     cx,80               ; If => 80
            jnc     CkCentury           ; then continue
            add     cx,2080             ; else make 20th century
            jmp     SHORT DateBits
CkCentury:  cmp     cx,1900             ; If two digit
            jc      OkYears             ; then is offset
            sub     cx,1900             ; else make offset
OkYears:    shl     cl,1                ; Move to 7 high bits
            mov     bl,dh               ; Let BX hold the
            xor     bh,bh               ; month value and
            mov     dh,cl               ; DX = yyyyyyyxxxxddddd
            mov     cl,5                ; Use CL for Shift Count to
            shl     bx,cl               ; Move Month to Mid 4 digits
            or      dx,bx               ; Combine to Return DX =
            ret                         ; "yyyyyyymmmmddddd"
DateBits    EndP
            END
