Title   ArgV.ASM --- Return Command Line Argument Pointer
Comment ~
        Treats blanks and tabs as Whitespace
           and carriage return as terminator

        Call With:     ES:BX = Command Line Address
                          AX = Zero Based Argument Number

        Returns:       ES:BX = Argument Address
                          AX = Argument Length

        If called with AX=0 (ArgV[0] and running under
        MS-DOS 3.0 or later, returns ES:BX pointing to
        Program Name in Environment Block and AX=length
        Otherwise, returns ES:BX unchanged and AX=0
        ~
cr        equ  0Dh            ;ASCII Carriage Return
lf        equ  0Ah            ;ASCII Line Feed
tab       equ  09h            ;ASCII Tab
blank     equ  20h            ;ASCII Space
quote     equ  22h            ;ASCII Quote
          .MODEL    SMALL
          .CODE
     PUBLIC    ArgV
ArgV Proc
          Push CX             ;Preserve Counter and
          Push DI             ;Destination Index
          Or   AX,AX          ;If Argument Index = 0
          Jz   ArgV8          ;Then Get Program Name
          Xor  AH,AH          ;Else Initialize Argument
ArgV1:    Mov  CX,-1          ;Set Outside Argument Flag
ArgV2:    Inc  BX             ;If Next Command Line Character
          Cmp  Byte Ptr ES:[BX],quote
          Jz   ArgV3          ;Is Quote Then Parse Quotation
          Cmp  Byte Ptr ES:[BX],cr ;Else If Carriage Return
          Jz   ArgV7          ;Then Command Line Is Done
          Cmp  Byte Ptr ES:[BX],blank
          Jz   ArgV1          ;Else If Space or Tab
          Cmp  Byte Ptr ES:[BX],tab
          Jz   ArgV1          ;Then Outside Argument
          Jcxz ArgV2          ;Else If Inside Continue Parsing
          Inc  AH             ;Else Count Start of New Argument
          Cmp  AH,AL          ;If Equal to One Asked for
          Jz   ArgV4          ;Then Get its length
          Not  CX             ;Else Clear Inside Argument Flag
          Jmp  Short ArgV2    ;Begin Parsing Argument
ArgV3:    Inc  AH             ;Count Quoted Argument and
          Mov  CX,BX          ;Preserve its Beginning
ArgV3A:   Inc  BX             ;If Next Command Line Character
          Cmp  Byte Ptr ES:[BX],cr ;Is a Carriage Return
          Jz   ArgV7          ;Then Command Line Is Done
          Cmp  Byte Ptr ES:[BX],quote
          Jnz  ArgV3A         ;Else Parse to Ending Quote
          Cmp  AH,AL          ;If NOT Equal to One Asked For
          Jnz  ArgV1          ;Then Continue From Outside
          Mov  AX,CX          ;Else Provide Beginning and
          Inc  BX             ;Ending Addresses to
          Jmp  Short ArgV6    ;Return Address and Length
ArgV4:    Mov  AX,BX          ;Save Argument Start Address
ArgV5:    Inc  BX             ;If Next Character
          Cmp  Byte Ptr ES:[BX],cr
          Jz   ArgV6          ;Is Carriage Return or Space
          Cmp  Byte Ptr ES:[BX],blank
          Jz   ArgV6          ;Then End Address is Found
          Cmp  Byte Ptr ES:[BX],tab
          Jne  ArgV5          ;Else If NOT Tab Then Continue
ArgV6:    Xchg BX,AX          ;Set ES:BX = Argument Address
          Sub  AX,BX          ;and    AX = Argument Length
          Jmp  Short ArgVx    ;Exit with Information

ArgV7:    Xor  AX,AX          ;Set AX = 0
          Jmp  Short ArgVx    ;for NOT Found Result

ArgV8:    Mov  AX,3000h       ;If MS-DOS
          Int  21h            ;Version is
          Cmp  AL,3           ;Before 3.0
          Jc   ArgV7          ;Then Exit with AX = 0
          Mov  ES,ES:[2Ch]    ;Else Set Environment Segment
          Xor  DI,DI          ;Start at First Environment
          Xor  AL,AL          ;Variable and Skip-Over
          Mov  CX,-1          ;Until Find Program Name
          Cld
ArgV9:    RepNE ScaSB         ;Scan for
          ScaSB               ;Double Null
          Jne  ArgV9
          Add  DI,2           ;Skip Count Word
          Mov  BX,DI          ;Save Program Name Address
          Mov  CX,-1          ;Next Determine Length
          RepNE ScaSB         ;From Next Null
          Not  CX             ;Convert CX to
          Dec  CX             ;Length and
          Mov  AX,CX          ;Return Length in AX
ArgVx:    Pop  DI             ;Restore Pointer
          Pop  CX             ;and Counter and Return
          Ret                 ;[AX]=length ES:BX has address
ArgV Endp
          END
