
; KStat.ASM
; Shows Keyboard Status
;
; Sept. 1992 Edward Mulroy
; Free for all uses

WRITE_CHR       equ     6
WRITE_STR       equ     9
END_PROG        equ     4C00H
CR              equ     13
LF              equ     10
KYBD_FLAG       equ     0417H
TEST_KEY        equ     1
READ_KEY        equ     0
INS_KEY         equ     5200H


_code           segment public byte 'CODE'

                assume  cs:_code,ds:_code
                org     100H

start           proc    near
                mov     ah,WRITE_STR            ; puts( logo);
                mov     dx,offset _code: logo   ;
                int     21H                     ;
                                                ;
                sub     ax,ax                   ;
                mov     es,ax                   ;
                mov     bh,0FFH                 ; bits_b4 = 0xFF;
                                                ;
do_forever:     mov     bl,es:[KYBD_FLAG]       ; bits = keyboard_flag
                cmp     bh,bl                   ; if (bits != bits_b4)
                je      test_keywait            ;   {
                                                ;
                mov     bh,bl                   ;   bits_b4 = bits;
                mov     cx,8                    ;   for (i = 8; i > 0; i--)
                                                ;     {
write_loop:     cmp     cx,4                    ;     if (i == 4)
                jne     show_bits               ;       putchar( ' ');
                                                ;
                mov     dl,' '                  ;
                mov     ah,WRITE_CHR            ;
                int     21H                     ;
                                                ;
show_bits:      rcl     bl,1                    ;     cy = bits; bits <<= 1;
                mov     dl,'1'                  ;     ch = '1';
                jc      write_bit               ;     if (cy == 0)
                                                ;       ch = '0';
                dec     dl                      ;
                                                ;
write_bit:      mov     ah,WRITE_CHR            ;     putchar( ch);
                int     21H                     ;
                loop    write_loop              ;     }
                                                ;
                mov     dl,CR                   ;   putchar( '\r');
                mov     ah,WRITE_CHR            ;
                int     21H                     ;
                                                ;
test_keywait:   push    bx                      ;   if ( !kbhit())
                mov     ah,TEST_KEY             ;     goto do_forever;
                int     16H                     ;
                pop     bx                      ;
                jz      do_forever              ;
                                                ;
                mov     ax,READ_KEY             ;   if ( !getch())
                int     16H                     ;     getch();
                                                ;
                cmp     ax,INS_KEY              ;   if ( keyin == Insert)
                je      do_forever              ;     goto do_forever
                                                ;
                mov     ah,WRITE_STR            ;   putchar( '\n');
                mov     dx,offset _code: crlf   ;
                int     21H                     ;
                                                ;
                mov     ax,END_PROG             ;   return 0;
                int     21H                     ;
start           endp

logo            db      'KStat by Edward Mulroy, 1992',CR,LF
                db      'Keyboard Status Bits'
crlf            db      CR,LF,'$'

_code           ends

                end     start
