
/*************************************************************************

	Mpublic.c		: Simple text parser to build "Public" statements in
						  8086 Assembly language source files. This is useful
						  for creating symbol/map files for debuggers. Compiled
						  with Turbo C++ 1.0. Created by Craig Derouen.
						  Compuserve ID 75136,1261

						  Version 2.0   6/24/90. This version parses proper
						  MASM and TASM (both MASM and IDEAL modes) source files.
						  It will ignore statements inside MACROS,STRUCTURES and
						  local labels.

						  Most of the code is portable ANSI. The only non-standard
						  stuff is the FNSPLIT & FNMERGE functions. There are
						  eqvivalents for these in Microsoft C. You should be able
						  to recompile by changing these & the header file names.
						  All other functions are pure ANSI.

	Usage:           "Mpublic sourcefile [destfile]"

							Sourcefile may be any standard DOS filename. No
							wildcards accepted. Destfile is optional. If not
							specified the source filename is used and '.PUB'
							extension is appended to the name.


*************************************************************************/

#include <stdio.h>
#include <alloc.h>
#include <dir.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#define maxlen 133
#define TRUE 1
#define FALSE 0

void makeparm ( FILE *, char *);

main (int argc,char *argv[])
{
   FILE *infile,*outfile;
	char *strng,*parm1,*parm2,*parm3;
	char temp[81];
	int mflag=FALSE,i;
	int locallab = FALSE;
	int linecnt=1;
	char drive[MAXDRIVE];
	char dir[MAXDIR];
	char file[MAXFILE];
	char ext[MAXEXT];

	printf("MPUBLIC version 2.0, by Craig Derouen\n");

	if (argc <2) {
	   printf ("\007Sorry you must enter a valid filename\n");
		exit(1);
	}
	if ( (infile = fopen(argv[1],"r")) == NULL ) {
	   printf ("\007Sorry,bad filename\n");
		exit(1);
	}
	if (argc < 3) {
	/* No output file specified. Create output file from input filename */
		strcpy(temp,argv[1]); // Copy name to work with
		i = fnsplit(temp,drive,dir,file,ext);
		strcpy(ext,".PUB");
		fnmerge(temp,drive,dir,file,ext);
		if ( (outfile = fopen(temp,"w+")) == NULL ) {
			printf ("\007Sorry, could not open output filename\n");
			exit(1);
		}
	}
	else {
		if ( (outfile = fopen(argv[2],"w+")) == NULL ) {
			printf ("\007Sorry, could not open output filename\n");
			exit(1);
		}
	}
	strng = (char *) malloc(maxlen+1);
	if (strng == NULL) {
		printf("\aSorry, can not allocate enough memory.\n");
		exit(1);
	}

	while (! feof(infile)) {
		fgets(strng,maxlen,infile);
		printf("Processing line number# %d\r",linecnt++);
/* Strip leading whitespace */
      while (isspace(*strng))
			++strng;
		parm1 = strtok(strng," \t\r\n");
		parm2 = strtok(NULL," \t\r\n");

/* Now that we have tokens, parse them out for various types of labels
*	and defines */

		if (!mflag) { // Not inside macro or structure

			if (strcmpi(parm1,"LOCALS") == 0)  // Turn on local labels in Tasm
				locallab = TRUE;

			if (strcmpi(parm1,"IDEAL") == 0) // TASM IDEAL mode
				locallab = TRUE;

			if (strcmpi(parm2,"STRUC") == 0 )
				mflag = TRUE; // Start of structure

			if (strcmpi(parm2,"MACRO") == 0 )
				mflag = TRUE; // Start of macro

			if (strcmpi(parm1,"@@:") == 0)  // MASM style local label
				continue; // Try next line

			i = strlen(parm1); // Look at tail of token
			if (parm1[i-1] == ':') { // Is it a code label?
				parm1[i-1] = '\0'; // Erase colon
				if (locallab) { // Are TASM local lables turned on?
					if (strnicmp(parm1,"@@",2) == 0)
						continue; // TASM local lables have a '@@' prepended
				}
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"PROC") == 0) { // Code label
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"LABEL") == 0) {
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"DB") == 0) { // Data label
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"DW") == 0) { // Data label
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"DD") == 0) { // Data label
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"DQ") == 0) { // Data label
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"DT") == 0) { // Data label
				makeparm(outfile,parm1);
				continue;
			}

			if (strcmpi(parm2,"DF") == 0) { // Data label
				makeparm(outfile,parm1);
				continue;
			}
		}
		else { // We are inside a structure/macro. Look for end
			if (strcmpi(parm2,"ENDS") == 0) // End of structure definition
				mflag = FALSE;

			if (strcmpi(parm1,"ENDM") == 0) // End of macro
				mflag = FALSE;
		}
	}
	printf("\n");
	fclose(infile);
	fclose(outfile);
	return(0);
}

void makeparm (outfile,parm)
FILE *outfile;
char *parm;
{
	static linelen = 0;
	int i;

	if(!linelen) { // Starting over
		fprintf(outfile,"PUBLIC        ");
		linelen = 15; // Track column pos of line. Don't exceed 78 columns
	}

	i = strlen(parm);

	if ((i + linelen) > 78) { // Start over on new line
		fprintf(outfile,"\n"); // Close out line and start newone
		fprintf(outfile,"PUBLIC        ");
		linelen = 15; // Track column pos of line. Don't exceed 78 columns
	}
	if (linelen == 15) // First parm on line?
		fprintf(outfile,"%s",parm); // Don't put comma on leading lable
	else fprintf(outfile,",%s",parm);
	linelen += 1 + strlen(parm);
	return;
}
