;----------------------------------------------------------
; TSR to modem activate carousel switching ---- on ring.
; from the routine to switch carousel work areas.
; usage: modemsw n p
;   n=area number(1-12)   p=port# (1/2)
;
; usage case #2: modemsw r
;   remove from interrupt chain... (but not from memory!)
;
;     ****must be installed BEFORE carousel****
; (assumes work space either is running modem s/w or will boot it)
; (detects ring directly from com port, with a 30 second delay after)
; (switching to allow s/w to answer)
;
;	Presented in public domain, and without warranty, simply for use
; by those sysops like me who like having access to outside commands in DOS
; without pulling down their BBS. (but this assumes your commands are not
; such to disturb the BBS parameters.)
;
; This model is under Borland's Turbo Assembler version 1.01, tiny model,
;   ideal mode.
;
; Resident portion: 375 bytes (including PSP)
;
;--------------------------------------the program
;constants
COM1	EQU	3FEH	;register six only!
COM2	EQU	2FEH
COM3	EQU	3EEH
COM4	EQU	2EEH
;
CODE_SEG	SEGMENT
	ASSUME	CS:CODE_SEG
	ORG	100H
FIRST:	JMP	LOAD_UP
;
;data area
LAST_TIME	DW	0
WORK_AREA	DW	0
OLD_INT		LABEL	WORD
OLD_INT_2	DD	0
COM_PORT	DW	0
PATTERN		DB	'MaB'
;
CHECK_IT	PROC	NEAR
	ASSUME	CS:CODE_SEG,SS:CODE_SEG
	PUSHF
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	ES
	MOV	AX,CS:LAST_TIME	;has it been greater than 30 seconds?
	OR	AX,AX
	JNZ	SOUT2
	MOV	DX,CS:COM_PORT
	IN	AL,DX
	AND	AL,40H		;check ring detect status
	JZ	SOUT1
	MOV	AX,546		;30 seconds
	MOV	CS:LAST_TIME,AX
	MOV	AX,0DF0AH	;id current area
	MOV	DI,'SL'		;and id code
	MOV	DX,DI		;into DX too.
	INT	21h		;call DOS
	MOV	AX,CS:WORK_AREA
	CMP	AL,BL
	JZ	SOUT1		;are we already in it?
	MOV	BX,CS:WORK_AREA
	MOV	AX,0DF01H	;switch to area
	MOV	DI,'SL'		;and id code
	MOV	DX,DI		;into DX too.
	INT	21h		;call DOS
	JMP	SOUT1
SOUT2:	DEC	CS:LAST_TIME
SOUT1:	MOV	AX,40H	;POINT AT ROM AREA
	MOV	DS,AX	;INTO DATA AREA
	MOV	BX,17H
	MOV	AX,DS:[BX]	;GET BYTE
	AND	AX,0EFH		;STRIP SCROLL LOCK
	MOV	DS:[BX],AX	;AND PUT IT BACK
	POP	ES
	POP	DS
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	CALL	CS:OLD_INT_2	;process timer
	IRET
CHECK_IT	ENDP
;
;
LOAD_UP	PROC	NEAR
	ASSUME CS:CODE_SEG,SS:CODE_SEG
	MOV	SI,0080H	;point to line buffer
	CLD			;set direction forward
	LODSB			;get string count
	XOR	AH,AH		;zero high
	MOV	CX,AX		;& set repeat
	MOV	BX,0		;set a zero
	JCXZ	ERROR2		;jump if no string (NO PARMS!)
	INC	SI		;bump pointer
	LODSB			;get character
	CMP	AL,'R'		;test for remove command
	JZ	REMOVE		;and do it
	CMP	AL,'r'
	JZ	REMOVE
;
 	SUB	AL,'0'		;sub '0'
	JBE	ERROR2		;(INVALID!)
	MOV	BL,AL		;move to bl
	DEC	CX		;dec count
	JCXZ	ERROR2		;jump if done (TOO FEW!)
	CMP	AL,1		;then this must be a '1'
	JNZ	LP2		;else goto second test.
	LODSB			;get next char
 	SUB	AL,'0'		;to number
	JB	LP2
	MOV	BL,10		;put 10 in bl
	ADD	BL,AL		;add in lower
LP2:	CMP	BL,12		;higher than 12?
	JA	ERROR2		;yep, error! (INVALID!)
	MOV	WORK_AREA,BX	;hide the area number
LP2Z:	DEC	CX		;bump count again
	JCXZ	ERROR2		;(TOO FEW!)
	LODSB			;bump past space
	CMP	AL,' '
	JZ	LP2Z
	CMP	AL,'1'		;test for com1
	JZ	OK1
	CMP	AL,'2'		;test for com2
	JZ	OK2
	CMP	AL,'3'
	JZ	OK3
	CMP	AL,'4'
	JZ	OK4
ERROR2:	JMP	ERROR1
;
OK1:	MOV	AX,COM1
	JMP	OK0
OK2:	MOV	AX,COM2
	JMP	OK0
OK3:	MOV	AX,COM3
	JMP	OK0
OK4:	MOV	AX,COM4
OK0:	MOV	COM_PORT,AX	;save it so we can remove it
	MOV	AX,351CH	;fetch vector function
	INT	21h		;call dos
	MOV	OLD_INT,BX
	MOV	OLD_INT[2],ES	;stuff old on off
	MOV	DX,OFFSET CHECK_IT
	MOV	AX,CS
	MOV	DS,AX		;don't assume anything!
	MOV	AX,251CH	;set int function
	INT	21h		;set new interrupt
	MOV	DX,OFFSET MESS1
	CALL	PRINT_STR
	MOV	DX,OFFSET LOAD_UP
	INT	27h
;
REMOVE:	MOV	AX,351CH	;test TWO firt
	INT	21h
	MOV	AX,ES
	MOV	DS,AX
	SUB	BX,5		;bump back to com port number
	XCHG	AX,BX
	MOV	SI,AX		;point into driver
	LODSB
	AND	AL,0EFH		;strip off sensitive bit 4
	CMP	AL,0EEH		;test port adress
	JNZ	NOT_IT
	LODSB
	AND	AL,0FEH		;strip off bit 0
	CMP	AL,2
	JNZ	NOT_IT
	LODSB
	CMP	AL,'M'
	JNZ	NOT_IT
	LODSB
	CMP	AL,'a'
	JNZ	NOT_IT
	LODSB
	CMP	AL,'B'		;test for the ID pattern included
	JNZ	NOT_IT
	MOV	AX,1
	OR	AX,COM_PORT
	MOV	COM_PORT,AX
	SUB	SI,9		;bump back to the old vector contents
	LODSW			;get first half
	MOV	DX,AX
	LODSW
	MOV	DS,AX
	MOV	AX,251Ch	;set for resave of vector
	INT	21h
;
NOT_IT:	MOV	AX,COM_PORT	;was either successful?
	OR	AL,AL
	JZ	REM1		;no, oops!
	MOV	DX,OFFSET MESS2	;else say okay...
	JMP	OUT2
REM1:	MOV	DX,OFFSET MESS3
	JMP	OUT2
;
ERROR1:	MOV	DX,OFFSET COPY_RIGHT
OUT2:	CALL	PRINT_STR
	MOV	AX,4C01H
	INT	21h
LOAD_UP	ENDP
;
PRINT_STR	PROC	NEAR
	MOV	AX,CS
	MOV	DS,AX
	MOV	AX,900H
	INT	21h
	RET
PRINT_STR	ENDP
;
COPY_RIGHT	DB	7,13,10,'Modem-Switch v1.2 (C) Mary Bell 1994'
		DB	13,10,'for SoftLogic',27h,'s Software Carousel 6.00'
		DB	13,10,13,10,'usage is: modemsw n p'
		DB	13,10,'   n: work area of modem program (1-12)'
		DB	13,10,'   p: com port number to monitor (1-4)',13,10
		DB	13,10,'to remove use: modemsw r',13,10,13,10,'$'
;
MESS1		DB	13,10,'Modem-Switch installed.',13,10,'$'
;
MESS2		DB	13,10,'Modem-Switch uninstalled.',13,10,'$'
;
MESS3		DB	7,13,10,'Modem-Switch was not installed, or another '
		DB	'program has seized the timer interrupt!',13,10,'$'
;
CODE_SEG	ENDS
	END	FIRST
